(**************************************************************************
** This program appends two files together, writting the appended files out
** to a third file.
*)
program append(output, in1, in2, out);
type
   char_file = file of char;
var
   in1 : char_file;     (* first input file *)
   in2 : char_file;     (* second input file *)
   out : char_file;     (* output file *)

   (*******************************************************************
   ** PURPOSE: Writes the contents of one file into another.
   ** ARGUMENTS:
   **    'f' - the input file
   **    'g' - the output file
   ** NOTES: It is up to the caller to open and close the files.
   *)
   procedure WriteFile(var f, g : char_file);
   var
      c : char;
   begin
      while not eof(f) do
         begin
            read(f, c);
            write(g, c)
         end
   end;

   (**********************************************
   ** PURPOSE: Writes a help screen and then halts
   *)
   procedure syntax;
   begin
      writeln('Appends two files together and writes the output to a third file');
      writeln('Syntax');
      writeln('   ivm append in1 in2 out');
      writeln('where "in1" is the first input file');
      writeln('and   "in2" is the second input file');
      writeln('and   "out" is the output file');
      halt
   end;

begin
   if paramcount <> 3 then
      syntax;
   rewrite(out);        (* Open output file *)
   reset(in1);          (* Open first input file *)
   WriteFile(in1, out); (* Write first input file to output file *)
   close(in1);          (* Close first input file *)
   reset(in2);          (* Open second input file *)
   WriteFile(in2, out); (* Write second input file to output file *)
   close(in2);          (* Close second input file *)
   close(out)           (* Close output file *)
end.
