//****************************************************
// This program uses the built-in procedure crc32
//  to calculate the 32-bit CRC for a file.
// Basically the program asks for the name of the file
// and then it reads the file a character at a time
// passing each byte to crc32.
// Finally it calls crc32 4 times with zero to
//  complete the crc calculation. This is part of
//  the process of calculating CRCs.
//****************************************************
program filecrc(input, output);
var
   fn : filename;
   f : file of char;
   c : char;
   crc : integer;
begin
   write('Enter filename: ');
   readln(fn);
   writeln('Calculating CRC...');
   crc := 0;
   reset(f, fn);
   while not eof(f) do
      begin
         read(f, c);
         crc32(crc, c);
      end;

   crc32(crc, 0);
   crc32(crc, 0);
   crc32(crc, 0);
   crc32(crc, 0);

   writeln('CRC for ', fn, ' is ', crc, ' (', hex(crc), ')');
end.
