;=== GetCPU2.ASM - returns the CPU type as 86, 286,386, or 486 ===
;
;Cliff Brown  8-30-90
;
;=================================================================
;Based on samples and articles from Jeff Prosise @ PC Magazine and
;other misc. code bits from CIS and Ethan Winer @ Crescent Software
;Compiled in MASM 5.1. Tested in QB4.5, BC7.0 and BC7.1
;=================================================================
;
;BASIC use syntax :     DECLARE FUNCTION GetCPU2%
;                       PRINT "CPU = 80"; GetCPU2%

.Model Medium,BASIC
.Code

GetCPU2 Proc
         pushf                           ;Save old flags

         mov     dx,86                   ;Test for 8086
         push    sp                      ;If SP decrements before
         pop     ax                      ;a value is PUSHed
         cmp     sp,ax                   ;it's a real-mode chip
         jne     Exit                    ;8088,8086,80188,80186,NECV20/V30

         mov     dx,286                  ;Test for 286
         pushf                           ;If NT (Nested Task)
         pop     ax                      ;bit (bit 14) in the
         or      ax,4000h                ;flags register
         push    ax                      ;can't be set (in real mode)
         popf                            ;then it's a 286
         pushf
         pop     ax
         test    ax,4000h
         jz      Exit

         mov     dx,386                  ;Test for 386/486
         .386                            ;do some 32-bit stuff
         mov     ebx,esp                 ;Zero lower 2 bits of ESP
         and     esp,0FFFFFFFCh          ;to avoid AC fault on 486
         pushfd                          ;Push EFLAGS register
         pop     eax                     ;EAX = EFLAGS
         mov     ecx,eax                 ;ECX = EFLAGS
         xor     eax,40000h              ;Toggle AC bit(bit 18)
                                         ;in EFLAGS register
         push    eax                     ;Push new value
         popfd                           ;Put it in EFLAGS
         pushfd                          ;Push EFLAGS
         pop     eax                     ;EAX = EFLAGS
         and     eax,40000h              ;Isolate bit 18 in EAX
         and     ecx,40000h              ;Isolate bit 18 in ECX
         cmp     eax,ecx                 ;Is EAX and ECX equal?
         je      A_386                   ;Yup, it's a 386
         mov     dx,486                  ;Nope,it's a 486
A_386:
         push    ecx                     ;Restore
         popfd                           ;EFLAGS
         mov     esp,ebx                 ;Restore ESP
Exit:
         mov     ax,dx                   ;Put CPU type in AX
         popf                            ;Restore old flags
         ret                             ;Return to BASIC

GetCPU2 Endp
End

;==============================================================
