' QualName.Bas - Support module to contain the QualifyName$ function.

' $INCLUDE: 'QUALNAME.BI'
' $INCLUDE: 'QB.BI'

FUNCTION QualifyName$ (InSpec$)
' QualifyName$() - This function takes an incomplete file spec
'                  and returns a fully-qualified pathname.
'                  If the name cannot be qualified, the
'                  original input string is returned instead.
DIM Regs AS RegType
DIM InPath AS STRING * 128
DIM OutPath AS STRING * 128

LSET InPath = ""
LSET OutPath = ""
InPath = InSpec$ + CHR$(0)  ' make an ASCIIZ version of input spec
Regs.AX = &H6000            ' invoke the TRUENAME DOS function
Regs.SI = VARPTR(InPath)
Regs.DI = VARPTR(OutPath)
Interrupt &H21, Regs, Regs
' Check to see if the operation succeded.
IF Regs.Flags AND 1 THEN
  ' Carry set... there was a problem with the name. Just 
  ' return the original specification.
  QualifyName$ = InSpec$
ELSE
  QualifyName$ = MID$(OutPath, 1, INSTR(OutPath, CHR$(0)) - 1)
END IF
END FUNCTION
