' WINDEM.BAS    popup window demonstration program
'
'   Author:     Christy Gemmell
'   For:        QuickBASIC Newsletter
'   Date:       15/7/1991
'
'   $DYNAMIC
'
'   External functions and procedures in ASSEMBLY.LIB/QLB.
'
    DECLARE FUNCTION Attribute% (BYVAL Fore%, BYVAL Back%)
    DECLARE SUB Explode (BYVAL Y1%, BYVAL X1%, BYVAL Y2%, BYVAL X2%,_
                         BYVAL Attr%, BYVAL Speed%)
    DECLARE SUB FastPrint (BYVAL Row%, BYVAL Col%, Message$, BYVAL Attr%)
    DECLARE SUB PopUp (BYVAL Row%, BYVAL Col%, BYVAL Hght%, BYVAL Wdth%,_
                       BYVAL Attr%, BYVAL Brdr%, BYVAL Shdw%, BYVAL Zoom%)
    DECLARE SUB ShutUp (BYVAL Speed%)

'   Local functions and procedures included in this module.
'
    DECLARE FUNCTION Randy% (Lowest%, Highest%)
    DECLARE SUB FlushKey ()

    RANDOMIZE TIMER

'   Draw title and screen background.
'
    CLS : LOCATE , , 0: FastPrint 1, 1, SPACE$(80), 31
    FastPrint 1, 27, "POPUP WINDOW DEMONSTRATION", 31
    FastPrint 2, 1, STRING$(80, ""), 31
    A$ = STRING$(1760, ""): FastPrint 3, 1, A$, 30
    FastPrint 25, 1, SPACE$(80), 48: A$ = ""

'   Overture - pop up and close three batches of windows.
'
    FOR M% = 1 TO 3
        Area% = 0: O% = 0: B% = 1
        DO
            H% = Randy%(5, 10): W% = Randy%(14, 40)
            Area% = Area% + (H% + 1) * (W% + 1)
            IF Area% > 7200 THEN EXIT DO
            K% = Randy%(4, 24 - H%): J% = Randy%(1, 79 - W%)
            R% = Randy%(1, 4): S% = Randy%(1, 4)
            Attrib% = Attribute%(15, B%)
            PopUp K%, J%, H%, W%, Attrib%, R%, S%, -1
            FastPrint K%, J% + ((W% \ 2) - 5), "[ WINDOW ]", Attrib%
            O% = O% + 1: B% = B% + 1: IF B% > 6 THEN B% = 1
         LOOP UNTIL O% = 30
         IF (M% = 3) THEN SLEEP 3 ELSE SLEEP 1
         FOR I% = O% TO 1 STEP -1
             ShutUp -1
         NEXT I%
    NEXT M%

'   Introduction - tell 'em what it's all about.
'
    PopUp 4, 15, 10, 30, 52, 4, 1, -1: PopUp 3, 36, 13, 40, 47, 3, 1, -1
    PopUp 9, 10, 13, 40, 31, 2, 1, -1: PopUp 12, 42, 11, 36, 67, 1, 1, -1
    PopUp 2, 31, 5, 20, 78, 2, 1, -1: FastPrint 4, 34, "Presenting ...", 78
    SLEEP 3: FlushKey: Attrib% = Attribute%(0, 7)
    PopUp 8, 20, 7, 40, Attrib%, 2, 1, -1
    FastPrint 8, 31, "[ QUICK  WINDOWS ]", Attrib%
    FastPrint 10, 29, "Windowing Routines for", Attrib%
    FastPrint 11, 30, "Microsoft QuickBASIC", Attrib%
    SLEEP 3: FlushKey: Attrib% = Attribute%(0, 3)
    PopUp 17, 55, 7, 24, Attrib%, 1, 3, -1
    FastPrint 19, 66, "By", Attrib%
    FastPrint 20, 59, "Christy  Gemmell", Attrib%
    SLEEP 3: FlushKey: Attrib% = Attribute%(14, 1)
    PopUp 13, 2, 10, 23, Attrib%, 2, 4, 0
    FastPrint 15, 4, "A Library of screen", Attrib%
    FastPrint 16, 4, "handling procedures", Attrib%
    FastPrint 17, 4, "and functions which", Attrib%
    FastPrint 18, 4, "can be incorporated", Attrib%
    FastPrint 19, 4, "in your QuickBASIC", Attrib%
    FastPrint 20, 9, "programs.", Attrib%
    SLEEP 4: FlushKey: Attrib% = Attribute%(15, 1)
    PopUp 16, 27, 5, 26, Attrib%, 2, 1, 0
    FastPrint 18, 30, "HOLD ONTO YOUR HATS", Attrib%
    SLEEP 2: FlushKey: FOR I% = 1 TO 9: ShutUp -1: NEXT

'   Start simple - show a plain unadorned window.
'
    Attrib% = 112: PopUp 9, 16, 8, 50, Attrib%, 2, 2, 0: RESTORE
    FOR I% = 10 TO 15: READ Me$: FastPrint I%, 19, Me$, Attrib%: NEXT
    SLEEP 6: FlushKey: Explode 10, 17, 15, 64, Attrib%, 0
    FOR I% = 12 TO 13: READ Me$: FastPrint I%, 19, Me$, Attrib%: NEXT
    SLEEP 5: FlushKey: PopUp 5, 5, 6, 35, Attribute%(1, 2), 0, 1, -1
    SLEEP 3: FlushKey: ShutUp -1: Explode 10, 17, 15, 64, 112, 0
    FOR I% = 12 TO 13: READ Me$: FastPrint I%, 19, Me$, 112: NEXT

'   Demonstrate the full set of border styles.
'
    SLEEP 6: FlushKey: Attrib% = Attribute%(15, 6)
    PopUp 6, 5, 8, 35, Attrib%, 0, 2, -1
    FastPrint 6, 15, "[  No  Frame  ]", Attrib%
    SLEEP 1: FlushKey: Attrib% = Attribute%(11, 1)
    PopUp 7, 8, 8, 35, Attrib%, 1, 2, -1
    FastPrint 7, 17, "[ Frame Style 1 ]", Attrib%
    SLEEP 1: FlushKey: Attrib% = Attribute%(0, 2)
    PopUp 8, 11, 8, 35, Attrib%, 2, 2, -1
    FastPrint 8, 20, "[ Frame Style 2 ]", Attrib%
    SLEEP 1: FlushKey: Attrib% = Attribute%(0, 3)
    PopUp 9, 14, 8, 35, Attrib%, 3, 2, -1
    FastPrint 9, 23, "[ Frame Style 3 ]", Attrib%
    SLEEP 1: FlushKey: Attrib% = Attribute%(14, 4)
    PopUp 10, 17, 8, 35, Attrib%, 4, 2, -1
    FastPrint 10, 26, "[ Frame Style 4 ]", Attrib%
    SLEEP 1: FlushKey: Attrib% = Attribute%(12, 5)
    PopUp 11, 20, 8, 35, Attrib%, 5, 2, -1
    FastPrint 11, 29, "[ Frame Style 5 ]", Attrib%
    SLEEP 1: FlushKey: Attrib% = Attribute%(13, 6)
    PopUp 12, 23, 8, 35, Attrib%, 6, 2, -1
    FastPrint 12, 32, "[ Frame Style 6 ]", Attrib%
    SLEEP 1: FlushKey: Attrib% = Attribute%(15, 2)
    PopUp 13, 26, 8, 35, Attrib%, 7, 2, -1
    FastPrint 13, 35, "[ Frame Style 7 ]", Attrib%
    SLEEP 1: FlushKey: Attrib% = Attribute%(1, 3)
    PopUp 14, 29, 8, 35, Attrib%, 8, 2, -1
    FastPrint 14, 39, "[ Frame Style 8 ]", Attrib%
    SLEEP 4: FlushKey: FOR I% = 1 TO 9: ShutUp -1: NEXT
 
'   Display the range of foreground colours
' 
    Explode 10, 17, 15, 64, 112, 0
    FOR I% = 11 TO 13: READ Me$: FastPrint I%, 20, Me$, 112: NEXT
    SLEEP 6: FlushKey
    FOR I% = 1 TO 15
        Label$ = "[ Colour:" + STR$(I%) + " ]"
        J% = Randy%(1, 51): K% = Randy%(1, 13)
        Attrib% = Attribute%(I%, 0)
        PopUp K% + 1, J% + 1, 7, 24, Attrib%, 4, 0, 0
        FastPrint K% + 1, J% + 6, Label$, Attrib%
        SLEEP 1: FlushKey
    NEXT I%
    Attrib% = Attribute%(31, 1)
    PopUp 7, 20, 7, 24, Attrib%, 4, 2, 0
    FastPrint 7, 25, "[ Colour: 31 ]", Attrib%
    SLEEP 4: FlushKey: FOR I% = 1 TO 16: ShutUp 0: NEXT
 
'   Demonstrate left and right shadow.
'
    Explode 10, 17, 15, 64, 112, 0
    FOR I% = 12 TO 13: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    SLEEP 6: FlushKey: PopUp 2, 2, 11, 30, Attribute%(15, 1), 7, 0, 0
    SLEEP 3: FlushKey: ShutUp 0: Explode 10, 17, 15, 64, 112, 0
    FOR I% = 12 TO 13: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    SLEEP 6: FlushKey: Attrib% = Attribute%(14, 5)
    PopUp 5, 5, 10, 30, Attrib%, 2, 1, 0
    FastPrint 9, 14, "Left Shadow", Attrib%
    SLEEP 2: FlushKey: Attrib% = Attribute%(0, 2)
    PopUp 5, 45, 10, 30, Attrib%, 2, 2, 0
    FastPrint 9, 54, "Right Shadow", Attrib%
    SLEEP 2: FlushKey: ShutUp 0: ShutUp 0
 
'   Demonstrate zooming and imploding windows.
'
    Explode 10, 17, 15, 64, 112, 0
    FastPrint 12, 31, "Windows can be zoomed", 112
    FastPrint 13, 33, "onto the screen.", 112
    SLEEP 3: FlushKey: PopUp 2, 2, 15, 60, Attribute%(0, 2), 2, 0, -1
    SLEEP 2: FlushKey: PopUp 13, 10, 10, 60, Attribute%(0, 3), 3, 0, -1
    SLEEP 2: FlushKey: PopUp 7, 33, 10, 45, Attribute%(14, 5), 1, 0, -1
    SLEEP 2: FlushKey: Attrib% = Attribute%(15, 4)
    PopUp 9, 10, 12, 63, Attrib%, 2, 1, -1
    FastPrint 14, 32, "<<< W O W >>>", Attrib%
    SLEEP 3: FlushKey: FOR I% = 1 TO 4: ShutUp -1: NEXT

'   Demonstrate overlapping windows.
'
    Explode 10, 17, 15, 64, 112, 0
    FOR I% = 10 TO 14: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    SLEEP 6: FlushKey: Explode 10, 17, 15, 64, 112, 0
    FOR I% = 10 TO 15: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    SLEEP 6: FlushKey: Explode 10, 17, 15, 64, 112, 0
    FOR I% = 10 TO 15: READ Me$: FastPrint I%, 19, Me$, 112: NEXT
    SLEEP 6: FlushKey: Attrib% = Attribute%(0, 2)
    PopUp 3, 5, 15, 45, Attrib%, 4, 1, -1
    FastPrint 9, 14, "This is the first level ...", Attrib%
    SLEEP 2: FlushKey: Attrib% = Attribute%(15, 4)
    PopUp 6, 29, 17, 50, Attrib%, 4, 1, -1
    FastPrint 12, 40, "This is the second level ...", Attrib%
    SLEEP 2: FlushKey: Attrib% = Attribute%(0, 3)
    PopUp 9, 22, 15, 35, Attrib%, 4, 1, -1
    FastPrint 16, 26, "This is the third level ...", Attrib%
    SLEEP 2: FlushKey: FastPrint 16, 26, "Now to go back ...         ", Attrib%
    SLEEP 1: ShutUp -1: SLEEP 1: ShutUp -1: SLEEP 1: ShutUp -1: SLEEP 2
    ShutUp -1: PopUp 4, 15, 10, 30, 52, 4, 1, -1

'   A word from our sponsor.
'
    PopUp 3, 36, 13, 40, 47, 3, 1, -1: PopUp 9, 10, 13, 40, 78, 2, 1, -1
    PopUp 12, 42, 11, 36, 67, 1, 1, -1: PopUp 9, 16, 8, 52, 112, 2, 1, -1
    FastPrint 11, 20, "The video routines in ASSEMBLY Library", 112
    FastPrint 12, 20, "give you all you need to create powerful", 112
    FastPrint 13, 20, "and professional screen displays in your", 112
    FastPrint 14, 20, "QuickBASIC programs.", 112: SLEEP 9: FlushKey
    FOR I% = 1 TO 5: ShutUp -1: SLEEP 1: FlushKey: NEXT
END

'Ŀ
'  Local procedures and functions.                                       
'
'
'   Returns a random integer between the limits specified.
'
FUNCTION Randy% (Lowest%, Highest%) STATIC
    Randy% = INT(RND * ((Highest% - Lowest%) + 1)) + Lowest%
END FUNCTION    

'   Flush all keystrokes from the keyboard typeahead buffer
'
'   Note:   this is used in conjunction with the SLEEP function since,
'           if the user terminates a SLEEP delay by pressing a key, the
'           keystroke is not automatically removed from the buffer.
'
SUB FlushKey () STATIC
    DO: LOOP UNTIL INKEY$ = ""
END SUB

'Ŀ
'  Data Division.                                                        
'
'
DATA "These QBNews ASSEMBLY libraries provide you"
DATA "with all the facilities necessary for you to"
DATA "implement a full range of window features in"
DATA "your programs.  With just one statement, for"
DATA "instance, you can 'Pop-up' a window onto the"
DATA "screen."
DATA "The window can be a simple rectangle, in any"
DATA "the QuickBASIC background colors, such as .."
DATA "Alternatively it may have a border in one of"
DATA "eight styles ...."
DATA "The border itself may be in any one of the"
DATA "QuickBASIC foreground colors. It can blink"
DATA "if you want it to ..."
DATA "The window, too, can be presented in several"
DATA "different ways. It can be flat..."
DATA "or it can have a black shadow underneath, to"
DATA "give a three-dimensional effect..."
DATA "Once you have a window on the screen, simply"
DATA "use FASTPRINT, also in the ASSEMBLY Library,"
DATA "to put text into it, in any colour you like."
DATA "You can also use EXPLODE from the same place"
DATA "to clear the window's contents."
DATA "All the functions in the Library are written"
DATA "in fast assembly language, but this does not"
DATA "prevent them from being very easy to use."
DATA "This for instance, is the call to create the"
DATA "present window ....."
DATA "   PopUp 8, 14, 8, 52, 112, 2, 0, -1"
DATA "Before opening a window, the function stores"
DATA "the screen beneath it in an internal buffer."
DATA "When you close a window, the screen contents"
DATA "are restored to their original location. Use"
DATA "the statement 'ShutUp -1' to close the last"
DATA "window opened.  For example ...."

'Ŀ
'      (c) 1991 By Christy Gemmell and Singular Software.                
'

