DEFINT A-Z
'+==================================================================+
'|                           EDITDEMO.BAS                           |
'|                                                                  |
'|  Purpose:  Test program to test the routines in VIDTOOLS.BAS     |
'|                                                                  |
'|  Modules:  LINEEDIT (Main)                                       |
'|            KEYBOARD                                              |
'|            VIDTOOLS                                              |
'|                                                                  |
'|  $INCLUDE file:  'tools.bi'                                      |
'+------------------------------------------------------------------+

'+==================================================================+
'|                           DECLARATIONS                           |
'+------------------------------------------------------------------+

'$INCLUDE: 'tools.bi'

DECLARE SUB LineEdit (Row%, Col%, CurPos%, A$, VwindowSize%, DisplayLen%, CurOffset%, Kee%, Separaters$, Terminators(), EditMask$, AutoTerminate%)

CONST True = -1
CONST False = 0

'+==================================================================+
'|                        INITIALIZATION  CODE                      |
'+------------------------------------------------------------------+

    DIM Frame AS Frame                  'Let's get fancy
    DIM Terminators(10)                 'Make room for ten terminators
   
    '---- Initialize EditStrings
    MaxChoice = 9
    DIM EditStrings$(1 TO MaxChoice)
    DIM CurPostions(1 TO MaxChoice)
    DIM CurOffset%(1 TO MaxChoice)
    DIM EditRow%(1 TO MaxChoice)
    DIM EditCol%(1 TO MaxChoice)
    DIM WindSize%(1 TO MaxChoice)
    DIM DisplaySize%(1 TO MaxChoice)
    DIM EditMask$(1 TO MaxChoice)
    
    '---- Get the default Insert state.
    InsIsOn% = InsertState%
    
    GOSUB DefineEditorVariables
    GOSUB DrawInputScreen
    
'+==================================================================+
'|                              MAIN LOGIC                          |
'+------------------------------------------------------------------+
    
    Choice = 1               'Designate first edit choice
    DO
        '---- AutoTerminate, when true, forces exit at end of field
        AutoTerminate = False
        IF Choice = 5 OR Choice = 6 OR Choice = 7 THEN AutoTerminate = True
       
        '---- Call the Line Editor with appropriate strings, choices, etc.
        LineEdit EditRow%(Choice), EditCol(Choice), CurPostions(Choice), EditStrings$(Choice), WindSize(Choice), DisplaySize(Choice), CurOffset%(Choice), LastKey%, Separaters$, Terminators(), EditMask$(Choice), AutoTerminate%
        
        '---- Restore the screen line before moving on.
        COLOR 15, 5
        LOCATE EditRow%(Choice), EditCol(Choice)
        PRINT LEFT$(EditStrings$(Choice) + SPACE$(DisplaySize(Choice)), DisplaySize(Choice))

        BotRowReached = False
        IF Choice = MaxChoice THEN BotRowReached = True

        IF LastKey% = -72 THEN Choice = Choice - 1           'Up
        IF Choice < 1 THEN Choice = MaxChoice                'Wrap to last
        IF LastKey = -73 THEN Choice = 1                     'PgUp

        IF LastKey% = 13 THEN Choice = Choice + 1            'Enter
        IF LastKey% = -80 THEN Choice = Choice + 1           'Down
        IF Choice > MaxChoice THEN Choice = 1                'Wrap to first
        IF LastKey% = -81 THEN Choice = MaxChoice            'PgDn
        
    LOOP UNTIL ((BotRowReached AND LastKey = 13) OR LastKey = 27)

    '---- Restore the screen
    COLOR 7, 0: CLS                         'Clear the screen
    TurnInsertOn InsIsOn%                   'Reset insert to original

    '---- Prove changes were made by redisplaying all edit strings
    FOR N = 1 TO MaxChoice
        PRINT EditStrings$(N)
    NEXT
    
    END                                     'And, we're out of here!

'+==================================================================+
'|                           SUB ROUTINES                           |
'+------------------------------------------------------------------+

DrawInputScreen:
    CLS

    Frame.boxType = 2: Frame.filClr = 3     'Define the frame parameters
    Frame.fore = 15: Frame.back = 1
    Frame.lftCol = 1: Frame.rgtCol = 80
    Frame.tRow = 1: Frame.bRow = 13

    Box Frame                               'Draw frame for input fields

    Frame.back = 4: Frame.filClr = 4
    Frame.tRow = 15: Frame.bRow = 19
    Frame.boxType = 4: Box Frame            'Draw frame for edit help box

    COLOR 1, 3                              'Tell user what process is
    LOCATE 3, 32
    PRINT "Edit Data Routine"

    LOCATE 11, 3: COLOR 4, 3                'Display brief help message
    PRINT "Use: "; CHR$(24); " "; CHR$(25); " PgUp PgDn.  <Enter> on last entry to process changes.  <Esc>: Abort"

    COLOR 15, 3                             'Finish setting up the form
    LOCATE 5, 3: PRINT "Last/First => ";
    LOCATE , 37: PRINT ","
    LOCATE 6, 3: PRINT "Address => "
    LOCATE 7, 3: PRINT "Telephone => (   )   -";
    LOCATE 8, 3: PRINT "Memo => "
    LOCATE 9, 3: PRINT "Save To => "

    COLOR 15, 4                             'Messages inside of Help Box
    LOCATE 16, 33: PRINT "Editor Commands"
    LOCATE 17, 4
    PRINT "Scroll line:    "; CHR$(16); "    "; CHR$(17); "    <Home>    <End>    <Ctrl> + "; CHR$(16); "    <Ctrl> + "; CHR$(17); ""
    LOCATE 18, 4
    PRINT "Delete with:    <Delete>    <Backspace>   <Ctrl> + <Home>   <Ctrl> + <End>"

    COLOR 15, 5
    FOR N = 1 TO MaxChoice
        LOCATE EditRow%(N), EditCol(N)
        PRINT LEFT$(EditStrings$(N) + SPACE$(DisplaySize(N)), DisplaySize(N))
    NEXT
RETURN

DefineEditorVariables:
    '---- Initialize LineEdit's Terminators array.  Terminators are
    '     REQUIRED by the editor.  The zeroeth element of the array
    '     defines how many elements the editor will use.
    Terminators(False) = 5              'Only using first 5 for right now
    Terminators(1) = 27                 'Terminate on Esc key
    Terminators(2) = -72                'Terminate on Up arrow
    Terminators(3) = -80                'Terminate on Down arrow
    Terminators(4) = -73                'Terminate on Page Up
    Terminators(5) = -81                'Terminate on Page Down

    '---- These terminators are not used in this demo example.  We've
    '     DIMmed Terminators (10) so 2 more can still be defined.
    Terminators(6) = -132               'Terminate on Ctrl + Page Up
    Terminators(7) = -118               'Terminate on Ctrl + Page Down
    Terminators(8) = -68                'Terminate on F10 key

    '---- Initialize LineEdit's word separater string
    Separaters$ = " .:-(){}\/"

    '---- Define some data.  Note data could be retrieved from file or DATA
    EditStrings$(1) = "Stone"
    EditRow%(1) = 5
    EditCol(1) = 17
    WindSize(1) = False
    DisplaySize(1) = 20
    '---- "A*" + string "a"
    EditMask$(1) = LEFT$("A*" + STRING$(DisplaySize(1), 97), DisplaySize(1))
    
    EditStrings$(2) = "Lawrence"
    EditRow%(2) = 5
    EditCol(2) = 39
    WindSize(2) = False
    DisplaySize(2) = 20
    '---- "A" + string "*"
    EditMask$(2) = LEFT$("A" + STRING$(DisplaySize(2), 42), DisplaySize(2))

    EditStrings$(3) = "1234"
    EditRow%(3) = 6
    EditCol(3) = 14
    WindSize(3) = False
    DisplaySize(3) = 9
    EditMask$(3) = STRING$(DisplaySize(3), "8")
    
    EditStrings$(4) = "Main Street"
    EditRow%(4) = 6
    EditCol(4) = 24
    WindSize(4) = False
    DisplaySize(4) = 35
   
    EditStrings$(5) = "503"
    EditRow%(5) = 7
    EditCol(5) = 17
    WindSize(5) = False
    DisplaySize(5) = 3
    EditMask$(5) = STRING$(DisplaySize(5), "9")

    EditStrings$(6) = "756"
    EditRow%(6) = 7
    EditCol(6) = 21
    WindSize(6) = False
    DisplaySize(6) = 3
    EditMask$(6) = STRING$(DisplaySize(6), "9")
    
    EditStrings$(7) = "5935"
    EditRow%(7) = 7
    EditCol(7) = 25
    WindSize(7) = False
    DisplaySize(7) = 4
    EditMask$(7) = STRING$(DisplaySize(7), "9")

    EditStrings$(8) = "Now is the time for all good men to come to the aid of their "
    EditStrings$(8) = EditStrings$(8) + "fellow countrymen.  In the land of the blind, the one-"
    EditStrings$(8) = EditStrings$(8) + "eyed man is king.  Good QB programmers always respond "
    EditStrings$(8) = EditStrings$(8) + "to a challange and, in so doing, become better programmers."
    EditRow%(8) = 8
    EditCol(8) = 11
    WindSize(8) = 300
    DisplaySize(8) = 67
    
    EditStrings$(9) = "C:\BASIC\STUFF\PERSONAL.DAT"
    EditRow%(9) = 9
    EditCol(9) = 14
    WindSize(9) = False
    DisplaySize(9) = 64
RETURN

'+==================================================================+
'|                            SUBPROGRAMS                           |
'+------------------------------------------------------------------+

