'$MODULE: 'TIMERS'
'$INCLUDE: 'fnCTICKS.def'
'*** end of DELAY
'*****************************************************************************
'*** end of BGDELAY
'*****************************************************************************

REM $DYNAMIC
SUB BGDELAY (HUN.SCNDS!, HUN.SCNDS.TO.GO!, status%) STATIC
'----------------------------------------------------------------------------
' BigDelay Procedure: Performs a background delay, returning control to the
' caller after each check so that the caller may be doing something while
' waiting.
'----------------------------------------------------------------------------
'$MODULE: 'bgDELAY'
' input:  an integer representing the number of hundredth-seconds to delay
' delay == input: HUN.SCNDS! = hundredths of seconds
'         output: HUN.SCNDS.TO.GO! = hundredths of seconds until timeout
'         output: STATUS%   = 0 - delay is complete; 1 - delay is continuing
'/==========================================================================/
'$INCLUDE: 'TICKS.def'

STATIC START.TIME!, ENDING.TIME!
IF status% = 0 THEN             'entering for the first time this request
		  START.TIME! = FNCTICKS(0)                  ' mark the current time
		  ENDING.TIME! = FNCTICKS(HUN.SCNDS!)        ' mark the ending time
		  IF ENDING.TIME! < START.TIME! THEN
					 ENDING.TIME! = ENDING.TIME! + TICKS.PER.DAY!
		  END IF
END IF

CURRENT.TIME! = FNCTICKS(0)
IF CURRENT.TIME! < START.TIME! THEN
		  CURRENT.TIME! = CURRENT.TIME! + TICKS.PER.DAY!
END IF
TICKS.LEFT! = ENDING.TIME! - CURRENT.TIME!       'calculate ticks left to go
HUN.SCNDS.TO.GO! = (TICKS.LEFT! * 100) / TICKS.PER.SEC!' see Tech.Ref.

IF TICKS.LEFT! > 0 THEN
		  status% = 1                         ' time has NOT run out
ELSE
		  status% = 0                         ' delay is complete
END IF

exitsub:
EXIT SUB
END SUB

SUB DELAY (HUN.SCNDS!) STATIC
'----------------------------------------------------------------------------
' Delay Procedure: Performs a "hard" delay.
' $MODULE: 'DELAY'
' input:  an integer representing the number of hundredth-seconds to delay
' delay == input: HUN.SCNDS! = hundredths of seconds
'----------------------------------------------------------------------------
'$INCLUDE: 'TICKS.def'

START.TIME! = FNCTICKS(0)                     ' mark the current time
ENDING.TIME! = FNCTICKS(HUN.SCNDS!)           ' mark the ending time
IF ENDING.TIME! < START.TIME! THEN
    ENDING.TIME! = ENDING.TIME! + TICKS.PER.DAY!
END IF

DO
    CURRENT.TIME! = FNCTICKS(0)               ' mark the current time
    IF CURRENT.TIME! < START.TIME! THEN
       CURRENT.TIME! = CURRENT.TIME! + TICKS.PER.DAY!
    END IF
LOOP UNTIL CURRENT.TIME! >= ENDING.TIME!

EXIT SUB
END SUB

