;RM82TS8,16,24,32,40,48,56,64
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.MODEL MEDIUM, BASIC
.data
	EVEN
	EXTRN   B$DVIDEOSEG:WORD
	EXTRN   B$DVIDEOPORT:WORD
	EXTRN   B$DVIDEOINSTL:BYTE
.code

INCLUDE NOWAIT.INC
EXTRN   Get_Adapter:FAR

msr_values      db 2ch,28h,2dh,29h	; reprogram CGA values
		db 2AH,2eh,1eh,29h      ; when turn CGA back on

;=======================================================================
; DECLARE SUB RSCROLL (BYVAL Attribute%)
; CALL RSCROLL(Attribute%)
; Scrolls screen right
; Mostly for fun.  To be really useful would have to set it up for windows
; and would have to print using VPRINT.
; Designed to handle an 80 x 25 text display
;=======================================================================

EVEN
RSCROLL Proc FAR BASIC USES DI SI, ATTRIB:Ptr
	Push	DS		; save it ourselves so we can control
				; DGROUP addressibility
	Pushf                   ; save state of direction flag
				; QBASIC requires it to be cleared
	Cmp     B$DVIDEOINSTL,1 ; See if we have done this before
	JE      Didit           ; yep, so skip ahead
	Call    Get_Adapter     ; call routine to find display type

Didit:
	Mov     BX,B$DVIDEOSEG  ; restore the initialized values
	Mov     ES,BX		; set ES == Video Segment
	Mov     DX,B$DVIDEOPORT ; puts 0 in DX if not snowy CGA
	Mov     AX,ATTRIB       ; get the color ATTRIBUTE% that was passed
				; (Variable must be passed by value)
	Mov     AH,AL           ; put it into AH for screen writing below
				; delay changing DS until finish reading stack
	Mov     DS,BX           ; store start of video buffer in DS
	Mov     CX,25           ; number of lines to clear
	Or	DX,DX		; is this a snowy CGA?
	JZ	Not_CGA		; if DX=0 then no

CGA_Off:
	Mov	BX,AX		; save AX in BX, following routine destroys AX
	CLI                     ; prevent interrupts to speed routine
	Wait_CGA_Retrace	; wait for CGA retrace MACRO
	Mov     DX,03D8h        ; load CGA mode control register
	Mov     AL,00000001b    ; display = off if bit 3 = 0
	Out     DX,AL
	STI			; turn interrupts back on
	Mov	AX,BX		; restore AX

Not_CGA:
	Mov     DI,158          ; load offset of right hand column
	Mov     AL,20h          ; load the space character

EVEN
Fill_Space:
	Stosw                   ; fill right hand column of display
	Add     DI,158          ; skipping down each row (Stosw already 
				; increments one character)
	Loop    Fill_Space      ; loop for 25 rows

	Mov     CX,2000         ; number of words to move
	Mov     SI,3998         ; start       DS:SI
	Mov     DI,4000         ; destination ES:DI
	Std                     ; set direction flag to count down
	Rep     Movsw           ; move all bytes "up in memory" two bytes
	Mov     DS:[00],AX      ; store a space at beginning
	Popf                    ; restore direction flag
	Pop	DS		; restore addressibility of stack
	Mov     DX,B$DVIDEOPORT ; load address of CGA retrace port
	Or	DX,DX		; Is it a snowy CGA?
	JZ	Finis		; nope

CGA_On:				; else is snowy CGA
	CLI			; prevent interrupts to speed routine
	Mov     DX,03D8h        ; load CRT Mode Control port addresss
	Mov     AH,0Fh		; get current video mode
	Int     10h
	LEA     BX,msr_values	; Point BX to msr_values table
	Xlat    msr_values	; load table value depending on
				; current CGA video mode in AL
	Out     DX,AL		; do it
	STI			; turn interrupts back on

Finis:
	Ret                     ; remove one parameter (MASM does it)
RSCROLL ENDP

;=======================================================================
; DECLARE SUB LSCROLL (BYVAL Attribute%)
; CALL LSCROLL(Attribute%)
; Scrolls screen left
; Mostly for fun.  To be really useful would have to set it up for windows
; and would have to print using VPRINT.
; Designed to handle an 80 x 25 text display
;=======================================================================

EVEN
LSCROLL Proc FAR BASIC USES DI SI, ATTRIB:Ptr
	Push	DS		; push it ourselves to control return
				; of DGROUP addressibility
	Cmp     B$DVIDEOINSTL,1 ; See if we have done this before
	JE      Didit1          ; yep, so skip ahead
	Call    Get_Adapter     ; call routine to find display type

Didit1:
	Mov     BX,B$DVIDEOSEG  ; restore the initialized values
	Mov     ES,BX
	Mov     DX,B$DVIDEOPORT ; puts 0 in DX if not CGA
	Mov     AX,ATTRIB       ; get the color ATTRIBUTE% that was passed
	Mov     AH,AL           ; put it into AH for screen writing below
				; delay changing DS until finish reading stack
	Mov     DS,BX           ; store start of video buffer in DS
	Mov     CX,25           ; number of lines to clear
	Or	DX,DX		; is this a snowy CGA?
	JZ	Not_CGA1	; if DX=0 then no snowy CGA

CGA_Off1:
	Mov	BX,AX		; save AX in BX following routine destroys AX
	CLI                     ; prevent interrupts to speed routine
	Wait_CGA_Retrace	; wait for CGA retrace MACRO
	Mov     DX,03D8h        ; load CGA mode control register
	Mov     AL,00000001b    ; display = off if bit 3 = 0
	Out     DX,AL
	STI			; turn interrupts back on
	Mov	AX,BX		; restore AX

Not_CGA1:
	
	Xor     DI,DI           ; load offset of left hand column
	Mov     AL,20h          ; load the space character

EVEN
Fill_Space1:
	Stosw			; fill left hand column of display
	Add     DI,158		; skipping down each row (Stosw already 
				; increments one character)
	Loop    Fill_Space1     ; loop for 25 rows

	Mov     CX,2000         ; number of words to move
	Mov     SI,2            ; start       DS:SI
	Mov     DI,0            ; destination ES:DI
	Cld                     ; clear direction flag to count up
	Rep     Movsw           ; move all bytes "backwards" two bytes
	Mov     DS:[3998],AX    ; store a space at end of bottom row
	Pop	DS		; restore addressibility of DGROUP
	Mov     DX,B$DVIDEOPORT ; get address of CGA retrace port
	Or	DX,DX		; Is it a snowy CGA?
	JZ	Finis1 		; nope

CGA_On1:			; else is snowy CGA
	CLI			; prevent interrupts to speed routine
	Mov     DX,03D8h        ; load CRT Mode Control port addresss
	Mov     AH,0Fh		; get current video mode
	Int     10h
	LEA     BX,msr_values	; Point BX to msr_values table
	Xlat    msr_values	; load table value depending on
				; current CGA vid mode in AL
	Out     DX,AL		; do it
	STI			; turn interrupts back on

Finis1:

	Ret                     ; remove one parameter
LSCROLL ENDP
END
