;RM82TS8,16,24,32,40,48,56,64
; Updated 11/20/90

;=======================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;                   All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;-----------------------------------------------------------------------
; Function prototype in QBASIC
; DECLARE FUNCTION VideoStat% ()
;
; VideoStatus Analyzer
; Program returns video information for use by QBASIC
; returns highest level of SCREEN mode supported by the Hardware.
; Returns information about the PRIMARY display only
; This routine with a select case, can tell you how many display pages
; are available in text mode, SCREEN 0:
; VGA has 8 pages
; EGA with > 64kb has 8 pages
; EGA with 64kb has 4 pages
; CGA has 4 pages
; MONO has 1 pages
; HERC has 1 page in SCREEN 0, 2 pages in SCREEN 3
;
; Exceptions:
; MCGA color returns a mode 11, so can contrast w/ VGA
; HERC w/o MSHERC.COM reports a -3 so you can tell user to correct matters
; COMPAQ with CGA reports -2 so can force use of monchrome attributes.
; EGA's with CGA diplays report -8 if have only 64kb of memory
; EGA's with ECD display report  8 if have only 64kb of memory
;
; Returns:
; Mono         =   0
; CGA          =   2
; PGA          =   2   (Untested, assume PGA would be treated as CGA)
; COMPAQ - CGA =  -2   to tell that user may have a single color display
; HERC         =   3   if have HERC and MSHERC.COM
; HERC         =  -3   if have HERC but w/o MSHERC.COM
; AT&T         =   4,  but only if have just CGA display, not EGA or VGA
;     Microsoft QuickC/C makes Olivetti EGA and VGA return a separate code.
;     I don't know why anyone would care if the EGA/VGA emulation were
;     good.
;
; EGA64        =   8   Because resolution limited for 64k EGA
; EGA64 w/CGA  =  -8   Because resolution limited to CGA modes
; EGA          =   9   Have minimum of 128kb of video ram
; EGA w/CGA    =  -9   Since resolution limited to CGA modes
; MCGA         =  11   If have an analog color display
; MCGA         = -11   If have an EGA ECD digital color display, since
;                      resolution of this display is limited to EGA modes
; VGA          =  13
; EGA/VGA mono =  10   I guess will catch MCGA mono too
;
; Version 0.92
;
; Tested:     CGA, HERC clone, EGA mono, EGA color, VGA color, COMPAQ CGA,
;             VGA clone, EGA clone (Paradise clone, ATI EGA Wonder), AT&T 6300
; Not tested: PGA, VGA monochrome, MCGA (color or monochrome)
;=======================================================================

DOSSEG          ;I have had problems unless this is used
.model medium   ;I use QUICK C / QUICK ASM which uses MASM 5.1 simplified
.code           ;directives

	public VIDEOSTAT

HERC_PORT       Equ     03bah       ; Herc display status port
COMPAQ          DB     'COMPAQ'     ; BIOS ID string in COMPAQ's
COMPAQ_LEN      Equ     6           ; length of string

;Following is commented out because alternative method is faster
;ATT             DB     'OLIVETTI'   ; BIOS ID string for OLIVETTI/AT&T
;ATT_LEN         Equ     8           ; length of string

; Please do not remove
Copyright       DB    13,10,'Copyright Copr. (C) 1990 Sidney J. Kelly',13,10
Copyright1      DB    'All Rights Reserved',13,10,26

EVEN
VIDEOSTAT   PROC far
     Push    BP                 ; save BP because old PC Video BIOS
                                ; didn't necessarily preserve this
     Push    DI                 ; QBASIC requires these 2 to be saved
     Push    SI
                                ; this just tests for primary display
vgatest:                        ; because that is all QBASIC cares about
     Mov     AX,1A00h
     Mov     BX,10h             ; Test for VGA adapter
     Int     10h
     Cmp     AL,1Ah             ; If VGA adapter exists, it returns AL=1Ah
     Jne     egatest            ; VGA does not exist so test for EGA
				; Else VGA exists, primary display info
     Cmp     BL,8               ; routine returns primary display in BL
     Jne     @F
     Jmp     Short  vga_color   ; VGA color exists. This does not test
                                ;  if VGA adapter clone is in emulation
                                ;  mode, such as HERC emulation
                                ;  because QBASIC does not check
                                ;  for this either.
@@:
     Cmp     BL,7
     Jne     @f
     Jmp     vga_mono           ; VGA mono exists, no effort is made to
				; distinguish between VGA, EGA or MCGA mono
@@:
     Cmp     BL,11
     Jne     @f
     Jmp     vga_mono           ; MCGA mono exists
@@:
     Cmp     BL,12
     Jne     @f
     Jmp     Short mcga_color   ; MCGA analog color exists
@@:
     Cmp     BL,10
     Jne     @f
     Jmp     Short mcga_ecd     ; MCGA w/EGA display (untested)
@@:
     Cmp     BL,4               ; EGA color screen found, we have to
     Jne     @f                 ; test if EGA is attached to ECD
     Jmp     Short egatest      ; monitor or just plain CGA monitor
@@:
     Cmp     BL,5
     Jne     @f
     Jmp     Short vga_mono     ; EGA mono screen found
@@:
     Cmp     BL,2
     Jne     @F
     Jmp     Short att_test     ; CGA color found, test for which type
@@:
     Cmp     BL,1
     Jne     @f
     Jmp     herctest           ; MDA mono found
@@:
     Cmp     BL,6               ; test for PGA, treat as a CGA
     Jne     @f
     Jmp     cga                ; I guess this should work, untested

@@:                             ; With everything else
     Jmp     unknown            ; merely assume can do normal b&w text

egatest:
     Mov     AX,1200h
     Mov     BX,10h
     Int     10h
     Cmp     BL,10h             ; EGA changes BL from 10h
     Je      cgatest

     Mov     DX,BX              ; Save BX temporarily in DX
     Xor     BX,BX
     Mov     ES,BX
     Test    ES:Byte Ptr [487h],1000b  ;EGA active?, bit 3 of 0040:0087 set?
     JZ      EGA_active         ; if bit clear, then EGA is active
     Jmp     Short cgatest      ; else if EGA not active (primary) check CGA

EGA_active:
     Mov     BX,DX              ; get former value back from CX
     Or      BH,BH              ; if BH = 1 then have MONO display
     JZ      ega_color          ; else have color display
     Jmp     Short vga_mono     ; treat as a VGA mono

vga_color:
     Mov     AX,13              ; max screen mode is QBASIC SCREEN 13
     Jmp     Quit

mcga_color:
     Mov     AX,11              ; near max screen mode is QBASIC SCREEN 11
     Jmp     Quit               ; MCGA can do SCREEN 13 too, but not 12.

mcga_ecd:
     Mov     AX,-11             ; a warning that MCGA has EGA display
     Jmp     short Quit         ; attached (Untested)

ega_color:
;*********** Based on information returned by AH 12h, BL 10h of INT 10h,
;*********** this routine reads the EGA Sense switches stored in CL
;*********** to see if really have a primary monitor that can do EGA graphics.
;*********** If do not have an ECD/multisync display, report a -9.
;*********** If have a 64kb EGA reports 8 if have ECD or -8 if have CGA
;*********** It is unclear if this will work on all clone EGA's.
;*********** It works with a VGA clone and ATI EGA Wonder as well as an
;*********** ACER EGA clone.
;*********** CL information derived from RAM memory at 0040:0088h
;***********
;*********** Source of CL information:
;*********** Ferro, "Programmer's Guide to the EGA and VGA Cards,"
;*********** (Addison-Wesley 1988), page 337.  Yet on page 473 says you can't
;*********** tell what CL will report.
;*********** Similar information hidden in Wilton, "Programmer's Guide to
;*********** PC & PS/2 Video Systems" (Microsoft 1987), page 520.
;***********
;*********** Partial information set forth in Phoenix's "System Bios for
;*********** PC/XT/AT Computers and Compatibles (Addison-Wesley 1989)
;*********** page 243 (which states that VGA's follow this too)
;***********
;*********** Wilton's routine also appears in other books, e.g.
;*********** Tischer, "PC System Programming for Developers" (ABACUS 1989)
;*********** page 542
;***********
;*********** See also, Woram, "PC Configuration Book" (Bantam 1987),
;***********   pages 279-280 Provides listing of IBM official switch
;***********   settings which does not seem to match anything
;***********   in the above two books.
;***********
;***********   CL returns on good clones:
;***********     EGA inactive w/ MDA primary   =  00h, 01h, 02h, 03h
;***********     EGA inactive w/ CGA primary   =  04h, 05h
;***********     EGA active w/ CGA             =  06h, 07h
;***********     EGA active w/ ECD in CGA mode =  08h
;***********     EGA active w/ ECD             =  09h
;***********     EGA active w/ MDA mono        =  0Bh, 0Ah


     Cmp     CL,9               ; read EGA Sense switches to see if
				; have ECD display and not a CGA display
     JE      ega1
     Mov     AX,-9              ; report have a CGA type display
     Or      BL,BL              ; check if BL=0, i.e. 64kb Memory
     JNZ     @f                 ; nope so quit
     Inc     AX                 ; report have a CGA display w/ 64kb Memory
@@:
     Jmp     short Quit         ; with an EGA adapter

ega1:
     Mov     AX,9               ; max screen mode is QBASIC SCREEN 9
     Or      BL,BL              ; check if BL = 0, i.e. 64kb memory
     JNZ     @f                 ; nope, so quit
     Dec     AX                 ; report have EGA w/ ECD display
                                ; but only 64KB memory (makes 9 an 8)
@@:
     Jmp     Short Quit

vga_mono:
     Mov     AX,10              ; max screen mode is QBASIC SCREEN 10
     Jmp     Short Quit         ; may also be a MCGA or EGA mono too.
                                ; since QBASIC does not distinguish
                                ; I don't either
cgatest:
     Xor     AX,AX
     Mov     ES,AX
     Mov     BX,ES:[0463h]      ; check if MONO port in use
     Cmp     BL,0B4h
     Je      herctest           ; this test looks for Mono port address

att_test:
;******* The AT&T CGA is just a CGA that responds to a special mode set
;******* command.  Mode 48h is equivalent to SCREEN 4.  It is possible
;******* to load BIOS ram with this screen mode and fool QBASIC.  Try it and
;******* you will get some weird displays on non-AT&T displays.
;******* Unknown if that "gamemanship" may hurt your monitor.
;*******
;******* Cannot merely attempt to change to mode &H48 to test for AT&T
;******* because some old CGA's (e.g. Tecmar Color Graphics Card) will let you
;******* change mode number to anything you try.  However HERC clones,
;******* EGA clones and VGA clones will only allow a change to a supported
;******* video mode so such a test would work with them, but would be
;******* worthless unless you could be confident that all CGA's were new.

     Mov     AX,0F000h          ; Get ROM ID segment
     Mov     ES,AX              ; Store segment in ES
     CLD                        ; clear the direction flag
     Push    DS                 ; Save DS
     Mov     AX,CS
     Mov     DS,AX              ; set DS = to CS

     Assume  DS:@code

     comment		|*
            ; this is the long form routine, using full name
     Mov     DI,0C050h          ; point DI at ROM
     Mov     SI,OFFSET ATT      ; DS:SI points to  "OLIVETTI".
     Mov     CX,ATT_LEN         ; CX has length of "OLIVETTI".
     REPE    CMPSB              ; ES:DI destination, DS:SI source
     Jne     compaq_test        ; if no change test for COMPAQ
     			|*
     				; faster version
     				; Source:  XMS.SYS version 2.06 MASM source
     Cmp     ES:[0C05h],'LO'    ; look for byte reversed 'OL' at FC00:0050h
     				; in memory letters are reversed
     Jne     compaq_test	; COMPAQ not found

att_found:
     ; program assumes that if a CGA is active on an AT&T
     ; that built-in adapter is in use.

     Pop     DS                 ; restore DS

     Assume  DS:@data

     Mov     AX,4               ; max screen mode is QBASIC SCREEN 4
     Jmp     Short Quit

compaq_test:
     ; Purpose of this test is to allow other routines to know if
     ; "snow" testing is necessary, as well as to tell programmer
     ; to use mono attributes in program rather than color attributes
     ; which would confuse the viewer of a COMPAQ single color display.
     ; source: XMS.SYS Version 2.06 MASM Source Code

     Mov     DI,0FFEAh          ; Get ID offset & store in DI
     Mov     SI,OFFSET COMPAQ   ; DS:SI points to  "COMPAQ".
     Mov     CX,COMPAQ_LEN      ; CX has length of "COMPAQ".
     REP     CMPSB              ; ES:DI destination, DS:SI source
     Pop     DS                 ; restore DS

     Assume  DS:@data

     ; Program assumes that if a CGA is active on a COMPAQ
     ; that built-in single color display is in use because
     ; even though it does not have color it has better
     ; text resoluton.
     Mov     AX,-2              ; assume found COMPAQ CGA mode
				; to tell us that user likely has a
				; single color display
     JE      found_compaq       ; if match found

cga:                            ; Normal CGA
     Mov     AX,2               ; max screen mode is QBASIC SCREEN 2

found_compaq:
     Jmp     Short Quit

herctest:
     ;*****Main Herc test entry point****
     ; Herc display changes Vertical retrace bit during vertical retrace
     ; however normal MDA display does not.
     ; Source for HERC test only:
     ; Hercules Computer Technology, Inc. and Doty,
     ; "Programmer's Guide to Hercules Graphics Cards"
     ; (Addison-Wesley 1988) page 138.
     ; Similar routines have been  published in PC Magazine
     ; and Young, "Inside DOS: A Programmer's Guide", (Sybex 1990)
     ; page 178, as well as Young's book on OS/2.
     ;
     ; No effort is made to test for Herc INCOLOR or any other HERC
     ; displays since QBASIC would not use the information.
     ; If you must have it, see Doty or Wilton's books listed above.

                                ; test the HERC_Port
     Mov     DX,HERC_PORT       ; load DX with display status port
                                ; a Read-only port
     Xor     BX,BX              ; clear counter
     IN      AL,DX              ; read port
     And     AL,80h             ; mask off every bit but bit 7
     Mov     AH,AL              ; store in AH original status of bit
     Mov     CX,8000h           ; load loop counter

herc1:
     IN      AL,DX              ; read byte
     And     AL,80h             ; clear everything but bit 7
     Cmp     AL,AH              ; keep testing for change in bit 7
     Je      herc2
     Inc     BL                 ; for every change Inc BL
     Cmp     BL,12              ; check routine found vertical
                                ; retrace changed 12 times
     JA      Test_4_MSHERC      ; found a herc so test for MSHERC.COM

herc2:
     Loop    herc1              ; Herc display not found

unknown:                        ; Handles mono displays too
     Xor     AX,AX              ; return a 0 if just normal text display

EVEN
Quit:
     Pop     SI                 ; restore saved registers
     Pop     DI
     Pop     BP
     Ret

Test_4_MSHERC:
     Mov     AX,0EF00h          ; test for MSHERC.COM
     Int     10h
     Mov     AX,3               ; Assume max screen mode is QBASIC SCREEN 3
     Cmp     DX,0100h           ; **this is an undocumented call and may
                                ; change ******!!!!!
     JE      Have_MSHerc        ; if equal then MSHERC.COM is installed
     Mov     AX,-3              ; else report MSHERC.COM is not installed
				; return -3
Have_MSHerc:
     Jmp     Short Quit

VIDEOSTAT       ENDP
END

;----------------------------------------------------------------------
; If you read this far, you are a scholar.  If you really want a good
; video book I would suggest that you buy Michael Abrash's On Graphics
; book about EGA/VGA display's, published by QUE, very advanced.
; For useful information,-- what does this port do--, for all display
; types, Wilton's book is very good.  Ferro's book has more specific
; EGA/VGA information but book is a little disorganized.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;----------------------------------------------------------------------
