/*
	SNEWS 1.91

	post - news posting stuff


    Copyright (C) 1991  John McCombs, Christchurch, NEW ZEALAND
                        john@ahuriri.gen.nz
                        PO Box 2708, Christchurch, NEW ZEALAND

	Modifications copyright (C) 1993  Daniel Fandrich
						<dan@fch.wimsey.bc.ca> or CompuServe 72365,306

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 1, as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    See the file COPYING, which contains a copy of the GNU General
    Public License.


	Source is formatted with a tab size of 4.

 */


#include "defs.h"
#include "snews.h"
#include <alloc.h>
#include <ctype.h>
#include <io.h>
#include <time.h>


/*------------------------------- post an article --------------------------*/
void post(TEXT *tx, char *gx, char *subject)
{
    /*
     *  Ask for the data we are not given in the arguments,
     *  let him edit the article, then post it
     */

    FILE *article, *sig;
    LINE *ln;
	char buf[129];
	char newsgroups[256];
    char dist[80];
    char sig_fn[80];
	char author[WHO_LENGTH], msg_id[MSG_ID_LENGTH];
	char tempfile[81];
    int  ch;

    strcpy(newsgroups, gx);

    strcpy(author, "");
    strcpy(msg_id, "");

	sprintf(tempfile, "%spost%04x.tmp", my_stuff.temp_str, getpid());
	if ((article = fopen(tempfile, "w+")) != NULL) {

        command("");
        if (strlen(newsgroups) == 0) {
            /* if no groups ask for them */
            lmessage("Newsgroups? ");
			gets(newsgroups);

        } else {

            /* there is a group ask if he wants to change */
			sprintf(buf, "Group: %s; post to *this* group (y/n)?", newsgroups);
            message(buf);
			while (((ch = tolower(getch())) != 'y') && (ch != 'n'));

            if (ch == 'n') {
                lmessage("Newsgroups? ");
                gets(newsgroups);
            }

        }

        /* check for a valid newsgroups line */
		if (newsgroups_valid(newsgroups)) {

			if (strlen(subject) != 0) {		/* Subject exists */
				message("Change Subject (y/n)? ");
				while (((ch = tolower(getch())) != 'y') && (ch != 'n'));
				if (ch == 'y') {
				   lmessage("Subject: ");
				   gets(subject);
				}
			} else {
                lmessage("Subject? ");
                gets(subject);
            }

			lmessage("Distribution? ");
			gets(dist);

            /* add the quoted message */
			/* are we quoting? */
            if (tx != NULL) {

				get_his_stuff(tx, author, msg_id);
                message("Quote article (y/n)? ");
				while (((ch = tolower(getch())) != 'y') && (ch != 'n'));

				if (ch == 'y') {

                    fprintf(article, "In article %s %s writes:\n", msg_id, author);
                    ln = tx->start;
                    while (ln != NULL) {
						fprintf(article, ">%s", ln->data);
                        ln = ln->next;
                    }
                }
            }

            /* append the signature if there is one */
            strcpy(sig_fn, my_stuff.home);
            strcat(sig_fn, my_stuff.signature);
            if ((sig = fopen(sig_fn, "rt")) != NULL) {
				fputs("\n--\n", article);
				while (fgets(buf, sizeof(buf)-1, sig) != NULL)
					fputs(buf, article);
				fclose(sig);
            }

		fclose(article);

	    ch = 'e';
	    while ((ch != 's') && (ch != 'a')) {
			if (ch == 'e') {
			   sprintf(buf, my_stuff.editor, tempfile);
			   system(buf);
			}
			gotoxy(1,23);
/*			cprintf("Article for newsgroup %s ", newsgroups); */
			sprintf(buf,"   (S)end, (A)bort, or (E)dit again? (S/A/E):");
			message(buf);
			while (((ch = tolower(getch())) != 's') && (ch != 'a') && (ch != 'e'));
			gotoxy(1,24);
			}
				article = fopen(tempfile, "rt");
				if (ch == 's')
					post_it(article, newsgroups, subject, dist, msg_id);
		}

        fclose(article);
		unlink(tempfile);

    } else {
        message("*** couldn't open temp article file - press any key ***");
		get_any_key();
    }

}



/*--------------------------- post an article ---------------------------*/
void post_it(FILE *article, char *newsgroups, char *subject, char *dist,
                  char *msg_id)
{
    /*
     *  Post an article.  The article is passed as an open file,
     *  with the other header data.  The header is added to the file
     *  and the article sent.
     */

    FILE   *tmp, *local, *log;
    char   buf[256], *p;
    char   ng[256];
	char   remotegroups = 0;
    char   d_name[20], x_name[20];
	char   short_d_name[80], short_x_name[80];
    int    ct, seq;
    time_t t;
    struct tm *gmt;
    long   where;
    ACTIVE *gp;

    static char *dow[] = {
        "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
    };
    static char *mth[] = {
        "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep",
        "Oct", "Nov", "Dec"
    };

    ct = 0;

    seq = post_sequence();
    sprintf(d_name, "D.%s%04x", my_stuff.my_site, seq);
    sprintf(x_name, "X.%s%04x", my_stuff.my_site, seq);

	sprintf(short_d_name, "%sD_%04x.%.3s", my_stuff.temp_str, seq, my_stuff.my_site);
	sprintf(short_x_name, "%sX_%04x.%.3s", my_stuff.temp_str, seq, my_stuff.my_site);

    /* count the lines */
    rewind(article);
	while (fgets(buf, sizeof(buf)-1, article) != NULL)
        ct++;


    /*
     *  Make the final article file.  This posting stuff is a horrible
	 *  kludge (blush).  If you get around to fixing this, please
     *  post me a copy :)
     */
    if ((tmp = fopen(short_d_name, "w+b")) != NULL) {

		/* see if any newsgroups are not local */
		if (stricmp(dist, "local") != 0) {
			strcpy(ng, newsgroups);
			p = strtok(ng, " ,");
			while (p != NULL) {
				if (!is_local_group(p)) {
					++remotegroups;
					break;
				}
				p = strtok(NULL, " ,");
			}
		}

        fprintf(tmp, "Path: %s!%s\n", my_stuff.my_site, my_stuff.user);
        fprintf(tmp, "From: %s@%s (%s)\n", my_stuff.user, my_stuff.my_domain,
            my_stuff.my_name);
        fprintf(tmp, "Newsgroups: %s\n", newsgroups);
        fprintf(tmp, "Subject: %s\n", subject);
		if (*dist)
        	fprintf(tmp, "Distribution: %s\n", dist);
		fprintf(tmp, "Message-ID: <%ld.%dsnx@%s>\n", time(&t), seq, my_stuff.my_domain);
        if (strlen(msg_id) > 0)
            fprintf(tmp, "References: %s\n", msg_id);

        time(&t);
        gmt = gmtime(&t);
        fprintf(tmp, "Date: %s, %02d %s %02d %02d:%02d:%02d GMT\n",
                dow[gmt->tm_wday],
                gmt->tm_mday, mth[gmt->tm_mon], (gmt->tm_year % 100),
                gmt->tm_hour, gmt->tm_min, gmt->tm_sec);

		if (*my_stuff.my_organisation)
			fprintf(tmp, "Organization: %s\n", my_stuff.my_organisation);
		if (stricmp (my_stuff.replyuser,"-none-") != 0) {
			fprintf(tmp, "Reply-To: %s\n",my_stuff.replyuser);}
        fprintf(tmp, "Lines: %d\n\n", ct);

        /* copy the rest */
        rewind(article);
		while (fgets(buf, sizeof(buf)-1, article) != NULL) {
            fputs(buf, tmp);
        }

        /* ok, now post it locally */
        strcpy(ng, newsgroups);
        p = strtok(ng, " ,");
        while (p != NULL) {

            if (fseek(tmp, 0L, SEEK_SET) != 0) {
                fprintf(stderr, "cannot rewind temp file\n");
                exit(1);
            }

            local = open_out_file(p);
            where = ftell(local);
			while (fgets(buf, sizeof(buf)-1, tmp) != NULL)  {
                fputs(buf, local);
            }
            fprintf(local, "\n@@@@END\n");
            fclose(local);

            /* save the data in the index file */
            local = open_index_file(p);
            gp = find_news_group(p);
            fprintf(local,"%08ld %08ld %09ld %s\n", where, gp->hi_num, t,
                subject);
            fclose(local);

            p = strtok(NULL, " ,");
        }


        /* finally log it */
        strcpy(buf, my_stuff.news_dir);
        strcat(buf, "post.log");
		if ((log = flockopen(buf, "at")) != NULL) {
            fprintf(log, "\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01"
                         "\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\n");

            fseek(tmp, 0L, SEEK_SET);
			while (fgets(buf, sizeof(buf)-1, tmp) != NULL)  {
               fputs(buf, log);
            }

            fclose(log);
        }

        fclose(tmp);

		/* only create spool files to host system on a non-local posting */
		if (remotegroups) {

			/* now the the X... file */
			if ((tmp = fopen(short_x_name, "wb")) != NULL) {
				fprintf(tmp, "U news %s\n", my_stuff.my_site);
				fprintf(tmp, "Z\n");
				fprintf(tmp, "F %s\n", d_name);
				fprintf(tmp, "I %s\n", d_name);
				fprintf(tmp, "C rnews\n");
				fclose(tmp);

				sprintf(buf, "uucp -C %s %s!%s ", short_d_name, my_stuff.mail_server,
						   d_name);
				gotoxy(1,24); clreol();
				system(buf);
				sprintf(buf, "uucp -C %s %s!%s ", short_x_name, my_stuff.mail_server,
						x_name);
				gotoxy(1,24); clreol();

				system(buf);
				unlink(short_x_name);

			} else {
				message("*** couldn't open temp post file - press any key ***");
				get_any_key();
			}

		}
		unlink(short_d_name);

    } else {
        message("*** couldn't open temp post file - press any key ***");
		get_any_key();
    }
}



/*------------------------ parse and check newsgroups ---------------------*/
int newsgroups_valid(char *ng)
{
    /*
     *  This routine parses the newsgroup list, and checks them for
     *  validity
     */

    char buf[256], msg[128], *p;

    strcpy(buf, ng);

    if ((p = strtok(buf, ", ")) == NULL)
        return(FALSE);

    while (p != NULL) {
        if (!check_valid_post_group(p)) {
            sprintf(msg, "** Can't post to %s **", p);
            message(msg);
            command("-- Press any key to continue --");
			get_any_key();
            return(FALSE);
        }
        p = strtok(NULL, ", ");
    }

    return(TRUE);
}
