/*
 * Decompiled with CFR 0.152.
 */
package Typing;

import Typing.CompString;
import Typing.TypingPractice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ResultDialog
extends JDialog {
    JLabel correctLabel;
    JLabel errorLabel;
    JLabel speedLabel;
    JLabel totalWordsLabel;
    JLabel rightWordsLabel;
    JLabel errorWordsLabel;
    JLabel hitLabel;
    JTextPane textPane;
    JButton okButton;
    TypingPractice parent;
    float speed;
    int totalWords;
    int rightWords;
    int errorWords;
    int hitRate;
    SimpleAttributeSet red;
    ArrayList wordsList;

    public ResultDialog(TypingPractice typingPractice, ArrayList arrayList, float f, int n, int n2, int n3, int n4, Dimension dimension) {
        super(typingPractice, "Information", true);
        this.parent = typingPractice;
        this.wordsList = arrayList;
        this.speed = f;
        this.totalWords = n;
        this.rightWords = n2;
        this.errorWords = n3;
        this.hitRate = n4;
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 20, 0));
        this.correctLabel = new JLabel("Right", this.createImageIcon("right.gif"), 2);
        this.correctLabel.setForeground(Color.black);
        jPanel2.add(this.correctLabel);
        this.errorLabel = new JLabel("Error", this.createImageIcon("error.gif"), 2);
        this.errorLabel.setForeground(Color.red);
        jPanel2.add(this.errorLabel);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.textPane = new JTextPane();
        this.textPane.setMargin(new Insets(0, 2, 0, 0));
        this.textPane.setEditable(false);
        this.textPane.setBackground(new Color(153, 153, 240, 255));
        this.textPane.setFont(new Font("Serif", 1, 17));
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        jScrollPane.setPreferredSize(new Dimension(dimension.width + 4, dimension.height + 3));
        jScrollPane.setMaximumSize(new Dimension(dimension.width + 4, dimension.height + 3));
        jScrollPane.setMinimumSize(new Dimension(dimension.width + 4, dimension.height + 3));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.red = new SimpleAttributeSet();
        StyleConstants.setForeground(this.red, Color.red);
        Border border = BorderFactory.createEtchedBorder(1);
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 4, 2, 5));
        this.speedLabel = new JLabel();
        this.speedLabel.setBorder(border);
        this.speedLabel.setPreferredSize(new Dimension(150, 25));
        jPanel3.add(this.speedLabel);
        this.totalWordsLabel = new JLabel();
        this.totalWordsLabel.setBorder(border);
        this.totalWordsLabel.setPreferredSize(new Dimension(110, 25));
        this.rightWordsLabel = new JLabel();
        this.rightWordsLabel.setForeground(Color.black);
        this.rightWordsLabel.setBorder(border);
        this.rightWordsLabel.setPreferredSize(new Dimension(100, 25));
        jPanel3.add(this.rightWordsLabel);
        this.errorWordsLabel = new JLabel();
        this.errorWordsLabel.setForeground(Color.red);
        this.errorWordsLabel.setBorder(border);
        this.errorWordsLabel.setPreferredSize(new Dimension(100, 25));
        jPanel3.add(this.errorWordsLabel);
        this.hitLabel = new JLabel();
        this.hitLabel.setBorder(border);
        this.hitLabel.setForeground(new Color(0, 102, 51, 255));
        this.hitLabel.setPreferredSize(new Dimension(100, 25));
        jPanel3.add(this.hitLabel);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(new Dimension(80, 25));
        this.okButton.setMaximumSize(new Dimension(80, 25));
        this.okButton.requestFocus();
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultDialog.this.setVisible(false);
            }
        });
        jPanel4.add(this.okButton);
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel4, "South");
        SwingUtilities.getRootPane(this).setDefaultButton(this.okButton);
        this.pack();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension2.width / 2 - this.getSize().width / 2, dimension2.height / 2 - this.getSize().height / 2);
        this.setVisible(false);
        this.displayResult();
    }

    private void displayResult() {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        Iterator iterator = this.wordsList.iterator();
        CompString compString = null;
        while (iterator.hasNext()) {
            compString = (CompString)iterator.next();
            if (compString.isError()) {
                this.append(compString.getString(), this.red);
            } else {
                this.append(compString.getString(), null);
            }
            this.append(" ", null);
        }
        this.speedLabel.setText("Speed : " + decimalFormat.format(this.speed) + " Word / Min.");
        this.rightWordsLabel.setText("Right " + this.rightWords + " word");
        this.errorWordsLabel.setText("Error " + this.errorWords + " word");
        this.hitLabel.setText("Hit rate " + this.hitRate + "%");
    }

    private void append(String string, AttributeSet attributeSet) {
        Document document = this.textPane.getDocument();
        try {
            document.insertString(document.getLength(), string, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private ImageIcon createImageIcon(String string) {
        String string2 = "images/" + string;
        return new ImageIcon(this.getClass().getResource(string2));
    }
}

