/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AppletContext;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.URL;

public abstract class DButtonBase
extends Canvas {
    String label;
    boolean blackBorder = false;
    boolean incrustedBorder = false;
    boolean comboExtension = false;
    Color extendDark = null;
    Color extendLight = null;
    Color borderLight = null;
    Color borderDark = null;
    Color parentColor = null;
    Tip tip = null;
    protected transient boolean pressed = false;
    protected transient boolean released = true;
    protected transient boolean inButton;
    protected boolean notifyWhilePressed = false;
    protected transient boolean running = false;
    protected transient boolean notified = false;
    protected boolean showFocus = false;
    protected boolean useOffset = true;
    protected boolean showURLStatus = true;
    protected transient boolean isAdded = false;
    protected int bevel = 1;
    protected int notifyDelay = 1000;
    protected int pressedAdjustment = 0;
    protected String frame = null;
    protected Color borderColor;
    protected Color buttonColor = Color.black;
    protected Timer notifyTimer = null;
    protected transient Image buttonImage = null;
    protected transient Graphics biG = null;
    protected URL linkURL = null;
    protected transient AppletContext context = null;
    String actionCommand;
    ActionListener actionListener = null;
    transient boolean hasFocus = false;
    private Color _$180634 = null;
    private Color _$189094 = null;
    private Color _$189113 = null;
    private Color _$180646 = null;
    private Color _$189133 = null;
    private Color _$189151 = null;
    private Color _$189549 = null;
    private Color _$189170 = null;
    private Color _$189189 = null;
    private BBKey _$26020 = null;
    private BBFocus _$23586 = null;
    private Action _$27602 = new Action();
    private BBMouse _$25340 = null;

    protected DButtonBase() {
        if (OS.isWindows()) {
            this.setShowFocus(true);
        }
    }

    public void setStyle(boolean bl, boolean bl2, int n) {
        this.setBorderEnabled(bl);
        this.setIncrustedEnabled(bl2);
        this.setBevelHeight(n);
    }

    public void setBorderEnabled(boolean bl) {
        this.blackBorder = bl;
        if (bl) {
            this.borderDark = Color.black;
            this.borderLight = Color.black;
        }
    }

    public void setIncrustedEnabled(boolean bl) {
        this.incrustedBorder = bl;
    }

    public void setIncrustedBorder() {
        if (this.incrustedBorder) {
            this.borderDark = ColorUtils.darken(this.parentColor, 0.4);
            this.borderLight = ColorUtils.lighten(this.parentColor, 0.4);
        } else {
            this.borderDark = Color.black;
            this.borderLight = Color.black;
        }
    }

    public void setComboEnabled(boolean bl) {
        this.comboExtension = bl;
        if (bl) {
            this.setComboColors(this.buttonColor);
        }
    }

    public void setComboColors(Color color) {
        this.extendDark = ColorUtils.darken(color, 0.4);
        this.extendLight = ColorUtils.lighten(color, 0.5);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (!DButtonBase.objectsEqual(this.buttonColor, color)) {
            this.buttonColor = color;
            this._$180634 = ColorUtils.lighten(this.buttonColor, 0.5);
            this._$189094 = Effect.darken(this.buttonColor, 0.58);
            this._$189113 = Effect.lighten(this.buttonColor, 0.666);
            this._$180646 = ColorUtils.darken(this.buttonColor, 0.4);
            this._$189133 = Effect.darken(this.buttonColor, 0.1);
            this._$189151 = Effect.darken(this.buttonColor, 0.166);
            this._$189170 = Effect.lighten(this.buttonColor, 0.3333333333333333);
            this._$189189 = Effect.darken(this.buttonColor, 0.1);
        }
    }

    public void setBevelHeight(int n) {
        this.bevel = n;
    }

    public int getBevelHeight() {
        return this.bevel;
    }

    public void setNotifyWhilePressed(boolean bl) {
        if (this.notifyWhilePressed != bl) {
            this.notifyWhilePressed = bl;
            if (this.notifyWhilePressed) {
                this.notifyTimer = new Timer(this.notifyDelay, true);
                this.notifyTimer.addActionListener(this._$27602);
            } else if (this.notifyTimer != null) {
                this.notifyTimer = null;
            }
        }
    }

    public boolean isNotifyWhilePressed() {
        return this.notifyWhilePressed;
    }

    public void setNotifyDelay(int n) {
        if (this.notifyDelay != n) {
            this.notifyDelay = n;
            if (this.notifyTimer != null) {
                this.notifyTimer.setDelay(this.notifyDelay);
            }
        }
    }

    public int getNotifyDelay() {
        return this.notifyDelay;
    }

    public void setUseOffset(boolean bl) {
        this.useOffset = bl;
    }

    public boolean isUseOffset() {
        return this.useOffset;
    }

    public void setShowFocus(boolean bl) {
        this.showFocus = bl;
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public void setShowURLStatus(boolean bl) {
        this.showURLStatus = bl;
    }

    public boolean isShowURLStatus() {
        return this.showURLStatus;
    }

    public void setLinkURL(URL uRL) {
        this.linkURL = uRL;
        this.context = null;
    }

    public URL getLinkURL() {
        return this.linkURL;
    }

    public void setFrame(String string) {
        this.frame = string;
    }

    public String getFrame() {
        return this.frame;
    }

    public void validate() {
        super.validate();
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            if (bl) {
                super.setEnabled(true);
                this.pressed = false;
                this.pressedAdjustment = 0;
            } else {
                super.setEnabled(false);
                if (this.notifyTimer != null) {
                    this.notifyTimer.stop();
                }
                this.pressed = false;
                this.pressedAdjustment = 0;
            }
            this.repaint();
        }
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this._$23586 == null) {
            this._$23586 = new BBFocus();
            this.addFocusListener(this._$23586);
        }
        if (this._$26020 == null) {
            this._$26020 = new BBKey();
            this.addKeyListener(this._$26020);
        }
        if (this._$25340 == null) {
            this._$25340 = new BBMouse();
            this.addMouseListener(this._$25340);
        }
        this.isAdded = true;
        this.validate();
        this.parentColor = this.getParent().getBackground();
        if (DButtonBase.objectsEqual(this.buttonColor, Color.black)) {
            this.setBackground(this.parentColor);
        }
        this.setIncrustedBorder();
    }

    public synchronized void removeNotify() {
        if (this._$23586 != null) {
            this.removeFocusListener(this._$23586);
            this._$23586 = null;
        }
        if (this._$26020 != null) {
            this.removeKeyListener(this._$26020);
            this._$26020 = null;
        }
        if (this._$25340 != null) {
            this.removeMouseListener(this._$25340);
            this._$25340 = null;
        }
        super.removeNotify();
        this.isAdded = false;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.updateButtonImage();
        graphics.drawImage(this.buttonImage, 0, 0, this);
    }

    protected boolean isValidBevelSize(int n) {
        Dimension dimension = this.getSize();
        return n >= 0 && n < dimension.width / 2 && n < dimension.height / 2;
    }

    protected void linkToURL() {
        if (this.context != null && this.linkURL != null) {
            if (this.frame == null || this.frame.length() == 0) {
                this.context.showDocument(this.linkURL);
            } else {
                this.context.showDocument(this.linkURL, this.frame);
            }
        }
    }

    protected void setAppletContext(AppletContext appletContext) {
        this.context = appletContext;
    }

    protected void updateButtonImage() {
        int n;
        int n2;
        int n3;
        Color color;
        Color color2;
        Color color3;
        Serializable serializable;
        Dimension dimension = this.getSize();
        int n4 = dimension.width;
        int n5 = dimension.height;
        int n6 = 0;
        int n7 = 0;
        int n8 = n4 - 1;
        int n9 = n5 - 1;
        boolean bl = !this.pressed || !this.inButton;
        int n10 = 0;
        if (this.incrustedBorder) {
            n10 = 1;
        }
        if (this.isButtonImageInvalid()) {
            this.buttonImage = this.createImage(n4, n5);
            try {
                serializable = new MediaTracker(this);
                ((MediaTracker)serializable).addImage(this.buttonImage, 0);
                ((MediaTracker)serializable).waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.biG = this.buttonImage.getGraphics();
        serializable = this.biG.getColor();
        if (this.isEnabled()) {
            if (bl) {
                color3 = this.buttonColor;
                color2 = this._$180634;
                color = this._$180646;
            } else {
                color3 = this._$189189;
                color2 = this._$189094;
                color = this._$189133;
            }
        } else {
            color3 = this._$189170;
            color2 = this._$189113;
            color = this._$189151;
        }
        if (this.comboExtension) {
            n3 = 0;
            n2 = 0;
            int n11 = n3 + n4 - 1;
            int n12 = n2 + n5 - 1;
            this.biG.setColor(this.extendDark);
            this.biG.drawLine(n3, n2, n11, n2);
            this.biG.drawLine(n3, n2 + 1, n11 - 1, n2 + 1);
            this.biG.setColor(this.extendLight);
            this.biG.drawLine(n11, n2 + 1, n11, n12);
            this.biG.drawLine(n3, n12, n11, n12);
            n6 = n3;
            n7 = n2 + 2;
            n8 -= 2;
            n9 -= 4;
        }
        if (this.blackBorder) {
            this.biG.setColor(this.borderDark);
            this.biG.drawLine(0, 0, n8 - 0 - 0 - n10, 0);
            this.biG.drawLine(0, 0, 0, n9 - 0 - 0);
            this.biG.setColor(this.borderLight);
            this.biG.drawLine(0, n9, n8 - 0 - 0, n9);
            this.biG.drawLine(n8, n9 - 0 - 0, n8, 1);
            ++n6;
            ++n7;
            n8 -= 2;
            n9 -= 2;
        }
        n3 = this.bevel;
        if (this.bevel > 1) {
            --n3;
        }
        this.biG.setColor(color3);
        this.biG.fillRect(n6, n7, n8 - n6 + 1, n9 - n7 + 1);
        if (!bl && this.useOffset) {
            this.biG.setColor(color2);
            for (n = 0; n < n3; ++n) {
                this.biG.drawLine(n6 + n, n7 + n, n6 + n, n7 + n9);
                this.biG.drawLine(n6 + n, n7 + n, n6 + n8, n7 + n);
            }
        }
        if (bl || !this.useOffset) {
            this.biG.setColor(color2);
            for (n = 0; n < n3; ++n) {
                this.biG.drawLine(n6 + n, n7 + n, n6 + n, n7 + n9 - n);
                this.biG.drawLine(n6 + n, n7 + n, n6 + n8 - n - 1, n7 + n);
            }
            this.biG.setColor(color);
            for (n = 0; n < this.bevel; ++n) {
                this.biG.drawLine(n6 + n, n7 + n9 - n, n6 + n8 - n, n7 + n9 - n);
                this.biG.drawLine(n6 + n8 - n, n7 + n + 1, n6 + n8 - n, n7 + n9 - n);
            }
        }
        if (this.hasFocus && this.showFocus) {
            this.biG.setColor(Color.darkGray);
            n6 = n6 + n3 + 1;
            n7 = n7 + n3 + 1;
            n8 = n8 - n3 - this.bevel;
            n9 = n9 - n3 - this.bevel + 1;
            for (n = n6; n <= n8; n += 3) {
                this.biG.drawLine(n, n7, n + 1, n7);
            }
            for (n2 = n7; n2 < n9; n2 += 3) {
                this.biG.drawLine(n6, n2, n6, n2 + 1);
            }
            for (n = n6; n <= n8; n += 3) {
                this.biG.drawLine(n, n9, n + 1, n9);
            }
            for (n2 = n7; n2 < n9; n2 += 3) {
                this.biG.drawLine(n8, n2, n8, n2 + 1);
            }
        }
        this.biG.setColor((Color)serializable);
    }

    protected boolean isButtonImageInvalid() {
        Dimension dimension = this.getSize();
        return this.buttonImage == null || dimension.width != this.buttonImage.getWidth(this) || dimension.height != this.buttonImage.getHeight(this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.bevel + this.bevel + 2, this.bevel + this.bevel + 2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public static boolean objectsEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    void setTip(String string) {
        this.tip = new Tip(this, string);
    }

    class Action
    implements ActionListener,
    Serializable {
        Action() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DButtonBase.this.notifyTimer && DButtonBase.this.notifyWhilePressed) {
                DButtonBase.this.notified = true;
                DButtonBase.this.sourceActionEvent();
                return;
            }
        }
    }

    class BBMouse
    extends MouseAdapter
    implements Serializable {
        BBMouse() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            DButtonBase.this.requestFocus();
            DButtonBase.this.notified = false;
            if (DButtonBase.this.notifyTimer != null && DButtonBase.this.notifyWhilePressed && !DButtonBase.this.running) {
                DButtonBase.this.running = true;
                DButtonBase.this.notifyTimer.start();
            }
            DButtonBase.this.pressed = true;
            DButtonBase.this.released = false;
            if (DButtonBase.this.useOffset) {
                DButtonBase.this.pressedAdjustment = DButtonBase.this.bevel;
            }
            DButtonBase.this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (DButtonBase.this.notifyTimer != null && DButtonBase.this.running) {
                DButtonBase.this.running = false;
                DButtonBase.this.notifyTimer.stop();
            }
            if (DButtonBase.this.pressed) {
                DButtonBase.this.pressed = false;
                DButtonBase.this.pressedAdjustment = 0;
                if (!DButtonBase.this.notifyWhilePressed || !DButtonBase.this.notified) {
                    DButtonBase.this.linkToURL();
                    DButtonBase.this.sourceActionEvent();
                }
            }
            DButtonBase.this.released = true;
            if (DButtonBase.this.inButton) {
                DButtonBase.this.repaint();
            }
            if (DButtonBase.this.tip != null) {
                DButtonBase.this.tip.hideIt();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            DButtonBase.this.inButton = true;
            if (!DButtonBase.this.released) {
                DButtonBase.this.pressed = true;
                if (DButtonBase.this.useOffset) {
                    DButtonBase.this.pressedAdjustment = DButtonBase.this.bevel;
                }
                if (DButtonBase.this.notifyTimer != null && DButtonBase.this.notifyWhilePressed && !DButtonBase.this.running) {
                    DButtonBase.this.running = true;
                    DButtonBase.this.notifyTimer.start();
                }
                if (DButtonBase.this.showURLStatus && DButtonBase.this.context != null && DButtonBase.this.linkURL != null) {
                    DButtonBase.this.context.showStatus(DButtonBase.this.linkURL.toString());
                }
                DButtonBase.this.repaint();
            }
            if (DButtonBase.this.tip != null) {
                DButtonBase.this.tip.showIt();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            DButtonBase.this.inButton = false;
            if (DButtonBase.this.notifyTimer != null && DButtonBase.this.running) {
                DButtonBase.this.running = false;
                DButtonBase.this.notifyTimer.stop();
            }
            if (DButtonBase.this.pressed) {
                DButtonBase.this.pressed = false;
                DButtonBase.this.pressedAdjustment = 0;
                DButtonBase.this.repaint();
            }
            if (DButtonBase.this.showURLStatus && DButtonBase.this.context != null && DButtonBase.this.linkURL != null) {
                DButtonBase.this.context.showStatus("");
            }
            if (DButtonBase.this.tip != null) {
                DButtonBase.this.tip.hideIt();
            }
        }
    }

    class BBKey
    extends KeyAdapter
    implements Serializable {
        BBKey() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            boolean bl;
            boolean bl2 = bl = (keyEvent.getKeyCode() & 0x20) == 32;
            if (bl && DButtonBase.this.hasFocus && DButtonBase.this.showFocus && !OS.isMacintosh()) {
                DButtonBase.this.inButton = true;
                DButtonBase.this.notified = false;
                if (DButtonBase.this.notifyTimer != null && DButtonBase.this.notifyWhilePressed && !DButtonBase.this.running) {
                    DButtonBase.this.running = true;
                    DButtonBase.this.notifyTimer.start();
                }
                DButtonBase.this.pressed = true;
                DButtonBase.this.released = false;
                if (DButtonBase.this.useOffset) {
                    DButtonBase.this.pressedAdjustment = DButtonBase.this.bevel;
                }
                DButtonBase.this.repaint();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            boolean bl;
            boolean bl2 = bl = (keyEvent.getKeyCode() & 0x20) == 32;
            if (bl && DButtonBase.this.hasFocus && DButtonBase.this.showFocus && !OS.isMacintosh()) {
                DButtonBase.this.inButton = false;
                if (DButtonBase.this.notifyTimer != null && DButtonBase.this.running) {
                    DButtonBase.this.running = false;
                    DButtonBase.this.notifyTimer.stop();
                }
                if (DButtonBase.this.pressed) {
                    DButtonBase.this.pressed = false;
                    DButtonBase.this.pressedAdjustment = 0;
                    if (!DButtonBase.this.notifyWhilePressed || !DButtonBase.this.notified) {
                        DButtonBase.this.linkToURL();
                        DButtonBase.this.sourceActionEvent();
                    }
                }
                DButtonBase.this.released = true;
                DButtonBase.this.repaint();
            }
        }
    }

    class BBFocus
    extends FocusAdapter
    implements Serializable {
        BBFocus() {
        }

        public void focusGained(FocusEvent focusEvent) {
            DButtonBase.this.hasFocus = true;
            DButtonBase.this.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            DButtonBase.this.hasFocus = false;
            DButtonBase.this.repaint();
        }
    }
}

