// LockCheck
// A Simple utility for use in batch files to determine if a file is in use
// by another process

// NOTE:
// Written for the Watcom C/C++ compiler version 10.6 or higher
// Compiled with Watcom C/C++ 10.6

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <stdio.h>
#include <errno.h>
#include <dos.h>
#include <string.h>

void ProcessErrorMessage(int &err, char filespec[]);

int main(int argc, char *argv[])
{
    struct find_t  fileinfo;

    int handle, err, x, y;
    int b = 0;
    int wild;
    int viewonly = 0;
    char *noparam, *invalid, *toolarge, *free;
    char filespec[256];
    char path[256];
    
    noparam = "\nLockCheck 1.30\nUsage: LockChk [-L] <filename>\n";
    invalid = "\nError - invalid parameter";
    toolarge = "\nThe filespec exceeds the maximum allowable command line\n";
    free = "\n\nThe specified files are not locked.\n";

// message if no parameters specified
    if (argc < 2)
    {
        printf("%s\n", noparam);
        return (1);
    }

// Looks for parameters
    else
    {
        for (int x = 1; x < argc; x++)
        {
            if (argv[x][0] == '-')
            {
                if (argv[x][1] != 'l' && argv[x][1] != 'L')
                {
                    printf("%s\n%s", invalid, noparam);
                    return(1);
                }
                viewonly = 1;
            }
            else
            {
                if (b == 0)
                {
                    b = x;
                }
            }
        }
        if (b == 0)
        {
            printf("%s", noparam);
            return(1);
        }
    }

    x = (strlen(argv[b]) - 1);

    if (x > 256)
    {
        printf("%s", toolarge);
        return (1);
    }

    // sets up the path search
    while (x >= 0 && x <= 256)
    {
        // stop counting if '\', '/', or ':' is encountered
        if (argv[b][x] == 47 || argv[b][x] == 58 || argv[b][x] == 92)
        {
            break;
        }   
        x = x - 1;
    }

    // copies one member at a time to path
    for (y = 0; y <= x; y++)
    {
        path[y] = argv[b][y];
    }
    path[x+1] = '\0';
    
    // here's the core functionality of the program    
    wild = _dos_findfirst(argv[b], _A_NORMAL, &fileinfo);
    if (! (fileinfo.attrib & _A_SUBDIR))
    {
        while (wild == 0)
        {
            sprintf(filespec, "%s%s", path, fileinfo.name);
            handle = sopen(filespec, O_EXCL, SH_DENYRW);
            if (viewonly == 0)
            {
                printf("\n%s", filespec);
            }

            if (handle == -1)
            {
                // err = errno;
                // ProcessErrorMessage(err, filespec);

                if (viewonly == 0)
                {
                    err = errno;
                    ProcessErrorMessage(err, filespec);
                }
                else
                {
                    //printf("\n%d\n%s", fileinfo.attrib, fileinfo.name);
                    printf("\n%s", filespec);
                }

                // OS2 requires an explicit close
                #if defined (__OS2__)
                _dos_findclose(&fileinfo);
                #endif

                close (handle);
                if (viewonly == 0)
                {
                    return(1);
                }

            }
            // close current handle and go on to the next file
            close (handle);
            wild = _dos_findnext(&fileinfo);

        }
    }
    // filename was a subdirectory, go to next filespec
    #if defined (__OS2__)
    _dos_findclose(&fileinfo);
    #endif
    wild = _dos_findnext(&fileinfo);
    
    #if defined (__OS2__)
    _dos_findclose(&fileinfo);
    #endif
    
    close (handle);
    if (viewonly == 0)
    {
        printf("%s", free);
    }
    return (0);
}


// +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-

void ProcessErrorMessage(int &err, char filespec[])
{
    char *errmsg;
    int errnum = err;
                
    switch(errnum)
    {
        case -1:
                errmsg = " <-- is currently in use by another process\n";
                printf("\n%s %s", filespec, errmsg);
                break;
        case 1:
                errmsg = " <-- is an invalid file name\n";
                printf("\n%s %s", filespec, errmsg);
                break;
        case 2:
        case 3:
        case 4:
                errmsg = " <-- Something strange happened here!  Invalid file handle\n";
                printf("\n%s %s", filespec, errmsg);
                break;
        case 5:
                errmsg = "Not enough memory to run LockCheck!!\n";
                printf("\n%s", errmsg);
                break;
        case 6:
                errmsg = " <-- You do not have sufficient rights to access this file\n";
                printf("\n%s %s", filespec, errmsg);
                break;
        case 7:
        case 8:
        case 9:
        case 10:
                errmsg = "File table overflow.  Close some programs and try again\n";
                printf("\n%s", errmsg);
                break;
        case 11:
                errmsg = "Insufficient file handles to continue.  Increase 'FILES=' in CONFIG.SYS\n";
                printf("\n%s", errmsg);
                break;
        case 12:
        case 13:
        case 14:
        case 15:
                errmsg = "Operation aborted.  A resource deadlock would occur\n";
                printf("\n%s", errmsg);
                break;
        default:
                errmsg = "An unspecified error has occured.\nError Code: ";
                printf("\n%s%d\n", errmsg, errnum);
                break;
    }

    return;
}
