/*
 * This software is provided as is without any warranty of any kind.
 * You are free to copy and distribute it as you like in source or
 * binary form provided that this notice and author credits remain intact
 * in the source.  You are also free to alter, enhance, embellish, or 
 * otherwise change its content provided that the credits to the
 * original author remain, and that any changes are commented stating
 * the change made and the author of that change.  You may NOT profit in
 * any way from the sale or distribution of this software in its original
 * or altered form.
 */

/*
 * File    : scanfile.h
 * Author  : Jeffrey M. Metcalf
 * Date    : 14-May-98
 * Re      : include file for scanfile.c
 *
 */


/*
 * define some constants to be used in scanfile.c
 * BEST and NOTBEST define true and false states for a scan comparison
 * MAXHEX is the maximum number of characters and hexadecimal digits
 * to allocate for the suffix of output filenames
 */

#define NOTBEST 0
#define BEST 1
#define MAXHEX 10


/*
 * define the scan structure
 */

struct scan {

	unsigned long os;     /* offset in bfile for the current scan */
	unsigned long *diffs; /* long array to hold offsets for sfile diffs */
	unsigned long fail;   /* number of failures in the current scan */
	unsigned long cfail;  /* number of consecutive fails in current scan */
	char *buf;            /* pointer to bfile slice of the current scan */
};

/*
 * prototypes of the functions used in scanfile.c
 */

unsigned long bufinfo(char *);
char *bufread(char *, unsigned long);
int cmpbuf(struct scan *, struct scan *, unsigned long);
int judgebest(struct scan *, struct scan *);
struct scan *salloc(unsigned long);
void spitfile(struct scan *, unsigned long);
void getbuf(char *, unsigned long);
void printbest(struct scan *, unsigned long);
void freescan(struct scan *);
void usage(void);

