/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import org.nakedobjects.object.AggregateOid;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.ProxyObjectStore;
import org.nakedobjects.object.distribution.UpdateMessage;
import org.nakedobjects.object.distribution.UpdateMessageException;

class CollectionRemoveUpdateMessage
extends UpdateMessage {
    private Object elementOid;

    public CollectionRemoveUpdateMessage(NakedCollection nakedCollection, NakedObject nakedObject) throws UpdateMessageException {
        super(nakedCollection.getOid(), new byte[0]);
        this.elementOid = nakedObject.getOid();
    }

    public String toString() {
        return "CollectionRemoveUpdateMessage [coll=" + this.getOid() + ",add=" + this.elementOid + "]";
    }

    public void update(ProxyObjectStore proxyObjectStore) throws UpdateMessageException {
        Object object = this.getOid();
        if (!(object instanceof AggregateOid)) {
            throw new RuntimeException("Expected AggregateOid in update, not " + object);
        }
        Object object2 = ((AggregateOid)object).getParentOid();
        if (proxyObjectStore.isObjectCached(object2)) {
            try {
                NakedObject nakedObject = proxyObjectStore.getObject(object2);
                NakedCollection nakedCollection = (NakedCollection)nakedObject.getNakedClass().getField(((AggregateOid)object).getName()).get(nakedObject);
                NakedObject nakedObject2 = proxyObjectStore.getObject(this.elementOid);
                nakedCollection.removed(nakedObject2);
                proxyObjectStore.broadcastRemoveUpdate(nakedCollection, nakedObject2);
            }
            catch (ObjectStoreException objectStoreException) {
                throw new UpdateMessageException(objectStoreException);
            }
        }
    }
}

