/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.ObjectRequest;
import org.nakedobjects.object.distribution.Server;
import org.nakedobjects.object.reflect.Value;

public class SetValueRequest
extends ObjectRequest {
    private static final long serialVersionUID = 1L;
    private String name;
    private String value;

    public SetValueRequest(NakedObject nakedObject, Value value, String string) {
        super(nakedObject);
        this.name = value.getName();
        this.value = string;
    }

    void generateResponse(Server server) {
        try {
            NakedObjectStore nakedObjectStore = server.getObjectStore();
            NakedObject nakedObject = nakedObjectStore.getObject(this.getOid());
            Value value = (Value)nakedObject.getNakedClass().getField(this.name);
            if (value == null) {
                throw new IllegalStateException("DataAttributeMessage has invalid Field: " + this.name);
            }
            value.set(nakedObject, this.value);
        }
        catch (ObjectStoreException objectStoreException) {
            this.response = objectStoreException;
        }
    }

    public String toString() {
        return "DataAttribute [" + this.name + "/" + this.value + "]";
    }
}

