/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.value;

import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.Title;
import org.nakedobjects.object.ValueParseException;
import org.nakedobjects.object.value.Magnitude;

public class FloatingPointNumber
extends Magnitude {
    private static NumberFormat FORMAT = NumberFormat.getNumberInstance();
    private boolean isNull;
    private double value;

    public FloatingPointNumber() {
        this(0.0);
        this.isNull = false;
    }

    public FloatingPointNumber(double d) {
        this.value = d;
        this.isNull = false;
    }

    public FloatingPointNumber(String string) {
        try {
            this.parse(string);
            this.isNull = false;
        }
        catch (ValueParseException valueParseException) {
            // empty catch block
        }
    }

    public FloatingPointNumber(FloatingPointNumber floatingPointNumber) {
        this.isNull = floatingPointNumber.isNull;
        this.value = floatingPointNumber.value;
    }

    public void add(double d) {
        this.checkCanOperate();
        this.value += d;
    }

    public void add(FloatingPointNumber floatingPointNumber) {
        this.checkCanOperate();
        floatingPointNumber.checkCanOperate();
        this.value += floatingPointNumber.value;
    }

    public void clear() {
        this.isNull = true;
    }

    public void copyObject(Naked naked) {
        if (!(naked instanceof FloatingPointNumber)) {
            throw new IllegalArgumentException("Can only copy the value of  a FloatingPointNumber object");
        }
        this.isNull = ((FloatingPointNumber)naked).isNull;
        this.value = ((FloatingPointNumber)naked).value;
    }

    public void divide(double d) {
        this.checkCanOperate();
        this.value /= d;
    }

    public void divide(FloatingPointNumber floatingPointNumber) {
        this.checkCanOperate();
        floatingPointNumber.checkCanOperate();
        this.value /= floatingPointNumber.value;
    }

    public double doubleValue() {
        this.checkCanOperate();
        return this.value;
    }

    public float floatValue() {
        this.checkCanOperate();
        return (float)this.value;
    }

    public String getObjectHelpText() {
        return "A floating point number object.";
    }

    public double getValue() {
        this.checkCanOperate();
        return this.value;
    }

    public int intValue() {
        this.checkCanOperate();
        return (int)this.value;
    }

    public boolean isEmpty() {
        return this.isNull;
    }

    public boolean isEqualTo(Magnitude magnitude) {
        if (magnitude instanceof FloatingPointNumber) {
            if (this.isNull) {
                return magnitude.isEmpty();
            }
            return ((FloatingPointNumber)magnitude).value == this.value;
        }
        throw new IllegalArgumentException("Parameter must be of type FloatingPointNumber");
    }

    public boolean isLessThan(Magnitude magnitude) {
        if (magnitude instanceof FloatingPointNumber) {
            return !this.isEmpty() && !magnitude.isEmpty() && this.value < ((FloatingPointNumber)magnitude).value;
        }
        throw new IllegalArgumentException("Parameter must be of type FloatingPointNumber");
    }

    public long longValue() {
        this.checkCanOperate();
        return (long)this.value;
    }

    public void multiply(double d) {
        this.checkCanOperate();
        this.value *= d;
    }

    public void multiply(FloatingPointNumber floatingPointNumber) {
        this.checkCanOperate();
        floatingPointNumber.checkCanOperate();
        this.value *= floatingPointNumber.value;
    }

    public void parse(String string) throws ValueParseException {
        if (string.trim().equals("")) {
            this.clear();
        } else {
            try {
                this.value = FORMAT.parse(string).doubleValue();
            }
            catch (ParseException parseException) {
                throw new ValueParseException(parseException, "Invalid number");
            }
        }
    }

    public void reset() {
        this.value = 0.0;
        this.isNull = false;
    }

    public void setValue(double d) {
        this.value = d;
        this.isNull = false;
    }

    public void setValue(FloatingPointNumber floatingPointNumber) {
        this.value = floatingPointNumber.value;
        this.isNull = floatingPointNumber.isNull;
    }

    public short shortValue() {
        this.checkCanOperate();
        return (short)this.value;
    }

    public void subtract(double d) {
        this.add(-d);
    }

    public void subtract(FloatingPointNumber floatingPointNumber) {
        floatingPointNumber.checkCanOperate();
        this.add(-floatingPointNumber.value);
    }

    public Title title() {
        return new Title(this.isEmpty() ? "" : FORMAT.format(this.value));
    }

    public void restoreString(String string) {
        this.setValue(Double.valueOf(string));
    }

    public String saveString() {
        return String.valueOf(this.doubleValue());
    }
}

