import java.awt.*;
import java.io.*;
class Smap extends Frame{
    Scanvas sc;
    Image img;
    public Smap(){
        super("Astro Solutions ClearSky");
        pack();
        resize(600,640);
        img=createImage(600,640);
        sc=new Scanvas(img);
        add(sc);
        show();
    }
    public static void main(String[]args){
        new Smap();
    }
    public boolean handleEvent(Event evt){
        if(evt.id==Event.WINDOW_DESTROY)System.exit(0);
        return false;
    }
}
class Scanvas extends Canvas implements Runnable{
    Veks[]v;
    int counter=0;
    double winkel=Math.PI/2;
    Graphics h;
    Image img;
    int grenze=5;
    Thread t;
    public Scanvas(Image img){
        this.img=img;
        h=img.getGraphics();
        loadVeks();
        t=new Thread(this);
        t.start();
    }
    public void run(){
        for(int i=0;i<10;i++){
            try{
                repaint();
                Thread.sleep(250);
            }
            catch(Exception e){};
        }
    }
    public void loadVeks(){
        try{
            FileInputStream fis=new FileInputStream("ster");
            DataInputStream dis=new DataInputStream(fis);
            while(dis.readLine()!=null)counter++;
            dis.close();
            fis.close();
            counter=counter/4;
            v=new Veks[counter];
            FileInputStream fisz=new FileInputStream("ster");
            DataInputStream disz=new DataInputStream(fisz);
            for(int i=0;i<counter;i++){
                double x=new Double(disz.readLine()).doubleValue();
                double y=new Double(disz.readLine()).doubleValue();
                double z=new Double(disz.readLine()).doubleValue();
                int m=new Integer(disz.readLine()).intValue();
                v[i]=new Veks(x,y,z,m);
            }
            disz.close();
            fisz.close();
        }
        catch(Exception e){System.out.println(e);};
    }
    public boolean handleEvent(Event evt){
        if(evt.id==Event.MOUSE_DOWN){
            if(evt.x>300)rotLeft(Math.PI/45);
            if(evt.y>300)rotUp(Math.PI/45);
            if(evt.x<300)rotLeft(-Math.PI/45);
            if(evt.y<300)rotUp(-Math.PI/45);
            repaint();
        }
        if(evt.id==Event.WINDOW_DESTROY)System.exit(0);
        if(evt.id==Event.KEY_PRESS||evt.id==Event.KEY_ACTION){
        if(evt.key==Event.F1){grenze=3;repaint();}
        if(evt.key==Event.F2){grenze=4;repaint();}
        if(evt.key==Event.F3){grenze=5;repaint();}
        if(evt.key==Event.F4){grenze=6;repaint();}
        if(evt.key==Event.F5){grenze=7;repaint();}
        if(evt.key==Event.LEFT){rotUp(Math.PI/90);repaint();};
        if(evt.key==Event.RIGHT){rotUp(-Math.PI/90);repaint();};
        if(evt.key==Event.UP){rotLeft(Math.PI/90);repaint();};
        if(evt.key==Event.DOWN){rotLeft(-Math.PI/90);repaint();};
        if(evt.key==Event.ESCAPE){
            winkel*=1.3;
            if(winkel>Math.PI/2)winkel/=1.3;
            repaint();
        }
        if(evt.key==Event.ENTER){
            winkel*=0.7;
            repaint();
        }
        if(evt.key==Event.DELETE)repaint();
        }
        return false;
    }
    public void paint(Graphics g){
    }
    public void update(Graphics g){
        h.setColor(Color.black);
        h.fillRect(0,0,600,640);
        h.setColor(Color.white);
        for(int i=0;i<counter;i++){
            if(v[i].z>0){
                double alpha=Math.atan(v[i].x/v[i].z);
                double beta=Math.atan(v[i].y/v[i].z);
                int qx=(int)(alpha/winkel*300.0);
                int qy=(int)(beta/winkel*300.0);
                if(Math.abs(qx)<300&&Math.abs(qy)<300){
                    int size=(7-v[i].m);
                    if(v[i].m<=grenze){
                        h.fillOval(300+qx-(size/2),300+qy-(size/2),size,size);
                    }
                }
            }
        }
        g.drawImage(img,0,0,this);
        paint(g);
    }
    public void rotUp(double schieb){
        for(int j=0;j<counter;j++){
            double dax=v[j].x;
            double day=v[j].z;
            double win=Math.atan(day/dax);
            if(dax<0)win=win+Math.PI;
            if(win<0)win=2*Math.PI+win;
            win=win-schieb;
            double len=Math.sqrt(dax*dax+day*day);
            v[j].x=(Math.cos(win))*len;
            v[j].z=(Math.sin(win))*len;
        }
    }
    public void rotLeft(double schieb){
        for(int j=0;j<counter;j++){
            double dax=v[j].y;
            double day=v[j].z;
            double win=Math.atan(day/dax);
            if(dax<0)win=win+Math.PI;
            if(win<0)win=2*Math.PI+win;
            win=win-schieb;
            double len=Math.sqrt(dax*dax+day*day);
            v[j].y=(Math.cos(win))*len;
            v[j].z=(Math.sin(win))*len;
        }
    }
}
class Veks{
    double x,y,z;
    int m;
    public Veks(double a,double b,double c,int d){
        x=a;
        y=b;
        z=c;
        m=d;
    }
}
