package com.db4o.samples;

import com.db4o.*;
import com.db4o.lib.Logger;

public class S04_Get_By_Class
{
	public static void main(String[] args)
	{
		ObjectContainer db = Db4o.openFile("samples.yap");
		Logger.log("*** S04 Retrieving all objects of class Address");


		ObjectSet os = db.get(new Address());
		// A first introduction to Query-By-Example:
		// What you give is what you get!
		// If you specify an object, with no members set,
		// you get all objects of the class.

		// Note that you have to watch out for constructor side effects here.
		// If the constructor sets any members, they will be evaluated against
		// the stored objects.


		while(os.hasNext()){
			Logger.log(db, os.next());
		}
		db.close();
	}


	public static void logByClass(Class clazz){

		// We implement the above a little bit more generic to be used again.

		if(clazz != null){
			ObjectContainer db = Db4o.openFile("samples.yap");
			Logger.log("*** Retrieving all objects of class " + clazz.getName() );
			try{
				ObjectSet os = db.get(clazz.newInstance());
				while(os.hasNext()){
					Logger.log(db, os.next());
				}
			}catch(Exception e){
			}
			db.close();
		}
	}
}
