// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FIBDatabase.pas' rev: 4.00

#ifndef FIBDatabaseHPP
#define FIBDatabaseHPP

#pragma delphiheader begin
#pragma option push -w-
#include <FIBDBLoginDlg.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <pFIBEventLists.hpp>	// Pascal unit
#include <fib.hpp>	// Pascal unit
#include <IBBlobFilter.hpp>	// Pascal unit
#include <pFIBProps.hpp>	// Pascal unit
#include <IB_Externals.hpp>	// Pascal unit
#include <IB_Intf.hpp>	// Pascal unit
#include <ibase.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Fibdatabase
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TDesignDBOption { ddoIsDefaultDatabase, ddoStoreConnected, ddoNotSavePassword };
#pragma option pop

typedef Set<TDesignDBOption, ddoIsDefaultDatabase, ddoNotSavePassword>  TDesignDBOptions;

#pragma option push -b-
enum TpFIBDBEventType { detOnConnect, detBeforeDisconnect, detBeforeDestroy };
#pragma option pop

class DELPHICLASS TFIBDatabase;
class DELPHICLASS TFIBTransaction;
#pragma option push -b-
enum TTransactionAction { TARollback, TARollbackRetaining, TACommit, TACommitRetaining };
#pragma option pop

#pragma option push -b-
enum TTransactionState { tsActive, tsClosed, tsDoRollback, tsDoRollbackRetaining, tsDoCommit, tsDoCommitRetaining 
	};
#pragma option pop

class DELPHICLASS TFIBBase;
#pragma option push -b-
enum TpFIBTrEventType { tetOnStartTransaction, tetOnCloseTransaction, tetBeforeDestroy };
#pragma option pop

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TFIBTransaction : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
protected:
	bool FCanTimeout;
	Classes::TList* FDatabases;
	Classes::TList* FDataSets;
	TFIBDatabase* FDefaultDatabase;
	void * *FHandle;
	bool FHandleIsShared;
	Classes::TNotifyEvent FOnTimeout;
	bool FStreamedActive;
	char *FTPB;
	short FTPBLength;
	Extctrls::TTimer* FTimer;
	TTransactionAction FTimeoutAction;
	Classes::TStrings* FTRParams;
	bool FTRParamsChanged;
	TTransactionState FState;
	int FTransactionID;
	Pfibeventlists::TNotifyEventList* vOnDestroy;
	int __fastcall GetTransactionID(void);
	bool __fastcall DoStoreActive(void);
	virtual void __fastcall EndTransaction(TTransactionAction Action, bool Force);
	TFIBDatabase* __fastcall GetDatabase(int Index);
	int __fastcall GetDatabaseCount(void);
	TFIBBase* __fastcall GetDataSet(int Index);
	int __fastcall GetDataSetCount(void);
	bool __fastcall GetInTransaction(void);
	int __fastcall GetTimeout(void);
	virtual void __fastcall Loaded(void);
	void __fastcall SetActive(bool Value);
	void __fastcall SetDefaultDatabase(TFIBDatabase* Value);
	void __fastcall SetHandle(Ib_externals::PVoid Value);
	void __fastcall SetTimeout(int Value);
	void __fastcall SetTRParams(Classes::TStrings* Value);
	void __fastcall TimeoutTransaction(System::TObject* Sender);
	void __fastcall TRParamsChange(System::TObject* Sender);
	void __fastcall TRParamsChanging(System::TObject* Sender);
	void __fastcall RemoveDatabase(int Idx);
	void __fastcall ReplaceDatabase(TFIBDatabase* dbOld, TFIBDatabase* dbNew);
	void __fastcall RemoveDatabases(void);
	void __fastcall RemoveDataSet(int Idx);
	void __fastcall RemoveDataSets(void);
	
public:
	__fastcall virtual TFIBTransaction(Classes::TComponent* AOwner);
	__fastcall virtual ~TFIBTransaction(void);
	int __fastcall FindDatabase(TFIBDatabase* db);
	void __fastcall AddEvent(Classes::TNotifyEvent Event, TpFIBTrEventType EventType);
	void __fastcall RemoveEvent(Classes::TNotifyEvent Event, TpFIBTrEventType EventType);
	virtual void __fastcall DoOnSQLExec(Classes::TComponent* Query, Pfibprops::TKindOnOperation Kind);
	int __fastcall AddDatabase(TFIBDatabase* db);
	int __fastcall AddDataSet(TFIBBase* ds);
	void __fastcall OnDatabaseDisconnecting(TFIBDatabase* DB);
	int __fastcall Call(int ErrCode, bool RaiseError);
	void __fastcall CheckDatabasesInList(void);
	void __fastcall CheckInTransaction(void);
	void __fastcall CheckNotInTransaction(void);
	virtual void __fastcall Commit(void);
	virtual void __fastcall CommitRetaining(void);
	virtual void __fastcall Rollback(void);
	virtual void __fastcall RollbackRetaining(void);
	virtual void __fastcall StartTransaction(void);
	void __fastcall CloseAllQueryHandles(void);
	bool __fastcall IsReadCommitedTransaction(void);
	__property int DatabaseCount = {read=GetDatabaseCount, nodefault};
	__property TFIBDatabase* Databases[int Index] = {read=GetDatabase};
	__property int DataSetCount = {read=GetDataSetCount, nodefault};
	__property TFIBBase* DataSets[int Index] = {read=GetDataSet};
	__property Ib_externals::PVoid Handle = {read=FHandle, write=SetHandle};
	__property bool HandleIsShared = {read=FHandleIsShared, nodefault};
	__property bool InTransaction = {read=GetInTransaction, nodefault};
	__property char * TPB = {read=FTPB};
	__property short TPBLength = {read=FTPBLength, nodefault};
	__property TTransactionState State = {read=FState, nodefault};
	__property int TransactionID = {read=GetTransactionID, nodefault};
	
__published:
	__property bool Active = {read=GetInTransaction, write=SetActive, stored=DoStoreActive, nodefault};
		
	__property TFIBDatabase* DefaultDatabase = {read=FDefaultDatabase, write=SetDefaultDatabase};
	__property int Timeout = {read=GetTimeout, write=SetTimeout, default=0};
	__property TTransactionAction TimeoutAction = {read=FTimeoutAction, write=FTimeoutAction, nodefault
		};
	__property Classes::TStrings* TRParams = {read=FTRParams, write=SetTRParams};
	__property Classes::TNotifyEvent OnTimeout = {read=FOnTimeout, write=FOnTimeout};
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TFIBDatabase : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
protected:
	bool FCanTimeout;
	Classes::TList* FDatasets;
	Classes::TList* FTransactions;
	AnsiString FDBName;
	Pfibprops::TDBParams* FDBParams;
	bool FDBParamsChanged;
	char *FDPB;
	short FDPBLength;
	void * *FHandle;
	bool FHandleIsShared;
	bool FUseLoginPrompt;
	Classes::TNotifyEvent FOnConnect;
	Classes::TNotifyEvent FOnTimeout;
	TFIBTransaction* FDefaultTransaction;
	bool FStreamedConnected;
	Extctrls::TTimer* FTimer;
	Classes::TStringList* FUserNames;
	Classes::TStringList* FBackoutCount;
	Classes::TStringList* FDeleteCount;
	Classes::TStringList* FExpungeCount;
	Classes::TStringList* FInsertCount;
	Classes::TStringList* FPurgeCount;
	Classes::TStringList* FReadIdxCount;
	Classes::TStringList* FReadSeqCount;
	Classes::TStringList* FUpdateCount;
	int FSQLDialect;
	bool FUpperOldNames;
	bool FIBLoaded;
	Pfibprops::TConnectParams* FConnectParams;
	TDesignDBOptions FDesignDBOptions;
	Classes::TNotifyEvent FBeforeDisconnect;
	Classes::TNotifyEvent FAfterDisconnect;
	double FDifferenceTime;
	bool FSynchronizeTime;
	TFIBTransaction* vInternalTransaction;
	Pfibeventlists::TNotifyEventList* vOnConnected;
	Pfibeventlists::TNotifyEventList* vBeforeDisconnect;
	Pfibeventlists::TNotifyEventList* vOnDestroy;
	int vAttachmentID;
	Ibblobfilter::TIBBlobFilters* FBlobFilters;
	void __fastcall DBParamsChange(System::TObject* Sender);
	void __fastcall DBParamsChanging(System::TObject* Sender);
	bool __fastcall GetConnected(void);
	AnsiString __fastcall GetDatabaseName(void);
	TFIBBase* __fastcall GetDataSet(int Index);
	int __fastcall GetDataSetCount(void);
	AnsiString __fastcall GetDBParamByDPB(const int Idx);
	int __fastcall GetTimeout(void);
	TFIBTransaction* __fastcall GetTransaction(int Index);
	int __fastcall GetTransactionCount(void);
	int __fastcall GetActiveTransactionCount(void);
	bool __fastcall Login(void);
	void __fastcall SetConnected(bool Value);
	void __fastcall SetDatabaseName(const AnsiString Value);
	void __fastcall SetDBParamByDPB(const int Idx, AnsiString Value);
	void __fastcall SetDBParamByName(const AnsiString ParName, const AnsiString Value);
	void __fastcall SetDBParams(Pfibprops::TDBParams* Value);
	void __fastcall SetDefaultTransaction(TFIBTransaction* Value);
	void __fastcall SetHandle(Ib_externals::PVoid Value);
	void __fastcall SetTimeout(int Value);
	void __fastcall TimeoutConnection(System::TObject* Sender);
	int __fastcall GetAllocation(void);
	int __fastcall GetBaseLevel(void);
	AnsiString __fastcall GetDBFileName(void);
	AnsiString __fastcall GetDBSiteName(void);
	int __fastcall GetDBImplementationNo(void);
	int __fastcall GetDBImplementationClass(void);
	int __fastcall GetNoReserve(void);
	int __fastcall GetODSMinorVersion(void);
	int __fastcall GetODSMajorVersion(void);
	int __fastcall GetPageSize(void);
	AnsiString __fastcall GetVersion(void);
	int __fastcall GetCurrentMemory(void);
	int __fastcall GetForcedWrites(void);
	int __fastcall GetMaxMemory(void);
	int __fastcall GetNumBuffers(void);
	int __fastcall GetSweepInterval(void);
	Classes::TStringList* __fastcall GetUserNames(void);
	int __fastcall GetFetches(void);
	int __fastcall GetMarks(void);
	int __fastcall GetReads(void);
	int __fastcall GetWrites(void);
	Classes::TStringList* __fastcall GetBackoutCount(void);
	Classes::TStringList* __fastcall GetDeleteCount(void);
	Classes::TStringList* __fastcall GetExpungeCount(void);
	Classes::TStringList* __fastcall GetInsertCount(void);
	Classes::TStringList* __fastcall GetPurgeCount(void);
	Classes::TStringList* __fastcall GetReadIdxCount(void);
	Classes::TStringList* __fastcall GetReadSeqCount(void);
	Classes::TStringList* __fastcall GetUpdateCount(void);
	Classes::TStringList* __fastcall GetOperationCounts(int DBInfoCommand, Classes::TStringList* &FOperation
		);
	int __fastcall GetLogFile(void);
	AnsiString __fastcall GetCurLogFileName(void);
	int __fastcall GetCurLogPartitionOffset(void);
	int __fastcall GetNumWALBuffers(void);
	int __fastcall GetWALBufferSize(void);
	int __fastcall GetWALCheckpointLength(void);
	int __fastcall GetWALCurCheckpointInterval(void);
	AnsiString __fastcall GetWALPrvCheckpointFilename(void);
	int __fastcall GetWALPrvCheckpointPartOffset(void);
	int __fastcall GetWALGroupCommitWaitUSecs(void);
	int __fastcall GetWALNumIO(void);
	int __fastcall GetWALAverageIOSize(void);
	int __fastcall GetWALNumCommits(void);
	int __fastcall GetWALAverageGroupCommitSize(void);
	int __fastcall GetProtectLongDBInfo(int DBInfoCommand, bool &Success);
	AnsiString __fastcall GetStringDBInfo(int DBInfoCommand);
	int __fastcall GetLongDBInfo(int DBInfoCommand);
	int __fastcall GetAttachmentID(void);
	Word __fastcall GetDBSQLDialect(void);
	void __fastcall SetSQLDialect(const int Value);
	void __fastcall SetDesignDBOptions(TDesignDBOptions Value);
	int __fastcall GetReadOnly(void);
	bool __fastcall GetStoreConnected(void);
	virtual void __fastcall Loaded(void);
	virtual void __fastcall InternalClose(bool Force);
	void __fastcall DoOnConnect(void);
	void __fastcall DoBeforeDisconnect(void);
	void __fastcall DoAfterDisconnect(void);
	void __fastcall RemoveDataSet(int Idx);
	void __fastcall RemoveDataSets(void);
	void __fastcall RemoveTransaction(int Idx);
	void __fastcall RemoveTransactions(void);
	int __fastcall AddDataSet(TFIBBase* ds);
	int __fastcall AddTransaction(TFIBTransaction* TR);
	void __fastcall IBFilterBuffer(char * &BlobBuffer, int &BlobSize, int BlobSubType, bool ForEncode);
		
	
public:
	void __fastcall AddEvent(Classes::TNotifyEvent Event, TpFIBDBEventType EventType);
	void __fastcall RemoveEvent(Classes::TNotifyEvent Event, TpFIBDBEventType EventType);
	void __fastcall RegisterBlobFilter(int BlobSubType, Ibblobfilter::PIBBlobFilterProc EncodeProc, Ibblobfilter::PIBBlobFilterProc 
		DecodeProc);
	void __fastcall RemoveBlobFilter(int BlobSubType);
	__fastcall virtual TFIBDatabase(Classes::TComponent* AOwner);
	__fastcall virtual ~TFIBDatabase(void);
	int __fastcall Call(int ErrCode, bool RaiseError);
	void __fastcall CheckActive(void);
	void __fastcall CheckInactive(void);
	void __fastcall CheckDatabaseName(void);
	void __fastcall Close(void);
	void __fastcall CreateDatabase(void);
	__property AnsiString DBParamByDPB[int Idx] = {read=GetDBParamByDPB, write=SetDBParamByDPB};
	void __fastcall DropDatabase(void);
	int __fastcall FindTransaction(TFIBTransaction* TR);
	void __fastcall ForceClose(void);
	int __fastcall IndexOfDBConst(const AnsiString st);
	virtual void __fastcall Open(void);
	bool __fastcall TestConnected(void);
	AnsiString __fastcall ClientVersion(void);
	int __fastcall ClientMajorVersion(void);
	int __fastcall ClientMinorVersion(void);
	__property bool CanTimeout = {read=FCanTimeout, write=FCanTimeout, nodefault};
	__property int DataSetCount = {read=GetDataSetCount, nodefault};
	__property TFIBBase* DataSets[int Index] = {read=GetDataSet};
	__property Ib_externals::PVoid Handle = {read=FHandle, write=SetHandle};
	__property bool HandleIsShared = {read=FHandleIsShared, nodefault};
	__property int TransactionCount = {read=GetTransactionCount, nodefault};
	__property int ActiveTransactionCount = {read=GetActiveTransactionCount, nodefault};
	__property TFIBTransaction* Transactions[int Index] = {read=GetTransaction};
	__property int AttachmentID = {read=GetAttachmentID, nodefault};
	__property int Allocation = {read=GetAllocation, nodefault};
	__property int BaseLevel = {read=GetBaseLevel, nodefault};
	__property AnsiString DBFileName = {read=GetDBFileName};
	__property AnsiString DBSiteName = {read=GetDBSiteName};
	__property int DBImplementationNo = {read=GetDBImplementationNo, nodefault};
	__property int DBImplementationClass = {read=GetDBImplementationClass, nodefault};
	__property int NoReserve = {read=GetNoReserve, nodefault};
	__property int ODSMinorVersion = {read=GetODSMinorVersion, nodefault};
	__property int ODSMajorVersion = {read=GetODSMajorVersion, nodefault};
	__property int PageSize = {read=GetPageSize, nodefault};
	__property AnsiString Version = {read=GetVersion};
	__property int CurrentMemory = {read=GetCurrentMemory, nodefault};
	__property int ForcedWrites = {read=GetForcedWrites, nodefault};
	__property int MaxMemory = {read=GetMaxMemory, nodefault};
	__property int NumBuffers = {read=GetNumBuffers, nodefault};
	__property int SweepInterval = {read=GetSweepInterval, nodefault};
	__property Classes::TStringList* UserNames = {read=GetUserNames};
	__property int Fetches = {read=GetFetches, nodefault};
	__property int Marks = {read=GetMarks, nodefault};
	__property int Reads = {read=GetReads, nodefault};
	__property int Writes = {read=GetWrites, nodefault};
	__property Classes::TStringList* BackoutCount = {read=GetBackoutCount};
	__property Classes::TStringList* DeleteCount = {read=GetDeleteCount};
	__property Classes::TStringList* ExpungeCount = {read=GetExpungeCount};
	__property Classes::TStringList* InsertCount = {read=GetInsertCount};
	__property Classes::TStringList* PurgeCount = {read=GetPurgeCount};
	__property Classes::TStringList* ReadIdxCount = {read=GetReadIdxCount};
	__property Classes::TStringList* ReadSeqCount = {read=GetReadSeqCount};
	__property Classes::TStringList* UpdateCount = {read=GetUpdateCount};
	__property int LogFile = {read=GetLogFile, nodefault};
	__property AnsiString CurLogFileName = {read=GetCurLogFileName};
	__property int CurLogPartitionOffset = {read=GetCurLogPartitionOffset, nodefault};
	__property int NumWALBuffers = {read=GetNumWALBuffers, nodefault};
	__property int WALBufferSize = {read=GetWALBufferSize, nodefault};
	__property int WALCheckpointLength = {read=GetWALCheckpointLength, nodefault};
	__property int WALCurCheckpointInterval = {read=GetWALCurCheckpointInterval, nodefault};
	__property AnsiString WALPrvCheckpointFilename = {read=GetWALPrvCheckpointFilename};
	__property int WALPrvCheckpointPartOffset = {read=GetWALPrvCheckpointPartOffset, nodefault};
	__property int WALGroupCommitWaitUSecs = {read=GetWALGroupCommitWaitUSecs, nodefault};
	__property int WALNumIO = {read=GetWALNumIO, nodefault};
	__property int WALAverageIOSize = {read=GetWALAverageIOSize, nodefault};
	__property int WALNumCommits = {read=GetWALNumCommits, nodefault};
	__property int WALAverageGroupCommitSize = {read=GetWALAverageGroupCommitSize, nodefault};
	__property Word DBSQLDialect = {read=GetDBSQLDialect, nodefault};
	__property int ReadOnly = {read=GetReadOnly, nodefault};
	__property AnsiString DatabaseName = {read=GetDatabaseName, write=SetDatabaseName};
	__property double DifferenceTime = {read=FDifferenceTime};
	void __fastcall StartTransaction(void);
	void __fastcall CloseDataSets(void);
	void __fastcall Commit(void);
	void __fastcall Rollback(void);
	void __fastcall CommitRetaining(void);
	void __fastcall RollbackRetaining(void);
	__int64 __fastcall Gen_Id(const AnsiString GeneratorName, __int64 Step);
	bool __fastcall Execute(const AnsiString SQL);
	Variant __fastcall InternalQueryValue(const AnsiString aSQL, int FieldNo, const Variant * ParamValues
		, const int ParamValues_Size);
	Variant __fastcall QueryValue(const AnsiString aSQL, int FieldNo)/* overload */;
	Variant __fastcall QueryValue(const AnsiString aSQL, int FieldNo, const Variant * ParamValues, const 
		int ParamValues_Size)/* overload */;
	AnsiString __fastcall QueryValueAsStr(const AnsiString aSQL, int FieldNo);
	bool __fastcall EasyFormatsStr(void);
	__property bool StoreConnected = {read=GetStoreConnected, nodefault};
	
__published:
	__property bool Connected = {read=GetConnected, write=SetConnected, stored=GetStoreConnected, nodefault
		};
	__property AnsiString DBName = {read=GetDatabaseName, write=SetDatabaseName};
	__property Pfibprops::TDBParams* DBParams = {read=FDBParams, write=SetDBParams};
	__property TFIBTransaction* DefaultTransaction = {read=FDefaultTransaction, write=SetDefaultTransaction
		};
	__property int SQLDialect = {read=FSQLDialect, write=SetSQLDialect, nodefault};
	__property int Timeout = {read=GetTimeout, write=SetTimeout, nodefault};
	__property bool UseLoginPrompt = {read=FUseLoginPrompt, write=FUseLoginPrompt, default=0};
	__property Classes::TNotifyEvent OnConnect = {read=FOnConnect, write=FOnConnect};
	__property Classes::TNotifyEvent OnTimeout = {read=FOnTimeout, write=FOnTimeout};
	__property bool UpperOldNames = {read=FUpperOldNames, write=FUpperOldNames, default=0};
	__property Classes::TNotifyEvent BeforeDisconnect = {read=FBeforeDisconnect, write=FBeforeDisconnect
		};
	__property Classes::TNotifyEvent AfterDisconnect = {read=FAfterDisconnect, write=FAfterDisconnect};
		
	__property Pfibprops::TConnectParams* ConnectParams = {read=FConnectParams, write=FConnectParams, stored=false
		};
	__property bool SynchronizeTime = {read=FSynchronizeTime, write=FSynchronizeTime, default=1};
	__property TDesignDBOptions DesignDBOptions = {read=FDesignDBOptions, write=SetDesignDBOptions, default=2
		};
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TFIBBase : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	TFIBDatabase* FDatabase;
	int FIndexInDatabase;
	TFIBTransaction* FTransaction;
	int FIndexInTransaction;
	System::TObject* FOwner;
	void __fastcall FOnDatabaseConnecting(void);
	void __fastcall FOnDatabaseConnected(void);
	void __fastcall FOnDatabaseDisconnecting(void);
	void __fastcall FOnDatabaseDisconnected(void);
	void __fastcall FOnTransactionStarting(void);
	void __fastcall FOnTransactionStarted(void);
	void __fastcall FOnDatabaseFree(void);
	void __fastcall FOnTransactionEnding(void);
	void __fastcall FOnTransactionEnded(void);
	void __fastcall FOnTransactionFree(void);
	Ibase::PISC_DB_HANDLE __fastcall GetDBHandle(void);
	Ibase::PISC_TR_HANDLE __fastcall GetTRHandle(void);
	void __fastcall SetDatabase(TFIBDatabase* Value);
	void __fastcall SetTransaction(TFIBTransaction* Value);
	
public:
	__fastcall TFIBBase(System::TObject* AOwner);
	__fastcall virtual ~TFIBBase(void);
	virtual void __fastcall CheckDatabase(void);
	virtual void __fastcall CheckTransaction(void);
	Classes::TNotifyEvent OnDatabaseConnecting;
	Classes::TNotifyEvent OnDatabaseConnected;
	Classes::TNotifyEvent OnDatabaseDisconnecting;
	Classes::TNotifyEvent OnDatabaseDisconnected;
	Classes::TNotifyEvent OnDatabaseFree;
	Classes::TNotifyEvent OnTransactionEnding;
	Classes::TNotifyEvent OnTransactionEnded;
	Classes::TNotifyEvent OnTransactionStarting;
	Classes::TNotifyEvent OnTransactionStarted;
	Classes::TNotifyEvent OnTransactionFree;
	__property TFIBDatabase* Database = {read=FDatabase, write=SetDatabase};
	__property Ibase::PISC_DB_HANDLE DBHandle = {read=GetDBHandle};
	__property System::TObject* Owner = {read=FOwner};
	__property Ibase::PISC_TR_HANDLE TRHandle = {read=GetTRHandle};
	__property TFIBTransaction* Transaction = {read=FTransaction, write=SetTransaction};
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE TFIBDatabase* DefDataBase;
extern PACKAGE Classes::TNotifyEvent AppHandleException;
extern PACKAGE TFIBDatabase* __fastcall GetConnectedDataBase(const AnsiString DBName);
extern PACKAGE void __fastcall IBFilterBuffer(TFIBDatabase* DataBase, char * &BlobBuffer, int &BlobSize
	, int BlobSubType, bool ForEncode);
extern PACKAGE void __fastcall SaveSchemaToFile(const AnsiString FileName);
extern PACKAGE void __fastcall LoadSchemaFromFile(const AnsiString FileName);

}	/* namespace Fibdatabase */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Fibdatabase;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// FIBDatabase
