/*
 * Decompiled with CFR 0.152.
 */
package com.webforte.cid;

import com.webforte.cid.CIDUserInterface;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class CIDConfig {
    private static CIDConfig instance = null;
    private String deviceName;
    private String storeFile;
    private String skinPath;
    private String currentSkin;
    ArrayList forbiddenNumbers = new ArrayList();

    public CIDConfig() {
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new FileReader(new File("vcid.cfg")));
            streamTokenizer.wordChars(33, 255);
            streamTokenizer.commentChar(59);
            streamTokenizer.slashSlashComments(false);
            streamTokenizer.slashStarComments(false);
            streamTokenizer.ordinaryChar(61);
            try {
                while (streamTokenizer.nextToken() != -1) {
                    if (streamTokenizer.ttype != -3) continue;
                    if (streamTokenizer.sval.compareTo("modemPort") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        this.deviceName = streamTokenizer.sval;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("storeFile") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        this.storeFile = streamTokenizer.sval;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("skins") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        this.skinPath = streamTokenizer.sval;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("currentSkin") != 0) continue;
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    this.currentSkin = streamTokenizer.sval;
                }
            }
            catch (IOException iOException) {
                CIDUserInterface.setLF();
                CIDUserInterface.systemErrorDialog("Error reading file", "An error occured while reading the 'vcid.cfg' file.\nThis application will now exit.");
                System.exit(0);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            CIDUserInterface.setLF();
            CIDUserInterface.systemErrorDialog("File not found", "The 'vcid.cfg' file could not be found in the application directory.\nThis application will now exit.");
            System.exit(0);
        }
    }

    public void addNumberToForbid(String string) {
        this.forbiddenNumbers.add(string);
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public ArrayList getForbiddenNumbers() {
        return this.forbiddenNumbers;
    }

    public static CIDConfig getInstance() {
        if (instance == null) {
            instance = new CIDConfig();
        }
        return instance;
    }

    public File getStoreFile() {
        return new File(this.storeFile);
    }

    public void installUI() {
        int n = 0;
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new FileReader(new File(new File(this.skinPath, this.currentSkin), "skin.ini")));
            streamTokenizer.wordChars(33, 255);
            streamTokenizer.commentChar(59);
            streamTokenizer.slashSlashComments(false);
            streamTokenizer.slashStarComments(false);
            streamTokenizer.ordinaryChar(61);
            streamTokenizer.parseNumbers();
            try {
                while (streamTokenizer.nextToken() != -1) {
                    File file;
                    if (streamTokenizer.ttype != -3) continue;
                    if (streamTokenizer.sval.compareTo("image") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        file = new File(new File(this.skinPath, this.currentSkin), streamTokenizer.sval);
                        CIDUserInterface.im = new ImageIcon(file.toURL());
                        CIDUserInterface.sizeX = CIDUserInterface.im.getIconWidth();
                        CIDUserInterface.sizeY = CIDUserInterface.im.getIconHeight();
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("deleteButtonPressed") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        file = new File(new File(this.skinPath, this.currentSkin), streamTokenizer.sval);
                        CIDUserInterface.bp1 = new ImageIcon(file.toURL());
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("leftButtonPressed") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        file = new File(new File(this.skinPath, this.currentSkin), streamTokenizer.sval);
                        CIDUserInterface.bp2 = new ImageIcon(file.toURL());
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("rightButtonPressed") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        file = new File(new File(this.skinPath, this.currentSkin), streamTokenizer.sval);
                        CIDUserInterface.bp3 = new ImageIcon(file.toURL());
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("deleteButton") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        file = new File(new File(this.skinPath, this.currentSkin), streamTokenizer.sval);
                        CIDUserInterface.b1 = new ImageIcon(file.toURL());
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("leftButton") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        file = new File(new File(this.skinPath, this.currentSkin), streamTokenizer.sval);
                        CIDUserInterface.b2 = new ImageIcon(file.toURL());
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("rightButton") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        file = new File(new File(this.skinPath, this.currentSkin), streamTokenizer.sval);
                        CIDUserInterface.b3 = new ImageIcon(file.toURL());
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("ledDisplayOn") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        file = new File(new File(this.skinPath, this.currentSkin), streamTokenizer.sval);
                        CIDUserInterface.ln = new ImageIcon(file.toURL());
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("ledDisplayOff") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        file = new File(new File(this.skinPath, this.currentSkin), streamTokenizer.sval);
                        CIDUserInterface.lf = new ImageIcon(file.toURL());
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("messageDisplayOn") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        file = new File(new File(this.skinPath, this.currentSkin), streamTokenizer.sval);
                        CIDUserInterface.mn = new ImageIcon(file.toURL());
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("messageDisplayOff") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        file = new File(new File(this.skinPath, this.currentSkin), streamTokenizer.sval);
                        CIDUserInterface.mf = new ImageIcon(file.toURL());
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("deleteButtonXleft") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        CIDUserInterface.b1X = (int)streamTokenizer.nval;
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("deleteButtonYtop") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        CIDUserInterface.b1Y = (int)streamTokenizer.nval;
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("leftButtonXleft") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        CIDUserInterface.b2X = (int)streamTokenizer.nval;
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("leftButtonYtop") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        CIDUserInterface.b2Y = (int)streamTokenizer.nval;
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("rightButtonXleft") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        CIDUserInterface.b3X = (int)streamTokenizer.nval;
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("rightButtonYtop") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        CIDUserInterface.b3Y = (int)streamTokenizer.nval;
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("ledDisplayXleft") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        CIDUserInterface.lX = (int)streamTokenizer.nval;
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("ledDisplayYtop") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        CIDUserInterface.lY = (int)streamTokenizer.nval;
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("messageDisplayXleft") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        CIDUserInterface.mX = (int)streamTokenizer.nval;
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("messageDisplayYtop") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        CIDUserInterface.mY = (int)streamTokenizer.nval;
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("callDisplayXleft") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        CIDUserInterface.cX = (int)streamTokenizer.nval;
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("callDisplayYtop") == 0) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        CIDUserInterface.cY = (int)streamTokenizer.nval;
                        ++n;
                        continue;
                    }
                    if (streamTokenizer.sval.compareTo("displayTextColor") != 0) continue;
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    CIDUserInterface.textColor = new Color((int)Long.parseLong(streamTokenizer.sval.substring(1, streamTokenizer.sval.length()), 16));
                    ++n;
                }
            }
            catch (IOException iOException) {
                CIDUserInterface.setLF();
                CIDUserInterface.systemErrorDialog("Error reading file", "An error occured while reading the 'vcid.cfg' file.\nThis application will now exit.");
                System.exit(0);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            CIDUserInterface.setLF();
            CIDUserInterface.systemErrorDialog("File not found", "The 'vcid.cfg' file could not be found in the application directory.\nThis application will now exit.");
            System.exit(0);
        }
        if (n != 24) {
            CIDUserInterface.setLF();
            CIDUserInterface.systemErrorDialog("Invalid INI file", "The 'skin.ini' file is incomplete or invalid.\nThis application will now exit.");
            System.exit(0);
        }
        CIDUserInterface.b1bX = CIDUserInterface.b1X + CIDUserInterface.b1.getIconWidth();
        CIDUserInterface.b1bY = CIDUserInterface.b1Y + CIDUserInterface.b1.getIconHeight();
        CIDUserInterface.b2bX = CIDUserInterface.b2X + CIDUserInterface.b2.getIconWidth();
        CIDUserInterface.b2bY = CIDUserInterface.b2Y + CIDUserInterface.b2.getIconHeight();
        CIDUserInterface.b3bX = CIDUserInterface.b3X + CIDUserInterface.b3.getIconWidth();
        CIDUserInterface.b3bY = CIDUserInterface.b3Y + CIDUserInterface.b3.getIconHeight();
    }
}

