/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlGui.playlist.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javazoom.Util.Config;
import javazoom.Util.FileSelector;
import javazoom.jlGui.Player;
import javazoom.jlGui.playlist.Playlist;
import javazoom.jlGui.playlist.PlaylistItem;
import javazoom.jlGui.skin.SkinLoader;
import javazoom.jlGui.skin.UrlDialog;
import javazoom.jlGui.skin.activeComponent;
import javazoom.jlGui.tag.MpegInfo;
import javazoom.jlGui.tag.OggVorbisInfo;
import javazoom.jlGui.tag.TagInfo;
import javazoom.jlGui.tag.ui.MpegDialog;
import javazoom.jlGui.tag.ui.OggVorbisDialog;

public class MP3Files
extends Window
implements ActionListener {
    private String pledit = "pledit.txt";
    private Color current = new Color(102, 204, 255);
    private Color normal = new Color(178, 228, 246);
    private Color selBg = Color.black;
    private Color bgcolor = Color.black;
    private int topIndex = 0;
    private int currentSelection = -1;
    private Image imWinamp;
    private Image listBack;
    private int WinWidth;
    private int WinHeight;
    private int[] listarea = new int[]{12, 20, 256, 78};
    private Image offScreenImage;
    private Graphics offScreenGraphics;
    private Graphics gG = null;
    private Image scrollBarNormal;
    private Image scrollBarClicked;
    private boolean FirstBarDrag = true;
    private int[] scrollBarRange = new int[]{20, 60};
    private int scrollBarX = -1;
    private int scrollBarLocation = this.scrollBarRange[0];
    private int XBarDrag = 0;
    private Image titleCenter;
    private Image titleLeft;
    private Image titleRight;
    private Image titleStretch;
    private Image btmLeft;
    private Image btmRight;
    private Image bodyLeft;
    private Image bodyRight;
    private Image downScrollButton;
    private Image upScrollButton;
    private activeComponent acUpScrollButton;
    private activeComponent acDownScrollButton;
    private activeComponent acScrollBar;
    private Window addFileWnd = null;
    private Window subFileWnd = null;
    private Window selFileWnd = null;
    private Window optFileWnd = null;
    private final int gapsInButtons = 29;
    private int[] addarea = new int[]{14, 84, 36, 102};
    private Playlist playlist = null;
    private Config config = null;
    private Player player = null;
    private Vector exts = null;
    public static int MAXDEPTH = 4;
    private boolean isSearching;
    private PopupMenu fipopup = null;

    public MP3Files(Frame frame, Player player, Playlist playlist, SkinLoader skinLoader, int n, int n2, boolean bl) {
        super(frame);
        this.setLayout(null);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MP3Files.this.handleMouseClick(mouseEvent);
            }
        });
        this.playlist = playlist;
        this.player = player;
        this.config = Config.getInstance();
        this.getPleditInfo(skinLoader);
        this.imWinamp = skinLoader.getImage("pledit.bmp");
        this.WinWidth = 275;
        this.WinHeight = 116;
        this.scrollBarX = this.WinWidth - 15;
        this.scrollBarNormal = frame.createImage(8, 18);
        Graphics graphics = this.scrollBarNormal.getGraphics();
        graphics.drawImage(this.imWinamp, 0, 0, 8, 18, 52, 53, 60, 71, null);
        this.scrollBarClicked = frame.createImage(8, 18);
        graphics = this.scrollBarClicked.getGraphics();
        graphics.drawImage(this.imWinamp, 0, 0, 8, 18, 61, 53, 69, 71, null);
        this.acScrollBar = new activeComponent(this.scrollBarNormal, this.scrollBarClicked, 48L);
        this.acScrollBar.setLocation(this.scrollBarX, this.scrollBarLocation);
        this.add(this.acScrollBar);
        this.acScrollBar.setActionCommand("Scroll");
        this.acScrollBar.addActionListener(this);
        this.titleCenter = frame.createImage(100, 20);
        graphics = this.titleCenter.getGraphics();
        graphics.drawImage(this.imWinamp, 0, 0, 100, 20, 26, 0, 126, 20, null);
        this.titleLeft = frame.createImage(25, 20);
        graphics = this.titleLeft.getGraphics();
        graphics.drawImage(this.imWinamp, 0, 0, 25, 20, 0, 0, 25, 20, null);
        this.titleStretch = frame.createImage(25, 20);
        graphics = this.titleStretch.getGraphics();
        graphics.drawImage(this.imWinamp, 0, 0, 25, 20, 127, 0, 152, 20, null);
        this.titleRight = frame.createImage(25, 20);
        graphics = this.titleRight.getGraphics();
        graphics.drawImage(this.imWinamp, 0, 0, 25, 20, 153, 0, 178, 20, null);
        this.btmLeft = frame.createImage(125, 38);
        graphics = this.btmLeft.getGraphics();
        graphics.drawImage(this.imWinamp, 0, 0, 125, 38, 0, 72, 125, 110, null);
        this.btmRight = frame.createImage(150, 38);
        graphics = this.btmRight.getGraphics();
        graphics.drawImage(this.imWinamp, 0, 0, 150, 38, 126, 72, 276, 110, null);
        this.bodyLeft = frame.createImage(12, 28);
        graphics = this.bodyLeft.getGraphics();
        graphics.drawImage(this.imWinamp, 0, 0, 12, 28, 0, 42, 12, 70, null);
        this.bodyRight = frame.createImage(20, 28);
        graphics = this.bodyRight.getGraphics();
        graphics.drawImage(this.imWinamp, 0, 0, 20, 28, 31, 42, 51, 70, null);
        this.upScrollButton = frame.createImage(8, 4);
        graphics = this.upScrollButton.getGraphics();
        graphics.drawImage(this.imWinamp, 0, 0, 8, 4, 261, 75, 269, 79, null);
        this.acUpScrollButton = new activeComponent(this.upScrollButton, this.upScrollButton, 24L);
        this.acUpScrollButton.setLocation(this.WinWidth - 15, this.WinHeight - 35);
        this.add(this.acUpScrollButton);
        this.acUpScrollButton.setActionCommand("ScrollUp");
        this.acUpScrollButton.addActionListener(this);
        this.downScrollButton = frame.createImage(8, 4);
        graphics = this.downScrollButton.getGraphics();
        graphics.drawImage(this.imWinamp, 0, 0, 8, 4, 261, 80, 269, 84, null);
        this.acDownScrollButton = new activeComponent(this.downScrollButton, this.downScrollButton, 16L);
        this.acDownScrollButton.setLocation(this.WinWidth - 15, this.WinHeight - 30);
        this.add(this.acDownScrollButton);
        this.acDownScrollButton.setActionCommand("ScrollDown");
        this.acDownScrollButton.addActionListener(this);
        this.fipopup = new PopupMenu("FileInfo");
        MenuItem menuItem = new MenuItem("File Info");
        menuItem.addActionListener(this);
        this.fipopup.add(menuItem);
        this.fipopup.addSeparator();
        menuItem = new MenuItem("Play Item");
        menuItem.addActionListener(this);
        this.fipopup.add(menuItem);
        this.fipopup.addSeparator();
        menuItem = new MenuItem("Remove Item(s)");
        menuItem.addActionListener(this);
        this.fipopup.add(menuItem);
        this.add(this.fipopup);
        this.setSize(this.WinWidth, this.WinHeight);
        this.setLocation(n, n2);
        this.setBackground(Color.black);
        this.show(bl);
        this.pack();
    }

    public void initPlayList() {
        this.topIndex = 0;
        this.nextCursor();
    }

    public void nextCursor() {
        this.currentSelection = this.playlist.getSelectedIndex();
        int n = this.playlist.getPlaylistSize();
        int n2 = (this.listarea[3] - this.listarea[1]) / 12;
        while (this.currentSelection - this.topIndex > n2 - 1) {
            this.topIndex += 2;
        }
        if (this.topIndex >= n) {
            this.topIndex = n - 1;
        }
        while (this.currentSelection < this.topIndex) {
            this.topIndex -= 2;
        }
        if (this.topIndex < 0) {
            this.topIndex = 0;
        }
        this.resetScrollBar();
        this.repaint();
    }

    private void getPleditInfo(SkinLoader skinLoader) {
        String string = (String)skinLoader.getContent(this.pledit);
        string = string.toLowerCase();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.toLowerCase().startsWith("normalbg")) {
                    this.bgcolor = this.parseColor(string2);
                    continue;
                }
                if (string2.toLowerCase().startsWith("normal")) {
                    this.normal = this.parseColor(string2);
                    continue;
                }
                if (string2.toLowerCase().startsWith("current")) {
                    this.current = this.parseColor(string2);
                    continue;
                }
                if (!string2.toLowerCase().startsWith("selectedbg")) continue;
                this.selBg = this.parseColor(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            byteArrayInputStream.close();
        }
        catch (Exception exception) {}
    }

    private Color parseColor(String string) throws Exception {
        int n = string.indexOf("#");
        if (n == -1 && (n = string.indexOf("=")) == -1) {
            throw new Exception("Can not parse color!");
        }
        string = string.substring(n + 1);
        int n2 = Integer.parseInt(string.substring(0, 2), 16);
        int n3 = Integer.parseInt(string.substring(2, 4), 16);
        int n4 = Integer.parseInt(string.substring(4), 16);
        return new Color(n2, n3, n4);
    }

    public void paint(Graphics graphics) {
        if (this.offScreenImage == null) {
            this.offScreenImage = this.createImage(this.WinWidth, this.WinHeight);
            this.offScreenGraphics = this.offScreenImage.getGraphics();
            this.offScreenGraphics.drawImage(this.titleLeft, 0, 0, this);
            this.offScreenGraphics.drawImage(this.titleStretch, 25, 0, this);
            this.offScreenGraphics.drawImage(this.titleStretch, 50, 0, this);
            this.offScreenGraphics.drawImage(this.titleStretch, 62, 0, this);
            this.offScreenGraphics.drawImage(this.titleCenter, 87, 0, this);
            this.offScreenGraphics.drawImage(this.titleStretch, 187, 0, this);
            this.offScreenGraphics.drawImage(this.titleStretch, 200, 0, this);
            this.offScreenGraphics.drawImage(this.titleStretch, 225, 0, this);
            this.offScreenGraphics.drawImage(this.titleRight, 250, 0, this);
            this.offScreenGraphics.drawImage(this.bodyLeft, 0, 20, this);
            this.offScreenGraphics.drawImage(this.bodyLeft, 0, 48, this);
            this.offScreenGraphics.drawImage(this.bodyLeft, 0, 50, this);
            this.offScreenGraphics.drawImage(this.btmLeft, 0, this.WinHeight - 38, this);
            this.offScreenGraphics.drawImage(this.btmRight, 125, this.WinHeight - 38, this);
            this.titleCenter = null;
            this.titleLeft = null;
            this.titleRight = null;
            this.titleStretch = null;
            this.btmLeft = null;
            this.bodyLeft = null;
            this.btmRight = null;
            System.gc();
        }
        this.offScreenGraphics.setFont(new Font("Dialog", 0, 10));
        this.paintList(this.offScreenGraphics);
        this.offScreenGraphics.drawImage(this.bodyRight, this.WinWidth - 20, 20, this);
        this.offScreenGraphics.drawImage(this.bodyRight, this.WinWidth - 20, 48, this);
        this.offScreenGraphics.drawImage(this.bodyRight, this.WinWidth - 20, 50, this);
        if (this.offScreenImage != null) {
            graphics.drawImage(this.offScreenImage, 0, 0, this);
        }
    }

    public void paintList() {
        if (!this.isVisible()) {
            return;
        }
        this.repaint();
    }

    private void paintList(Graphics graphics) {
        graphics.setColor(this.bgcolor);
        graphics.fillRect(this.listarea[0], this.listarea[1], this.listarea[2] - this.listarea[0], this.listarea[3] - this.listarea[1]);
        this.currentSelection = this.playlist.getSelectedIndex();
        int n = this.currentSelection - this.topIndex;
        graphics.setColor(this.normal);
        int n2 = this.playlist.getPlaylistSize();
        int n3 = 0;
        while (n3 < n2) {
            if (n3 >= this.topIndex) {
                int n4 = n3 - this.topIndex;
                if (this.listarea[1] + 12 + n4 * 12 > this.listarea[3]) break;
                PlaylistItem playlistItem = this.playlist.getItemAt(n3);
                String string = playlistItem.getFormattedName();
                if (playlistItem.isSelected()) {
                    graphics.setColor(this.selBg);
                    graphics.fillRect(this.listarea[0] + 4, this.listarea[1] + 12 - 10 + n4 * 12, this.listarea[2] - this.listarea[0] - 4, 14);
                }
                if (n3 == this.currentSelection) {
                    graphics.setColor(this.current);
                } else {
                    graphics.setColor(this.normal);
                }
                if (n3 + 1 >= 10) {
                    graphics.drawString(n3 + 1 + ".  " + string, this.listarea[0] + 12, this.listarea[1] + 12 + n4 * 12);
                } else {
                    graphics.drawString("0" + (n3 + 1) + ".  " + string, this.listarea[0] + 12, this.listarea[1] + 12 + n4 * 12);
                }
                if (n3 == this.currentSelection) {
                    graphics.setColor(this.normal);
                }
            }
            ++n3;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = this.playlist.getPlaylistSize();
        if (string.equals("Scroll")) {
            if (!this.acScrollBar.isMousePressed()) {
                this.FirstBarDrag = true;
            } else {
                int n2 = 0;
                if (!this.FirstBarDrag) {
                    n2 = this.acScrollBar.getMouseY() - this.XBarDrag;
                    this.XBarDrag = this.acScrollBar.getMouseY() - n2;
                    this.scrollBarLocation += n2;
                    if (this.scrollBarLocation < this.scrollBarRange[0]) {
                        this.scrollBarLocation = this.scrollBarRange[0];
                    }
                    if (this.scrollBarLocation > this.scrollBarRange[1]) {
                        this.scrollBarLocation = this.scrollBarRange[1];
                    }
                    this.acScrollBar.setLocation(this.scrollBarX, this.scrollBarLocation);
                    float f = ((float)this.scrollBarLocation - (float)this.scrollBarRange[0]) / (float)(this.scrollBarRange[1] - this.scrollBarRange[0]);
                    int n3 = (int)(f * (float)(n - 1));
                    if (n3 != this.topIndex) {
                        this.topIndex = n3;
                        this.paintList();
                    }
                } else {
                    this.FirstBarDrag = false;
                    this.XBarDrag = this.acScrollBar.getMouseY();
                }
            }
        } else if (string.equals("ScrollUp")) {
            --this.topIndex;
            if (this.topIndex < 0) {
                this.topIndex = 0;
            }
            this.resetScrollBar();
            this.paintList();
        } else if (string.equals("ScrollDown")) {
            ++this.topIndex;
            if (this.topIndex > n - 1) {
                this.topIndex = n - 1;
            }
            this.resetScrollBar();
            this.paintList();
        } else if (string.equals("Add File")) {
            this.addFileWnd.setVisible(false);
            Frame frame = new Frame();
            frame.setLocation(this.getBounds().x, this.getBounds().y + 10);
            FileSelector.setWindow(frame);
            String string2 = FileSelector.selectFile(1, this.config.getExtensions(), this.config.getLastDir());
            string2 = FileSelector.getFile();
            if (string2 != null) {
                this.config.setLastDir(FileSelector.getDirectory());
                if (!string2.endsWith(".wsz") && !string2.endsWith(".m3u")) {
                    PlaylistItem playlistItem = new PlaylistItem(string2, this.config.getLastDir() + string2, -1L, true);
                    this.playlist.appendItem(playlistItem);
                    this.resetScrollBar();
                    this.repaint();
                }
            }
        } else if (string.equals("Add Url")) {
            this.addFileWnd.setVisible(false);
            UrlDialog urlDialog = new UrlDialog("Open location", this.getBounds().x, this.getBounds().y + 10, 280, 120, null);
            urlDialog.show();
            if (urlDialog.getFile() != null) {
                PlaylistItem playlistItem = new PlaylistItem(urlDialog.getFile(), urlDialog.getURL(), -1L, false);
                this.playlist.appendItem(playlistItem);
                this.resetScrollBar();
                this.repaint();
            }
        } else if (string.equals("Add Dir")) {
            this.addFileWnd.setVisible(false);
            Frame frame = new Frame();
            frame.setLocation(this.getBounds().x, this.getBounds().y + 10);
            FileSelector.setWindow(frame);
            String string3 = FileSelector.selectFile(1, "*", this.config.getLastDir());
            string3 = FileSelector.getDirectory();
            if (string3.endsWith(File.separator)) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            try {
                File file = new File(string3);
                if (file == null || !file.isDirectory()) {
                    return;
                }
                this.addDir(file);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else if (string.equals("Del File")) {
            this.subFileWnd.setVisible(false);
            this.delSelectedItems();
        } else if (string.equals("Del All")) {
            this.subFileWnd.setVisible(false);
            this.delAllItems();
        } else if (string.equals("Inv Sel")) {
            this.selFunctions(-1);
        } else if (string.equals("Sel 0")) {
            this.selFunctions(0);
        } else if (string.equals("Sel All")) {
            this.selFunctions(1);
        } else if (string.equals("Remove Item(s)")) {
            this.delSelectedItems();
        } else if (string.equals("Play Item")) {
            int n4 = this.playlist.getPlaylistSize();
            PlaylistItem playlistItem = null;
            int n5 = n4 - 1;
            while (n5 >= 0) {
                playlistItem = this.playlist.getItemAt(n5);
                if (playlistItem.isSelected()) break;
                --n5;
            }
            if (playlistItem != null && playlistItem.getTagInfo() != null) {
                this.player.pressStop();
                this.player.setCurrentSong(playlistItem);
                this.playlist.setCursor(this.playlist.getIndex(playlistItem));
                this.player.pressStart();
            }
        } else if (string.equals("File Info")) {
            TagInfo tagInfo;
            int n6 = this.playlist.getPlaylistSize();
            PlaylistItem playlistItem = null;
            int n7 = n6 - 1;
            while (n7 >= 0) {
                playlistItem = this.playlist.getItemAt(n7);
                if (playlistItem.isSelected()) break;
                --n7;
            }
            if (playlistItem != null && playlistItem.getTagInfo() != null && (tagInfo = playlistItem.getTagInfo()) != null) {
                if (tagInfo instanceof OggVorbisInfo) {
                    OggVorbisDialog oggVorbisDialog = new OggVorbisDialog("OggVorbis info", this.getBounds().x, this.getBounds().y, 470, 340, (OggVorbisInfo)tagInfo);
                    oggVorbisDialog.show();
                } else if (tagInfo instanceof MpegInfo) {
                    MpegDialog mpegDialog = new MpegDialog("Mpeg info", this.getBounds().x, this.getBounds().y, 400, 320, (MpegInfo)tagInfo);
                    mpegDialog.show();
                }
            }
        }
    }

    protected void handleMouseClick(MouseEvent mouseEvent) {
        int n;
        if (this.addFileWnd != null && this.addFileWnd.isVisible()) {
            this.addFileWnd.setVisible(false);
        }
        if (this.subFileWnd != null && this.subFileWnd.isVisible()) {
            this.subFileWnd.setVisible(false);
        }
        if (this.selFileWnd != null && this.selFileWnd.isVisible()) {
            this.selFileWnd.setVisible(false);
        }
        if (this.optFileWnd != null && this.optFileWnd.isVisible()) {
            this.optFileWnd.setVisible(false);
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (n2 >= this.addarea[0] && n2 <= this.addarea[2] && n3 >= this.addarea[1] && n3 <= this.addarea[3]) {
            this.handleAddEvent();
            return;
        }
        if (n2 >= this.addarea[0] + 29 && n2 <= this.addarea[2] + 29 && n3 >= this.addarea[1] && n3 <= this.addarea[3]) {
            this.handleSubEvent();
            return;
        }
        if (n2 >= this.addarea[0] + 58 && n2 <= this.addarea[2] + 58 && n3 >= this.addarea[1] && n3 <= this.addarea[3]) {
            this.handleSelEvent();
            return;
        }
        if (n2 >= this.addarea[0] + 87 && n2 <= this.addarea[2] + 87 && n3 >= this.addarea[1] && n3 <= this.addarea[3]) {
            this.handleOptEvent();
            return;
        }
        if (n2 >= this.listarea[0] && n2 <= this.listarea[2] && n3 >= this.listarea[1] && n3 <= this.listarea[3] && (n = this.getIndex(n3)) != -1) {
            if (mouseEvent.getModifiers() == 4) {
                if (this.fipopup != null) {
                    this.fipopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            } else {
                PlaylistItem playlistItem = this.playlist.getItemAt(n);
                if (playlistItem != null) {
                    playlistItem.setSelected(!playlistItem.isSelected());
                    if (mouseEvent.getClickCount() == 2 && mouseEvent.getModifiers() == 16) {
                        this.player.pressStop();
                        this.player.setCurrentSong(playlistItem);
                        this.playlist.setCursor(n);
                        this.player.pressStart();
                    }
                }
            }
            this.repaint();
        }
    }

    private void handleSelEvent() {
        if (this.selFileWnd == null) {
            this.createSelFileWnd();
        }
        if (this.selFileWnd != null && this.selFileWnd.isVisible()) {
            this.selFileWnd.setVisible(false);
        } else {
            Point point = this.getLocation();
            this.selFileWnd.setLocation(point.x + this.addarea[0] + 58, point.y + (this.addarea[1] - 54) + 20);
            this.selFileWnd.setSize(22, 54);
            this.selFileWnd.setVisible(true);
        }
    }

    private void handleOptEvent() {
        if (this.optFileWnd == null) {
            this.createOptFileWnd();
        }
        if (this.optFileWnd != null && this.optFileWnd.isVisible()) {
            this.optFileWnd.setVisible(false);
        } else {
            Point point = this.getLocation();
            this.optFileWnd.setLocation(point.x + this.addarea[0] + 87, point.y + (this.addarea[1] - 54) + 20);
            this.optFileWnd.setSize(22, 54);
            this.optFileWnd.setVisible(true);
        }
    }

    private void handleSubEvent() {
        if (this.subFileWnd == null) {
            this.createSubFileWnd();
        }
        if (this.subFileWnd != null && this.subFileWnd.isVisible()) {
            this.subFileWnd.setVisible(false);
        } else {
            Point point = this.getLocation();
            this.subFileWnd.setLocation(point.x + this.addarea[0] + 29, point.y + (this.addarea[1] - 72) + 20);
            this.subFileWnd.setSize(22, 72);
            this.subFileWnd.setVisible(true);
        }
    }

    private void handleAddEvent() {
        if (this.addFileWnd == null) {
            this.createAddFileWnd();
        }
        if (this.addFileWnd != null && this.addFileWnd.isVisible()) {
            this.addFileWnd.setVisible(false);
        } else {
            Point point = this.getLocation();
            this.addFileWnd.setLocation(point.x + this.addarea[0], point.y + (this.addarea[1] - 54) + 20);
            this.addFileWnd.setSize(22, 54);
            this.addFileWnd.setVisible(true);
        }
    }

    private void createOptFileWnd() {
        this.optFileWnd = new Window(this);
        this.optFileWnd.setLayout(new GridLayout(3, 1, 0, 0));
        activeComponent activeComponent2 = this.createPLButton(154, 111);
        this.optFileWnd.add(activeComponent2);
        activeComponent2 = this.createPLButton(154, 130);
        this.optFileWnd.add(activeComponent2);
        activeComponent2 = this.createPLButton(154, 149);
        this.optFileWnd.add(activeComponent2);
        this.optFileWnd.setSize(22, 54);
        this.optFileWnd.pack();
        this.optFileWnd.setVisible(false);
    }

    private void createSelFileWnd() {
        this.selFileWnd = new Window(this);
        this.selFileWnd.setLayout(new GridLayout(3, 1, 0, 0));
        activeComponent activeComponent2 = this.createPLButton(104, 111);
        activeComponent2.setActionCommand("Inv Sel");
        activeComponent2.addActionListener(this);
        this.selFileWnd.add(activeComponent2);
        activeComponent2 = this.createPLButton(104, 130);
        activeComponent2.setActionCommand("Sel 0");
        activeComponent2.addActionListener(this);
        this.selFileWnd.add(activeComponent2);
        activeComponent2 = this.createPLButton(104, 149);
        activeComponent2.setActionCommand("Sel All");
        activeComponent2.addActionListener(this);
        this.selFileWnd.add(activeComponent2);
        this.selFileWnd.setSize(22, 54);
        this.selFileWnd.pack();
        this.selFileWnd.setVisible(false);
    }

    private void createSubFileWnd() {
        this.subFileWnd = new Window(this);
        this.subFileWnd.setLayout(new GridLayout(4, 1, 0, 0));
        activeComponent activeComponent2 = this.createPLButton(54, 111);
        activeComponent2.setActionCommand("Del All");
        activeComponent2.addActionListener(this);
        this.subFileWnd.add(activeComponent2);
        activeComponent2 = this.createPLButton(54, 130);
        this.subFileWnd.add(activeComponent2);
        activeComponent2 = this.createPLButton(54, 149);
        activeComponent2.setActionCommand("Del File");
        activeComponent2.addActionListener(this);
        this.subFileWnd.add(activeComponent2);
        activeComponent2 = this.createPLButton(54, 168);
        this.subFileWnd.add(activeComponent2);
        this.subFileWnd.setSize(22, 72);
        this.subFileWnd.pack();
        this.subFileWnd.setVisible(false);
    }

    private void createAddFileWnd() {
        this.addFileWnd = new Window(this);
        this.addFileWnd.setLayout(new GridLayout(3, 1, 0, 0));
        activeComponent activeComponent2 = this.createPLButton(0, 149);
        activeComponent2.setActionCommand("Add File");
        activeComponent2.addActionListener(this);
        activeComponent activeComponent3 = this.createPLButton(0, 130);
        activeComponent3.setActionCommand("Add Dir");
        activeComponent3.addActionListener(this);
        activeComponent activeComponent4 = this.createPLButton(0, 111);
        activeComponent4.setActionCommand("Add Url");
        activeComponent4.addActionListener(this);
        this.addFileWnd.add(activeComponent4);
        this.addFileWnd.add(activeComponent3);
        this.addFileWnd.add(activeComponent2);
        this.addFileWnd.setSize(22, 54);
        this.addFileWnd.pack();
        this.addFileWnd.setVisible(false);
    }

    private activeComponent createPLButton(int n, int n2) {
        Image image = this.createImage(22, 18);
        Image image2 = this.createImage(22, 18);
        Graphics graphics = image.getGraphics();
        graphics.drawImage(this.imWinamp, 0, 0, 22, 18, n, n2, n + 22, n2 + 18, null);
        graphics = image2.getGraphics();
        graphics.drawImage(this.imWinamp, 0, 0, 22, 18, n += 23, n2, n + 22, n2 + 18, null);
        activeComponent activeComponent2 = new activeComponent(image, image2, 16L);
        return activeComponent2;
    }

    private void addDir(File file) {
        String string = this.config.getExtensions();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (this.exts == null) {
            this.exts = new Vector();
            while (stringTokenizer.hasMoreTokens()) {
                this.exts.add("." + stringTokenizer.nextElement());
            }
        }
        AddThread addThread = new AddThread(file);
        addThread.start();
        Thread thread = new Thread("Refresh"){

            public void run() {
                while (MP3Files.this.isSearching) {
                    MP3Files.this.resetScrollBar();
                    MP3Files.this.repaint();
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        thread.start();
    }

    private void addMusicRecursive(File file, int n) {
        if (file == null || n > MAXDEPTH) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            File file2 = new File(file + File.separator + stringArray[n2]);
            if (file2.isDirectory()) {
                this.addMusicRecursive(file2, n + 1);
            } else if (this.isMusicFile(stringArray[n2])) {
                PlaylistItem playlistItem = new PlaylistItem(stringArray[n2], file + File.separator + stringArray[n2], -1L, true);
                this.playlist.appendItem(playlistItem);
            }
            ++n2;
        }
    }

    private boolean isMusicFile(String string) {
        int n = this.exts.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = this.exts.elementAt(n2).toString();
            if (!string2.equals(".wsz") && !string2.equals(".m3u") && string.endsWith(this.exts.elementAt(n2).toString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void selFunctions(int n) {
        this.selFileWnd.setVisible(false);
        int n2 = this.playlist.getPlaylistSize();
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            PlaylistItem playlistItem = this.playlist.getItemAt(n3);
            if (playlistItem == null) break;
            if (n == -1) {
                playlistItem.setSelected(!playlistItem.isSelected());
            } else if (n == 0) {
                playlistItem.setSelected(false);
            } else if (n == 1) {
                playlistItem.setSelected(true);
            }
            ++n3;
        }
        this.repaint();
    }

    private void delAllItems() {
        int n = this.playlist.getPlaylistSize();
        if (n == 0) {
            return;
        }
        this.playlist.removeAllItems();
        this.topIndex = 0;
        this.acScrollBar.setLocation(this.scrollBarX, this.scrollBarRange[0]);
        this.repaint();
    }

    private void delSelectedItems() {
        int n = this.playlist.getPlaylistSize();
        boolean bl = false;
        int n2 = n - 1;
        while (n2 >= 0) {
            if (this.playlist.getItemAt(n2).isSelected()) {
                this.playlist.removeItemAt(n2);
                bl = true;
            }
            --n2;
        }
        if (bl) {
            int n3 = this.playlist.getPlaylistSize();
            if (this.topIndex >= n3) {
                this.topIndex = n3 - 1;
            }
            if (this.topIndex < 0) {
                this.topIndex = 0;
            }
            this.resetScrollBar();
            this.repaint();
        }
    }

    protected int getIndex(int n) {
        int n2 = this.playlist.getPlaylistSize();
        if (n2 == 0) {
            return -1;
        }
        int n3 = 0;
        while (n3 < 100) {
            if (n >= this.listarea[1] + 12 - 10 + n3 * 12 && n < this.listarea[1] + 12 - 10 + n3 * 12 + 14) {
                if (this.topIndex + n3 > n2 - 1) {
                    return -1;
                }
                return this.topIndex + n3;
            }
            ++n3;
        }
        return -1;
    }

    private void resetScrollBar() {
        int n = this.playlist.getPlaylistSize();
        float f = n < 1 ? 0.0f : (float)this.topIndex / (float)(n - 1) * (float)(this.scrollBarRange[1] - this.scrollBarRange[0]);
        this.scrollBarLocation = this.scrollBarRange[0] + (int)f;
        this.acScrollBar.setLocation(this.scrollBarX, this.scrollBarLocation);
    }

    class AddThread
    extends Thread {
        private File fsFile;

        public AddThread(File file) {
            super("Add");
            this.fsFile = file;
        }

        public void run() {
            MP3Files.this.isSearching = true;
            MP3Files.this.addMusicRecursive(this.fsFile, 0);
            MP3Files.this.isSearching = false;
            MP3Files.this.resetScrollBar();
            MP3Files.this.repaint();
        }
    }
}

