/*
 * Decompiled with CFR 0.152.
 */
package javazoom.spi.vorbis.sampled.convert;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;
import javazoom.spi.vorbis.sampled.file.VorbisEncoding;
import org.tritonus.sampled.convert.TAsynchronousFilteredAudioInputStream;
import org.tritonus.sampled.convert.TMatrixFormatConversionProvider;

public class VorbisFormatConversionProvider
extends TMatrixFormatConversionProvider {
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(VorbisEncoding.VORBISENC, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(VorbisEncoding.VORBISENC, 12000.0f, -1, 2, -1, -1.0f, false)};
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(8000.0f, 16, 1, true, false), new AudioFormat(8000.0f, 16, 1, true, true), new AudioFormat(8000.0f, 16, 2, true, false), new AudioFormat(8000.0f, 16, 2, true, true), new AudioFormat(11025.0f, 16, 1, true, false), new AudioFormat(11025.0f, 16, 1, true, true), new AudioFormat(11025.0f, 16, 2, true, false), new AudioFormat(11025.0f, 16, 2, true, true), new AudioFormat(12000.0f, 16, 1, true, false), new AudioFormat(12000.0f, 16, 1, true, true), new AudioFormat(12000.0f, 16, 2, true, false), new AudioFormat(12000.0f, 16, 2, true, true), new AudioFormat(16000.0f, 16, 1, true, false), new AudioFormat(16000.0f, 16, 1, true, true), new AudioFormat(16000.0f, 16, 2, true, false), new AudioFormat(16000.0f, 16, 2, true, true), new AudioFormat(22050.0f, 16, 1, true, false), new AudioFormat(22050.0f, 16, 1, true, true), new AudioFormat(22050.0f, 16, 2, true, false), new AudioFormat(22050.0f, 16, 2, true, true), new AudioFormat(24000.0f, 16, 1, true, false), new AudioFormat(24000.0f, 16, 1, true, true), new AudioFormat(24000.0f, 16, 2, true, false), new AudioFormat(24000.0f, 16, 2, true, true), new AudioFormat(32000.0f, 16, 1, true, false), new AudioFormat(32000.0f, 16, 1, true, true), new AudioFormat(32000.0f, 16, 2, true, false), new AudioFormat(32000.0f, 16, 2, true, true), new AudioFormat(44100.0f, 16, 1, true, false), new AudioFormat(44100.0f, 16, 1, true, true), new AudioFormat(44100.0f, 16, 2, true, false), new AudioFormat(44100.0f, 16, 2, true, true), new AudioFormat(48000.0f, 16, 1, true, false), new AudioFormat(48000.0f, 16, 1, true, true), new AudioFormat(48000.0f, 16, 2, true, false), new AudioFormat(48000.0f, 16, 2, true, true)};
    private static final boolean t = true;
    private static final boolean f = false;
    private static final boolean[][] CONVERSIONS = new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};

    public VorbisFormatConversionProvider() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS), CONVERSIONS);
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        if (((FormatConversionProvider)((Object)this)).isConversionSupported(audioFormat, audioInputStream.getFormat())) {
            return new DecodedVorbisAudioInputStream(audioFormat, audioInputStream);
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    public static class DecodedVorbisAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        public static boolean DEBUG = false;
        private InputStream oggBitStream_ = null;
        private SyncState oggSyncState_ = null;
        private StreamState oggStreamState_ = null;
        private Page oggPage_ = null;
        private Packet oggPacket_ = null;
        private Info vorbisInfo = null;
        private Comment vorbisComment = null;
        private DspState vorbisDspState = null;
        private Block vorbisBlock = null;
        private int bufferMultiple_ = 4;
        private int bufferSize_ = this.bufferMultiple_ * 256 * 2;
        private int convsize = this.bufferSize_ * 2;
        private byte[] convbuffer = new byte[this.convsize];
        private byte[] buffer = null;
        private int bytes = 0;
        private int rate = 0;
        private int channels = 0;
        private Vector songComments_ = new Vector();
        private double[][][] _pcm = null;
        private float[][][] _pcmf = null;
        private int[] _index = null;
        private int index = 0;
        private int i = 0;
        private int loopid = 1;
        private int eos = 0;
        private boolean streamStillHasData = true;

        public DecodedVorbisAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
            super(audioInputStream, audioFormat, -1L);
            this.oggBitStream_ = audioInputStream;
            this.loopid = 1;
            this.init_jorbis();
            this.index = 0;
        }

        private void init_jorbis() {
            this.oggSyncState_ = new SyncState();
            this.oggStreamState_ = new StreamState();
            this.oggPage_ = new Page();
            this.oggPacket_ = new Packet();
            this.vorbisInfo = new Info();
            this.vorbisComment = new Comment();
            this.vorbisDspState = new DspState();
            this.vorbisBlock = new Block(this.vorbisDspState);
            this.buffer = null;
            this.bytes = 0;
            this.oggSyncState_.init();
        }

        public void execute() {
            block40: {
                if (this.streamStillHasData) {
                    if (this.loopid == 1) {
                        if (DEBUG) {
                            System.err.println("loop1");
                        }
                        this.eos = 0;
                        try {
                            this.readHeaders();
                        }
                        catch (IOException iOException) {
                            this.streamStillHasData = false;
                            return;
                        }
                        this.loopid = 2;
                    }
                    switch (this.eos) {
                        case 0: {
                            if (DEBUG) {
                                System.err.println("loop2");
                            }
                            switch (this.eos) {
                                case 0: {
                                    int n = this.oggSyncState_.pageout(this.oggPage_);
                                    if (DEBUG) {
                                        System.err.println("loop3:" + n);
                                    }
                                    if (n == 0) {
                                        this.loopid = 2;
                                        break;
                                    }
                                    if (n == -1) {
                                        if (DEBUG) {
                                            System.err.println("Corrupt or missing data in bitstream; continuing...");
                                        }
                                    } else {
                                        this.oggStreamState_.pagein(this.oggPage_);
                                        if (DEBUG) {
                                            System.err.println("Decoding");
                                        }
                                        while ((n = this.oggStreamState_.packetout(this.oggPacket_)) != 0) {
                                            int n2;
                                            if (n == -1) continue;
                                            if (this.vorbisBlock.synthesis(this.oggPacket_) == 0) {
                                                this.vorbisDspState.synthesis_blockin(this.vorbisBlock);
                                            }
                                            while ((n2 = this.vorbisDspState.synthesis_pcmout(this._pcmf, this._index)) > 0) {
                                                double[][] dArray = this._pcm[0];
                                                float[][] fArray = this._pcmf[0];
                                                boolean bl = false;
                                                int n3 = n2 < this.convsize ? n2 : this.convsize;
                                                double d = 0.0;
                                                this.i = 0;
                                                while (this.i < this.vorbisInfo.channels) {
                                                    int n4 = this.i * 2;
                                                    int n5 = this._index[this.i];
                                                    int n6 = 0;
                                                    while (n6 < n3) {
                                                        d = (double)fArray[this.i][n5 + n6] * 32767.0;
                                                        int n7 = (int)d;
                                                        if (n7 > Short.MAX_VALUE) {
                                                            n7 = Short.MAX_VALUE;
                                                            bl = true;
                                                        }
                                                        if (n7 < Short.MIN_VALUE) {
                                                            n7 = Short.MIN_VALUE;
                                                            bl = true;
                                                        }
                                                        if (n7 < 0) {
                                                            n7 |= 0x8000;
                                                        }
                                                        this.convbuffer[n4] = (byte)n7;
                                                        this.convbuffer[n4 + 1] = (byte)(n7 >>> 8);
                                                        n4 += 2 * this.vorbisInfo.channels;
                                                        ++n6;
                                                    }
                                                    ++this.i;
                                                }
                                                this.m_circularBuffer.write(this.convbuffer, 0, 2 * this.vorbisInfo.channels * n3);
                                                this.vorbisDspState.synthesis_read(n3);
                                            }
                                        }
                                        if (this.oggPage_.eos() != 0) {
                                            this.eos = 1;
                                        }
                                    }
                                    this.loopid = 3;
                                    break;
                                }
                                default: {
                                    this.loopid = 2;
                                }
                            }
                            if (this.loopid == 3) {
                                return;
                            }
                            if (this.eos == 0) {
                                this.index = this.oggSyncState_.buffer(this.bufferSize_);
                                this.buffer = this.oggSyncState_.data;
                                this.bytes = this.readFromStream(this.buffer, this.index, this.bufferSize_);
                                if (DEBUG) {
                                    System.err.println("More data : " + this.bytes);
                                }
                                if (this.bytes == -1) {
                                    if (DEBUG) {
                                        System.err.println("Ogg Stream empty.");
                                    }
                                    this.streamStillHasData = false;
                                    this.eos = 1;
                                } else {
                                    this.oggSyncState_.wrote(this.bytes);
                                    if (this.bytes == 0) {
                                        this.eos = 1;
                                    }
                                }
                            }
                            this.loopid = 2;
                            break;
                        }
                        default: {
                            this.loopid = 1;
                        }
                    }
                    if (this.loopid == 2) {
                        return;
                    }
                    this.oggStreamState_.clear();
                    this.vorbisBlock.clear();
                    this.vorbisDspState.clear();
                    this.vorbisInfo.clear();
                } else {
                    this.oggSyncState_.clear();
                    if (DEBUG) {
                        System.out.println("Done Song.");
                    }
                    try {
                        if (this.oggBitStream_ != null) {
                            this.oggBitStream_.close();
                        }
                        this.m_circularBuffer.close();
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block40;
                        exception.printStackTrace();
                    }
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void readHeaders() throws IOException {
            block29: {
                block28: {
                    if (DecodedVorbisAudioInputStream.DEBUG) {
                        System.err.println("readHeaders()");
                    }
                    this.index = this.oggSyncState_.buffer(this.bufferSize_);
                    this.buffer = this.oggSyncState_.data;
                    this.bytes = this.readFromStream(this.buffer, this.index, this.bufferSize_);
                    if (this.bytes == -1) {
                        if (DecodedVorbisAudioInputStream.DEBUG) {
                            System.err.println("Cannot get any data from selected Ogg bitstream.");
                        }
                        throw new IOException("Cannot get any data from selected Ogg bitstream.");
                    }
                    this.oggSyncState_.wrote(this.bytes);
                    if (this.oggSyncState_.pageout(this.oggPage_) != 1) {
                        if (this.bytes < this.bufferSize_) {
                            throw new IOException("EOF");
                        }
                        if (DecodedVorbisAudioInputStream.DEBUG) {
                            System.err.println("Input does not appear to be an Ogg bitstream.");
                        }
                        throw new IOException("Input does not appear to be an Ogg bitstream.");
                    }
                    this.oggStreamState_.init(this.oggPage_.serialno());
                    this.vorbisInfo.init();
                    this.vorbisComment.init();
                    if (this.oggStreamState_.pagein(this.oggPage_) < 0) {
                        if (DecodedVorbisAudioInputStream.DEBUG) {
                            System.err.println("Error reading first page of Ogg bitstream data.");
                        }
                        throw new IOException("Error reading first page of Ogg bitstream data.");
                    }
                    if (this.oggStreamState_.packetout(this.oggPacket_) != 1) {
                        if (DecodedVorbisAudioInputStream.DEBUG) {
                            System.err.println("Error reading initial header packet.");
                        }
                        throw new IOException("Error reading initial header packet.");
                    }
                    if (this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket_) < 0) {
                        if (DecodedVorbisAudioInputStream.DEBUG) {
                            System.err.println("This Ogg bitstream does not contain Vorbis audio data.");
                        }
                        throw new IOException("This Ogg bitstream does not contain Vorbis audio data.");
                    }
                    this.i = 0;
                    break block28;
                    while ((var1_1 = this.oggSyncState_.pageout(this.oggPage_)) != 0) {
                        if (var1_1 == 1) {
                            this.oggStreamState_.pagein(this.oggPage_);
                            while (this.i < 2) {
                                var1_1 = this.oggStreamState_.packetout(this.oggPacket_);
                                if (var1_1 == 0) break;
                                if (var1_1 == -1) {
                                    if (DecodedVorbisAudioInputStream.DEBUG) {
                                        System.err.println("Corrupt secondary header.  Exiting.");
                                    }
                                    throw new IOException("Corrupt secondary header.  Exiting.");
                                }
                                this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket_);
                                ++this.i;
                            }
                        }
lbl50:
                        // 5 sources

                        ** while (this.i >= 2)
lbl51:
                        // 1 sources

                    }
lbl52:
                    // 2 sources

                    this.index = this.oggSyncState_.buffer(this.bufferSize_);
                    this.buffer = this.oggSyncState_.data;
                    this.bytes = this.readFromStream(this.buffer, this.index, this.bufferSize_);
                    if (this.bytes == -1) break block29;
                    if (this.bytes == 0 && this.i < 2) {
                        if (DecodedVorbisAudioInputStream.DEBUG) {
                            System.err.println("End of file before finding all Vorbis  headers!");
                        }
                        throw new IOException("End of file before finding all Vorbis  headers!");
                    }
                    this.oggSyncState_.wrote(this.bytes);
                }
                if (this.i < 2) ** GOTO lbl50
            }
            var1_2 = this.vorbisComment.user_comments;
            var2_3 = "";
            this.songComments_.clear();
            var3_4 = 0;
            while (var3_4 < var1_2.length) {
                if (var1_2[var3_4] == null) break;
                var2_3 = new String(var1_2[var3_4], 0, var1_2[var3_4].length - 1).trim();
                this.songComments_.add(var2_3);
                if (var2_3.toUpperCase().startsWith("ARTIST")) {
                    var4_5 = var2_3.substring(7);
                } else if (var2_3.toUpperCase().startsWith("TITLE")) {
                    var4_5 = var2_3.substring(6);
                    var5_6 = var2_3.substring(6);
                }
                if (DecodedVorbisAudioInputStream.DEBUG) {
                    System.err.println("Comment: " + var2_3);
                }
                ++var3_4;
            }
            var2_3 = "Bitstream: " + this.vorbisInfo.channels + " channel," + this.vorbisInfo.rate + "Hz";
            this.songComments_.add(var2_3);
            if (DecodedVorbisAudioInputStream.DEBUG) {
                System.err.println(var2_3);
            }
            if (DecodedVorbisAudioInputStream.DEBUG) {
                var2_3 = "Encoded by: " + new String(this.vorbisComment.vendor, 0, this.vorbisComment.vendor.length - 1);
            }
            this.songComments_.add(var2_3);
            if (DecodedVorbisAudioInputStream.DEBUG) {
                System.err.println(var2_3);
            }
            this.convsize = this.bufferSize_ / this.vorbisInfo.channels;
            this.vorbisDspState.synthesis_init(this.vorbisInfo);
            this.vorbisBlock.init(this.vorbisDspState);
            this._pcm = new double[1][][];
            this._pcmf = new float[1][][];
            this._index = new int[this.vorbisInfo.channels];
        }

        private int readFromStream(byte[] byArray, int n, int n2) {
            int n3 = 0;
            try {
                n3 = this.oggBitStream_.read(byArray, n, n2);
            }
            catch (Exception exception) {
                if (DEBUG) {
                    System.out.println("Cannot Read Selected Song");
                }
                n3 = -1;
            }
            return n3;
        }

        private boolean isBigEndian() {
            return ((AudioInputStream)((Object)this)).getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.oggBitStream_.close();
        }
    }
}

