#ifndef ICON.H

#define ICON.H

#include "stddefs.h"
#include "yaklib.h"

class icon
{
public:
  enum flagType {normal = 0, fast = 1};
  int width, height;
  flagType flags;
  char * unrolledPic;
  icon() {width = height = byteWidth = 0; flags = normal; unrolledPic = NULL; collisionMap = NULL;};
  ~icon() {delete unrolledPic; delete collisionMap;};
  inline byte getPixel(int x, int y);
  void save(char * filename);
  char * useData(unsigned char * myPointer, flagType iflags = normal);
  char * load(char * filename, flagType iflags = normal, yakLib * myYakLib = NULL);
  inline void show(int x, int y, word offset);
  inline void hide(int x, int y, word to_offset, word from_offset);
  inline void showMasked(int x, int y, word offset);

//collision system code parts inserted here.  All icons will have collision
//maps.

  byte * collisionMap; //contains collision points
  int byteWidth; //width in bytes.
  int setWPacked(int, int); //allocates space for array
  int setCollisionBit(int ix, int iy, booleanFlags flag = on);
  int getCollisionBit(int ix, int iy);
  void spewCollisionTable(void);
  int makeCollisionMap(void);
  int hitXY(int myX, int myY, icon* target, int targetX, int targetY);
// icon zooming code parts inserted here.  Only one zoomtable will exist for
// all icons.

  static byte ** zoomTable;
  static int zoomTableWidth;
  static byte ** setZoomTable(int newWidth);
  static void spewZoomTable(void);
  icon * zoomedIcon(int newWidth);
  void showZoomed(int x, int y, word offset, int newWidth);
};

char * unRollBlt(char * rolledBlt, int &iwidth, int &iheight);
char * rollBlt(char * unRolledBlt, int &iwidth, int &iheight);

#endif