/* This is file gr.h */

typedef enum GR_graphics_modes {
  GR_80_25_text,
  GR_default_text,
  GR_width_height_text,
  GR_biggest_text,
  GR_320_200_graphics,
  GR_default_graphics,
  GR_width_height_graphics,
  GR_biggest_noninterlaced_graphics,
  GR_biggest_graphics
} GR_graphics_modes;

extern void far movw (); /*int length, int fbase, int from, int tbase, int to*/
extern void far GrSetWriteMode (int mode);
extern void far	GrSetActive (long base);
extern void far	GrSetVisual (long base);
extern void far	GrVsync (void);
extern int far	GrSetMode (enum GR_graphics_modes mode, int w, int h);
extern int far	GrSetBiosMode (int mode);
extern void far	GrSetColor (int color, int r, int g, int b);
extern int far	GrAllocColor (int r, int g, int b); /* shared, read-only */
extern int far	GrAllocCell (void); /* unshared, read-write */
extern void far	GrQueryColor (int n, int *r, int *g, int *b);
extern void far	GrFreeColor (int c);
extern int far	GrWhite (void);
extern int far	GrBlack (void);

/* or a color with GrXOR to "xor" the color onto the screen */
#define GrXOR		0x100
#define GrOR		0x200
/* GrNOCOLOR is used for "no" color */
#define GrNOCOLOR	0x400

extern void far	GrPlot (int x, int y, int c);
extern int far	GrPixel (int x, int y);

extern void far	GrSetXY (int x, int y);
extern int far	GrMaxX (void);
extern int far	GrMaxY (void);
extern int far	GrSizeX (void);
extern int far	GrSizeY (void);

extern void far GrFontSet (char *text);

extern void far GrText (char *text);
extern void far GrTextPut (int c);
extern void far	GrTextChar (int c);
extern void far GrTextF (char *text);
extern void far	GrTextXY (int x, int y, char *text, int fg, int bg);
extern void far	GrTextSet (int x, int y, int fg, int bg, int max, int my);
extern void far	GrTextColor (int fg, int bg);
extern void far	GrTextWin (int xl, int xh, int yl, int yh, int border, int bg);
extern void far	GrTextGet (int *x, int *y, int *fg, int *bg, int *max, int *my);
extern int far	GrTextPush (void);
extern int far	GrTextPop (void);
extern int far	GrTextRow (int row);
extern int far	GrTextCol (int col);
extern void far	GrTextGoto (int row, int col);
extern void far	GrTextClear (void);
extern void far	GrCursorSet (unsigned char far *c, int s, int e);
extern void far	GrCursorGet (unsigned char *far *c, int *mode);
extern int far	GrCursorMode (int mode);
extern void far	GrCursorInsMode (int mode);
extern void far	GrScrollOn (void);
extern void far	GrScrollOff (void);
extern void far	GrScroll (int n);
extern int far	gprintf (const char *fmt, ...);

extern void far	GrCopy (int xf, int yf, int xt, int yt, int w, int h);
extern void far	GrClear (int x, int y, int w, int h, unsigned int c);
extern void far	GrMove (int xf, int yf, int xt, int yt, int w, int h, unsigned int c);

extern void far	GrMemGet (unsigned char *p, int xf, int yf, int w, int h);
extern void far	GrMemPut (int xt, int yt, int w, int h, unsigned char *p);

extern void far	GrLine (int x1, int y1, int x2, int y2, unsigned int c);
extern void far	GrMoveTo (int x1, int y1);
extern void far	GrDrawTo (int x2, int y2, unsigned int c);
extern void far	GrEllipse (int x, int y, int irx, int iry, unsigned int c);

#define VGA_PAGE	((unsigned char far *)0xa0000000L)
#define VGA_PAGE_END	((unsigned char far *)0xb0000000L)
#define VGA_PAGE_SIZE	0x10000L

extern long ActiveBase;

