/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.usbdm.connections.usbdm;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class Usbdm {
    private static boolean libraryLoaded = false;
    private static boolean libraryLoadFailed = false;
    private static final int BDM_RC_OK = 0;

    private static native int init();

    private static native int exit();

    private static native int findDevices(int[] var0);

    private static native int releaseDevices();

    private static native int openBDM(int var0);

    private static native int closeBDM();

    private static native int getBDMDescription(byte[] var0);

    private static native int getBDMSerialNumber(byte[] var0);

    private static native int getBDMFirmwareVersion(BdmInformation var0);

    private static native String getErrorString(int var0);

    private static boolean loadLibrary(Shell parent) {
        if (libraryLoaded) {
            return true;
        }
        try {
            String os = System.getProperty("os.name");
            if (os != null && os.toUpperCase().contains("LINUX")) {
                System.loadLibrary("usb-1.0");
                System.loadLibrary("usbdm.4");
            } else {
                System.loadLibrary("libusb-1.0");
                System.loadLibrary("usbdm.4");
            }
            System.loadLibrary("UsbdmJniWrapper");
            Usbdm.init();
            libraryLoaded = true;
        }
        catch (Throwable e) {
            if (!libraryLoadFailed) {
                libraryLoadFailed = true;
                MessageBox msgbox = new MessageBox(parent, 32);
                msgbox.setText("USBDM Error");
                msgbox.setMessage("Loading of USBDM native library failed.");
                msgbox.open();
                e.printStackTrace();
            }
            System.err.println("USBDM Libraries failed to load");
            return false;
        }
        return true;
    }

    public static ArrayList<DeviceInfo> getDeviceList(Shell parent) {
        ArrayList<DeviceInfo> deviceList = new ArrayList<DeviceInfo>();
        if (!Usbdm.loadLibrary(parent)) {
            return deviceList;
        }
        int[] deviceCount = new int[1];
        byte[] description = new byte[200];
        byte[] serialNum = new byte[200];
        Charset utf8Charset = Charset.forName("UTF-16LE");
        CharsetDecoder utf8CharsetDecoder = utf8Charset.newDecoder();
        BdmInformation bdmInfo = new BdmInformation();
        int rc = Usbdm.findDevices(deviceCount);
        if (rc != 0) {
            System.err.println("Usbdm.findDevices() - failed, Reason: " + Usbdm.getErrorString(rc));
            return deviceList;
        }
        int deviceNum = 0;
        while (deviceNum < deviceCount[0]) {
            ByteBuffer buff;
            String desc = new String("Unresponsive device");
            String serial = new String("Unknown");
            rc = Usbdm.openBDM(deviceNum);
            if (rc == 0) {
                rc = Usbdm.getBDMDescription(description);
            }
            try {
                if (rc == 0) {
                    buff = ByteBuffer.allocate(description[0]);
                    buff.put(description, 1, description[0]);
                    buff.rewind();
                    desc = utf8CharsetDecoder.decode(buff).toString();
                }
            }
            catch (CharacterCodingException e) {
                e.printStackTrace();
            }
            if (rc == 0) {
                rc = Usbdm.getBDMSerialNumber(serialNum);
            }
            try {
                if (rc == 0) {
                    buff = ByteBuffer.allocate(serialNum[0]);
                    buff.put(serialNum, 1, serialNum[0]);
                    buff.rewind();
                    serial = utf8CharsetDecoder.decode(buff).toString();
                }
            }
            catch (CharacterCodingException e) {
                e.printStackTrace();
            }
            if (rc == 0) {
                rc = Usbdm.getBDMFirmwareVersion(bdmInfo);
            }
            if (rc != 0) {
                bdmInfo = new BdmInformation();
            }
            DeviceInfo deviceInfo = new DeviceInfo(desc, serial, bdmInfo);
            deviceList.add(deviceInfo);
            Usbdm.closeBDM();
            ++deviceNum;
        }
        Usbdm.releaseDevices();
        return deviceList;
    }

    public void finalize() {
        Usbdm.exit();
        libraryLoaded = false;
        libraryLoadFailed = false;
    }

    public static class BdmInformation {
        public int BDMsoftwareVersion;
        public int BDMhardwareVersion;
        public int ICPsoftwareVersion;
        public int ICPhardwareVersion;
        public int capabilities;
        public int commandBufferSize;
        public int jtagBufferSize;

        public BdmInformation() {
        }

        public BdmInformation(int bdmSV, int bdmHV, int icpSV, int icpHV, int cap, int comm, int jtag) {
            this.BDMsoftwareVersion = bdmSV;
            this.BDMhardwareVersion = bdmHV;
            this.ICPsoftwareVersion = icpSV;
            this.ICPhardwareVersion = icpHV;
            this.capabilities = cap;
            this.commandBufferSize = comm;
            this.jtagBufferSize = jtag;
        }

        public String toString() {
            return String.valueOf(String.format("(bdmSWVer=%02X,", this.BDMsoftwareVersion)) + String.format(" bdmHWVer=%02X,", this.BDMhardwareVersion) + String.format(" icpSWVer=%02X,", this.ICPsoftwareVersion) + String.format(" icpHWVer=%02X,", this.ICPhardwareVersion) + String.format(" cap=0x%04X,", this.capabilities) + String.format(" cBSize=%d,", this.commandBufferSize) + String.format(" jBSize=%d)", this.jtagBufferSize);
        }
    }

    public static class DeviceInfo {
        public String deviceDescription;
        public String deviceSerialNumber;
        public BdmInformation bdmInfo;

        public DeviceInfo(String desc, String ser, BdmInformation bdmI) {
            this.deviceDescription = desc;
            this.deviceSerialNumber = ser;
            this.bdmInfo = bdmI;
        }

        public String toString() {
            return "Desc=" + this.deviceDescription + "; Ser=" + this.deviceSerialNumber + "; info:" + this.bdmInfo.toString();
        }
    }
}

