/**
 ** VDRMAIN.C ---- the public entry points of the VDR format graphics driver
 **
 ** Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
 ** Copyright (C) 1992 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** Copyright (C) 1993 Grzegorz Mazur, gbm@ii.pw.edu.pl
 **
 ** This file is distributed under the terms listed in the document
 ** "copying.dj", available from DJ Delorie at the address above.
 ** A copy of "copying.dj" should accompany this file; if not, a copy
 ** should be available from where this file was obtained.  This file
 ** may not be distributed without a verbatim copy of "copying.dj".
 **
 ** This file is distributed WITHOUT ANY WARRANTY; without even the implied
 ** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **/

#ifndef LARGEST_TEXT_WDT
#define LARGEST_TEXT_WDT	132
#define LARGEST_TEXT_HGT	60
#endif

#ifndef LARGEST_NI_GRAPHICS_WDT
#define LARGEST_NI_GRAPHICS_WDT 800
#define LARGEST_NI_GRAPHICS_HGT 600
#endif

#ifndef LARGEST_GRAPHICS_WDT
#define LARGEST_GRAPHICS_WDT	1600
#define LARGEST_GRAPHICS_HGT	1200
#endif

#define SETUP_DS() do {				\
    asm push  ds;				\
    if(&driver_header == 0) {			\
	/* do it only in drivers !! */		\
	asm push  cs;				\
	asm pop	  ds;				\
    }						\
} while(0)

#define RESET_DS() do {				\
    asm pop   ds;				\
} while(0);

char virtual_enabled = 0;
int  virtual_xrange = 0;
int  virtual_yrange = 0;
int  current_start_row = 0;
int  current_start_col = 0;
int  virtual_wdt = 0;
int  virtual_hgt = 0;

int far driver_init_routine(void)
{
	int result;

	SETUP_DS();
	result = do_driver_init();
	RESET_DS();
	return(result);
}

void far mode_set_routine(void)
{
	GrModeEntry *tbl,*mdp,*ok;
	unsigned int mode = _AX;
	unsigned int numc = _BX;
	unsigned int wdt  = _CX;
	unsigned int hgt  = _DX;
	int flags,noclear;

	SETUP_DS();
	noclear = mode & 0x80;
	if((mode &= 0x7f) <= 3) {
	    tbl  = text_mode_table;
	    numc = 16;
	    switch(mode) {
	      case 0:		/* 80x25 text */
		wdt = 80;
		hgt = 25;
		break;
	      case 1:		/* default text */
		wdt = HDR->def_tw;
		hgt = HDR->def_th;
		break;
	      case 3:		/* largest text */
		wdt = LARGEST_TEXT_WDT;
		hgt = LARGEST_TEXT_HGT;
		break;
	    }
	}
	else {
	    tbl = graphics_mode_table;
	    if(mode < 9) numc = HDR->def_numcolor;
	    switch(mode) {
	      case 4:		/* 320x200 graphics */
		wdt = 320;
		hgt = 200;
		break;
	      case 5:		/* default graphics */
		wdt = HDR->def_gw;
		hgt = HDR->def_gh;
		break;
	      case 7:		/* largest non-int graphics */
		wdt = LARGEST_NI_GRAPHICS_WDT;
		hgt = LARGEST_NI_GRAPHICS_HGT;
		break;
	      case 8:		/* largest (possibly interlaced) graphics */
		wdt = LARGEST_GRAPHICS_WDT;
		hgt = LARGEST_GRAPHICS_HGT;
		break;
	    }
	}
	for( ; ; ) {
	    /*
	     * find a suitable mode
	     */
	    for(mdp = tbl,ok = 0; mdp->width > 0; mdp++) {
		if((ok) &&
		   (ok->number_of_colors >= numc) &&
		   (mdp->number_of_colors > ok->number_of_colors)) {
			/* already found one w/ enough colors */
			/* and this entry has more colors */
			mdp = ok;
			break;
		}
		if(mdp->mode.vdr.BIOS_mode != UNSUP) {
		    if((mdp->width >= wdt) &&
		       (mdp->height >= hgt) &&
		       (mdp->number_of_colors >= numc)) {
			    /* found one big enough */
			    break;
		    }
		    ok = mdp;
		}
	    }
	    if(mdp->width == 0) {
		mdp = ok;
		if(!mdp) { flags = (-1); break; }
	    }
	    /*
	     * set up default parameters
	     * chip specific code can overwrite them if needed
	     */
	    HDR->line_offset = 0;			/* GRX figures it */
	    HDR->page_size_shift = 4;
	    HDR->page_gran_shift = 0;
	    HDR->wr_page_start = 0xa000;
	    HDR->rd_page_start = (HDR->driver_flags & GRD_RW_64K) ? 0xa000 : 0xffff;
	    HDR->r_mask = HDR->r_offs = 0;
	    HDR->g_mask = HDR->g_offs = 0;
	    HDR->b_mask = HDR->b_offs = 0;
	    HDR->f_mask = HDR->f_offs = 0;
	    /*
	     * initialize virtual parameters to their
	     * default values
	     */
	    virtual_enabled = 0;
	    virtual_wdt = wdt;
	    virtual_hgt = hgt;
	    if(mode == 10) {
		if(HDR->virt_x_res > wdt) virtual_wdt = HDR->virt_x_res;
		if(HDR->virt_y_res > hgt) virtual_hgt = HDR->virt_y_res;
	    }
	    flags = do_mode_set(mdp,noclear,
		&virtual_wdt,&virtual_hgt,
		&virtual_enabled
	    );
	    if(flags != (-1)) break;
	    /* invalidate this mode and try again ! */
	    mdp->mode.vdr.BIOS_mode = UNSUP;
	}
	wdt = mdp->width;
	hgt = mdp->height;
	if(virtual_enabled) {
	    virtual_xrange = virtual_wdt - wdt;
	    virtual_yrange = virtual_hgt - hgt;
	    if((signed int)(virtual_xrange | virtual_yrange) > 0) {
		current_start_row = 0;
		current_start_col = 0;
	    }
	    else virtual_enabled = 0;
	}
	HDR->virt_x_res = virtual_enabled ? virtual_wdt : wdt;
	HDR->virt_y_res = virtual_enabled ? virtual_hgt : hgt;
	_BX = flags;
	_CX = wdt;
	_DX = hgt;
	RESET_DS();
}

void far set_screen_start(void)
{
	int col = _CX;
	int row = _DX;
	SETUP_DS();
	if(virtual_enabled) {
	    if(col < 0) col = 0;
	    if(row < 0) row = 0;
	    if(col > virtual_xrange) col = virtual_xrange;
	    if(row > virtual_yrange) row = virtual_yrange;
	    if((col != current_start_col) || (row != current_start_row)) {
		current_start_col = col;
		current_start_row = row;
		do_screen_start_set(&current_start_col,&current_start_row);
	    }
	}
	RESET_DS();
}

