{****************************************************************************}
{                                                                            }
{ MODULE:         DevSbDac                                                   }
{                                                                            }
{ DESCRIPTION:    Device driver for the joined <Sound Blaster & DAC> stereo. }
{                 It uses timer polling.                                     }
{                                                                            }
{ AUTHOR:         Juan Carlos Arvalo                                        }
{                                                                            }
{ MODIFICATIONS:  Nobody (yet ;-)                                            }
{                                                                            }
{ HISTORY:        11-Nov-1992 Description                                    }
{                                                                            }
{ (C) 1992 VangeliSTeam                                                      }
{____________________________________________________________________________}

UNIT DevSbDAC;

INTERFACE



CONST                              { Device ID Strings. }
  SbDACDevID      = 'DAC-SB';
  MixSbDACDevID   = 'Mix-DAC-SB';
  Mix2SbDACDevID  = 'Mix2-DAC-SB';




IMPLEMENTATION

USES SoundDevices, StrConst,
     DevSB, DevDAC,          { This driver gets most from those. }
     SoundBlaster;




{$L DEVSBDAC} { Assembler IRQs. }

PROCEDURE SbDACIntHandler;     FAR; EXTERNAL;
PROCEDURE MixSbDACIntHandler;  FAR; EXTERNAL;
PROCEDURE Mix2SbDACIntHandler; FAR; EXTERNAL;




{----------------------------------------------------------------------------}
{ Name functions.                                                            }
{____________________________________________________________________________}

FUNCTION SBDacName : TDevName; FAR;
  BEGIN
    SBDacName     := GetString(StrDevSBDacName);
  END;

FUNCTION MixSBDacName : TDevName; FAR;
  BEGIN
    MixSBDacName  := GetString(StrDevMixSBDacName);
  END;

FUNCTION Mix2SBDacName : TDevName; FAR;
  BEGIN
    Mix2SBDacName := GetString(StrDevMix2SBDacName);
  END;




{----------------------------------------------------------------------------}
{ Autodetect function. Redirected to SB.                                     }
{____________________________________________________________________________}

FUNCTION SbDACDetect : BOOLEAN; FAR;
  BEGIN
    SbDACDetect := SbRegDetect;
  END;




{----------------------------------------------------------------------------}
{ Device Initialisation routine.                                             }
{____________________________________________________________________________}

PROCEDURE DevInit(Hz: WORD); FAR;
  BEGIN
    SbInit(Hz);  { Initialize the Sound Blaster. }
  END;




{----------------------------------------------------------------------------}
{ Device deinitialisation routine.                                           }
{____________________________________________________________________________}

PROCEDURE DevEnd; FAR;
  BEGIN
    SbEnd;   { Deinitialize the Sound Blaster. }
  END;




{----------------------------------------------------------------------------}
{ Accesory routines.                                                         }
{____________________________________________________________________________}

PROCEDURE DevChgHz(Hz: WORD); FAR;
  BEGIN
    CalcTimerData(Hz);
    InitTimer;
  END;

PROCEDURE DevPoll; FAR;
  BEGIN
  END;




{----------------------------------------------------------------------------}
{ Device records.                                                            }
{____________________________________________________________________________}

CONST
  SbDACData : TSoundDevice = (
    DevID      : SbDACDevID;
    DMA        : FALSE
  );

CONST
  MixSbDACData : TSoundDevice = (
    DevID      : MixSbDACDevID;
    DMA        : FALSE
  );

CONST
  Mix2SbDACData : TSoundDevice = (
    DevID      : Mix2SbDACDevID;
    DMA        : FALSE
  );




{----------------------------------------------------------------------------}
{ Init code.                                                                 }
{____________________________________________________________________________}

BEGIN

  WITH SbDACData DO BEGIN
    Name            := SbDACName;
    AutoDetect      := SbDACDetect;
    InitRut         := DevInit;
    ChgHzProc       := DevChgHz;
    GetRealFreqProc := GetRealFreq;
    TimerHandler    := SbDACIntHandler;
    PollRut         := DevPoll;
    EndRut          := DevEnd;
  END;

  WITH MixSbDACData DO BEGIN
    Name            := MixSbDACName;
    AutoDetect      := SbDACDetect;
    InitRut         := DevInit;
    ChgHzProc       := DevChgHz;
    GetRealFreqProc := GetRealFreq;
    TimerHandler    := MixSbDACIntHandler;
    PollRut         := DevPoll;
    EndRut          := DevEnd;
  END;

  WITH Mix2SbDACData DO BEGIN
    Name            := Mix2SbDACName;
    AutoDetect      := SbDACDetect;
    InitRut         := DevInit;
    ChgHzProc       := DevChgHz;
    GetRealFreqProc := GetRealFreq;
    TimerHandler    := Mix2SbDACIntHandler;
    PollRut         := DevPoll;
    EndRut          := DevEnd;
  END;

  InitDevice(@Mix2SbDACData);
  InitDevice(@MixSbDACData);
  InitDevice(@SbDACData);

END.
