UNIT Vid43;


INTERFACE

CONST
  ScreenSizeX  : WORD = 80;
  ScreenBytesX : WORD = 160;
  ScreenSizeY  : WORD = 43;
  ScreenBytes  : WORD = 160 * 43;
  ScreenWords  : WORD = 80 * 43;
  ScrSegment   : WORD = $B800;
  ScrOffset    : WORD = $0000;

  ForceEGA     : BOOLEAN = TRUE;

VAR
  BIOSScrOffset : WORD ABSOLUTE 0:$44E;




PROCEDURE InitVid43;

PROCEDURE PoneVideoMode43;

PROCEDURE QuitaVideoMode43;


IMPLEMENTATION

USES Debugging;

TYPE
  TChar = ARRAY[0..7] OF BYTE;

CONST
  OldMode : BYTE = $FF;

  DefPalette : ARRAY[1..17] OF BYTE = ($00, $01, $02, $03, $04, $05, $14, $07,
                                       $38, $39, $3A, $3B, $3C, $3D, $3E, $3F,
                                       $00);

  Palette : ARRAY[1..17] OF BYTE = {($00, $01, $3B, $03, $04, $3F, $14, $07,
                                     $38, $39, $3A, $3B, $3C, $3D, $3E, $3F,
                                     $00);}

                                   ($00, $07, $3F, $24, $3A, $01, $38, $3E,
                                    $00, $07, $3F, $24, $3A, $01, $38, $3E,
                                    $00);

  { Negro, Gris, Blanco, Rojo, Verde, Azul, Gris oscuro, Amarillo }
  {  0       1     2      3     4      5         6           7    }

{$L FONT.OBJ}
PROCEDURE Font8x8; EXTERNAL;

VAR
  PixFont8x8 : ARRAY[0..255] OF TChar;


PROCEDURE PoneVideoMode43; ASSEMBLER;
  ASM

        MOV     AH,$F
        INT     $10
        AND     AL,$7F
        MOV     OldMode,AL

        MOV     AL,[Debug]
        AND     AL,AL
        JNZ     @@1

        MOV     AL,[ForceEGA]
        AND     AL,AL
        JZ      @@1
         MOV    AX,$1201 { 350 lneas (EGA) para que los caracteres tengan 8X8   }
         MOV    BL,$30   { en vez de 9x8, que no sirve para hacer grficos bien. }
         INT    $10
@@1:
        MOV     AX,3     { Inicializa el modo de vdeo }
        INT     $10

        MOV     AX,$1112 { Fonts de 8x8 }
        MOV     BL,0
        INT     $10

        PUSH    BP       { Rellena el segundo font }

        MOV     AX,$1110
        MOV     BX,$801
        MOV     CX,256
        MOV     DX,0
        PUSH    DS
        POP     ES
        MOV     BP,OFFSET PixFont8x8
        INT     $10

        MOV     AX,$1110 { Rellena el primer font }
        MOV     BX,$800
        MOV     CX,256
        MOV     DX,0
        PUSH    CS
        POP     ES
        MOV     BP,OFFSET Font8x8
        INT     $10

        POP     BP

        MOV     AL,[Debug]
        AND     AL,AL
        JNZ     @@no2fonts

        MOV     AX,$1103     { Activa los dos fonts }
        MOV     BL,00000100b
        INT     $10

@@no2fonts:
        MOV     AX,$1003 { Quita parpadeo }
        MOV     BH,1
        INT     $10

        MOV     AH,1     { Elimina el cursor }
        MOV     CX,$700
        INT     $10

        MOV     AH,2     { Para ms seguridad, uso los dos mtodos }
        MOV     DX,43*256
        MOV     BH,0
        INT     $10

        MOV     AX,SEG    Palette { Pongo la paleta }
        MOV     DX,OFFSET Palette
        MOV     ES,AX
        MOV     AX,$1002
        INT     $10
{
        MOV     DX,$3DA
@@lp1:   IN     AL,DX
         AND    AL,8
         JZ     @@lp1

        MOV     DX,$3D4

        MOV     AX,$2411
        OUT     DX,AX

        MOV     AX,$2018
        OUT     DX,AX

        MOV     AX,$0107
        OUT     DX,AX
}
        MOV     AX,$0501 { Activo pgina 1 }
        INT     $10

        CLD
        MOV     DI,0     { Limpio la memoria de vdeo }
        MOV     AX,$B800
        MOV     ES,AX
        MOV     CX,$4000
        MOV     AX,$1020
        REP STOSW

        XOR     AX,AX
        MOV     ES,AX
        MOV     AX,[ES:BIOSScrOffset]
        MOV     ScrOffset,AX
  END;


PROCEDURE QuitaVideoMode43; ASSEMBLER;
  ASM

        MOV     AL,OldMode
        INC     AL
        JZ      @@1

        MOV     AX,$1202
        MOV     BL,$30
        INT     $10

        XOR     AH,AH
        MOV     AL,OldMode
        INT     $10

        XOR     AL,AL
        DEC     AL
        MOV     OldMode,AL
@@1:
  END;




VAR
  OldExitProc : POINTER;


PROCEDURE MyExitProc; FAR;
  BEGIN
    QuitaVideoMode43;
    ExitProc := OldExitProc;
  END;




PROCEDURE PokePixel(VAR Ch: TChar; w, i: BYTE);
  BEGIN

    CASE i OF
      1: BEGIN
           Ch[0] := Ch[0] AND NOT w;
           Ch[1] := Ch[1] AND NOT w;
           IF w <> $C0 THEN
             IF (Ch[3] AND (w SHL 2)) = 0 THEN
               Ch[2] := Ch[2] AND NOT (w SHL 1);
         END;
      2: BEGIN
           Ch[3] := Ch[3] AND NOT w;
           Ch[4] := Ch[4] AND NOT w;
           IF w <> $C0 THEN
             BEGIN
               IF (Ch[1] AND (w SHL 2)) = 0 THEN
                 Ch[2] := Ch[2] AND NOT (w SHL 1);
               IF (Ch[6] AND (w SHL 2)) = 0 THEN
                 Ch[5] := Ch[5] AND NOT (w SHL 1);
             END;
         END;
      3: BEGIN
           Ch[6] := Ch[6] AND NOT w;
           Ch[7] := Ch[7] AND NOT w;
           IF w <> $C0 THEN
             IF (Ch[4] AND (w SHL 2)) = 0 THEN
               Ch[5] := Ch[5] AND NOT (w SHL 1);
         END;
    END;

  END;




PROCEDURE InitVid43;
  VAR
    i, j, w: WORD;
  BEGIN
    OldExitProc := ExitProc;
    ExitProc    := @MyExitProc;

    FOR i := 0 TO 255 DO BEGIN

      FOR j := 0 TO 7 DO PixFont8x8[i][j] := $FF;

      w := $C0;
      IF ( i SHR 6       ) > 0 THEN PokePixel(PixFont8x8[i], w,  i SHR 6);

      w := $30;
      IF ((i SHR 4) AND 3) > 0 THEN PokePixel(PixFont8x8[i], w, (i SHR 4) AND 3);

      w := $0C;
      IF ((i SHR 2) AND 3) > 0 THEN PokePixel(PixFont8x8[i], w, (i SHR 2) AND 3);

      w := $03;
      IF ( i        AND 3) > 0 THEN PokePixel(PixFont8x8[i], w,  i        AND 3);

    END;
  END;




END.
