UNIT VTPlay;

INTERFACE

USES VTGlobal, VTWins, VTStrConst, StrConst,
     ModUnit, PlayMod,
     Output43, vid43,
     Filters, Debugging;




{----------------------------------------------------------------------------}
{ Definiciones generales                                                     }
{____________________________________________________________________________}

PROCEDURE InitPlayData;
{
PROCEDURE WipeFlagsState;

PROCEDURE RestoreFlagsState;
}



{----------------------------------------------------------------------------}
{ Definiciones para la ventana de informacin de posicin.                   }
{____________________________________________________________________________}

VAR
  LastFilterOn,
  LastFilterOff : TFilterMethod;
  LastFilter    : BOOLEAN;

PROCEDURE UpdateRunInfo(spd, pos, seq: WORD);




{----------------------------------------------------------------------------}
{ Definiciones para las barras de vmetros.                                  }
{____________________________________________________________________________}

VAR
  barlen         : ARRAY[1..4] OF BYTE;
  barofs         : ARRAY[1..4] OF WORD;

PROCEDURE UpdateBars;

PROCEDURE ParseBarInit(VAR nt: TModNote; i: WORD);




{----------------------------------------------------------------------------}
{ Definiciones para las ventanas de informacin de notas.                    }
{____________________________________________________________________________}

VAR
  SampleStrings : ARRAY[1..31] OF STRING[24];
  VolumeStrings : ARRAY[0..64] OF STRING[2];

  DispVolumes   : ARRAY[1..4] OF BYTE;
  DispNotes     : ARRAY[1..4] OF TModNote;
  RealVolumes   : ARRAY[1..4] OF BYTE;
  RealNotes     : ARRAY[1..4] OF TModNote;

  DispSplName   : ARRAY[1..4] OF BYTE;

PROCEDURE UpdateNoteInfo(VAR nt: TModNote; i: WORD);

PROCEDURE Update2ndLine(NewNote: BOOLEAN);




{----------------------------------------------------------------------------}
{ Definiciones para las ventanas de informacin de samples.                  }
{____________________________________________________________________________}

VAR
  DispSamples   : ARRAY[1..31] OF BYTE;
  RealSamples   : ARRAY[1..31] OF BYTE;

  siPermiso     : BOOLEAN;                  { Sample nformation }
  siTickForce   : BOOLEAN;
  siFlag        : BOOLEAN;
  siCounter     : BYTE;

CONST
  sfNoSample = 0;
  sfNotUsed  = 1;
  sfUsed     = 2;
  sfNowUsed  = 3;
  sfFlashing = 4;

PROCEDURE UpdateSampleInfo(VAR nt: TModNote; i: WORD);

PROCEDURE TickSampleInfo;

PROCEDURE SampleAttr(s, a: BYTE);




{----------------------------------------------------------------------------}
{ Definiciones para la ventana de osciloscopio.                              }
{____________________________________________________________________________}

VAR
  OscWinBuff    : ARRAY[1..16, 1..51*2] OF CHAR;
  OscSamples    : ARRAY[1..700] OF INTEGER;

PROCEDURE UpdateOscilloscInfo;




{----------------------------------------------------------------------------}
{ Definiciones para la ventana de canal on/off.                              }
{____________________________________________________________________________}

VAR
  DispPermisos   : ARRAY[1..4] OF BOOLEAN;

PROCEDURE UpdateOnOff;




IMPLEMENTATION




{----------------------------------------------------------------------------}
{ Implementacin de la ventana de informacin de posicin.                   }
{____________________________________________________________________________}

PROCEDURE UpdateRunInfo(spd, pos, seq: WORD);
  CONST
    s    : STRING = '';
    aon  : BYTE   = 0;
    aoff : BYTE   = 0;
  BEGIN

    WITH wRunInfo DO 
      IF wTopLine.vis AND wTopLine.act THEN BEGIN
        IF pos > 100 THEN pos := 0;
        STR(seq                  : 3, s); DirectWrite    (ParseCoords(x+wriX1,   y+1), s);
        STR(PatternSequence[seq] : 3, s); DirectWrite    (ParseCoords(x+wriX1,   y+2), s);
        STR(pos                  : 3, s); DirectWrite    (ParseCoords(x+wriX1,   y+3), s);
        STR(spd                  : 3, s); DirectWrite    (ParseCoords(x+wriX1,   y+4), s);

        IF (LastFilter    <> FilterIsOn) OR
           (LastFilterOn  <> FilterOn)   OR
           (LastFilterOff <> FilterOff)  OR wTopLine.forz THEN BEGIN
          IF FilterIsOn THEN BEGIN
            aon  := BYTE(col[4]);
            aoff := BYTE(col[2]);
          END ELSE BEGIN
            aon  := BYTE(col[2]);
            aoff := BYTE(col[4]);
          END;
          s[0] := #1;
          s[1] := CHAR(ORD(FilterOn)  + ORD('0'));
          DirectWriteAttr(ParseCoords(x+wriX2+1, y+4), s, aon);
          s[1] := CHAR(ORD(FilterOff) + ORD('0'));
          DirectWriteAttr(ParseCoords(x+wriX2+2, y+4), s, aoff);
          LastFilter    := FilterIsOn;
          LastFilterOn  := FilterOn;
          LastFilterOff := FilterOff;
        END;

      END;

  END;




{----------------------------------------------------------------------------}
{ Implementacin de las barras de vmetros.                                  }
{____________________________________________________________________________}

PROCEDURE MyWriteBar; ASSEMBLER;
  ASM
        MOV     BH,w2ndLine.act
        AND     BH,w2ndLine.vis
        AND     BH,BH
        JZ      @@fin

        MOV     BL,BYTE PTR [wPlayBars.col+1]
        MOV     AX,WORD PTR [wPlayBars.col+2]

        MOV     DH,13
        MOV     CH,16
        AND     DL,DL
        JZ      @@floop
@@gloop: MOV    BYTE PTR [ES:SI],AL
         INC    SI
         INC    SI
         DEC    CH
         DEC    DL
         JZ     @@floop
         DEC    DH
         JNZ     @@gloop

@@rloop: MOV    BYTE PTR [ES:SI],AH
         INC    SI
         INC    SI
         DEC    CH
         JZ     @@fin
         DEC    DL
         JNZ     @@rloop

@@floop: MOV    BYTE PTR [ES:SI],BL
         INC    SI
         INC    SI
         DEC    CH
         JNZ     @@floop
@@fin:
  END;




PROCEDURE WriteBar(i: WORD); ASSEMBLER;
  ASM
        MOV     AX,i
        DEC     AX
        MOV     BX,OFFSET barlen
        ADD     BX,AX
        MOV     DL,[BX]
        MOV     SI,OFFSET barofs
        ADD     SI,AX
        ADD     SI,AX
        MOV     SI,[SI]
        MOV     ES,ScrSegment
        CALL    MyWriteBar
  END;




PROCEDURE InitBar(i, l: WORD);
  BEGIN
    IF l > 16 THEN l := 16;
    barlen[i] := l+1;
    IF Permisos[i-1] THEN WriteBar(i);
  END;




PROCEDURE UpdateBars; ASSEMBLER;
  ASM
        MOV     ES,ScrSegment

        MOV     CX,4
        MOV     BX,OFFSET Permisos
        MOV     SI,OFFSET barlen
        MOV     DI,OFFSET barofs
@@loop:  XOR    DL,DL
         MOV    AL,[BX]
         AND    AL,AL
         JZ     @@DoWrite
         MOV    DL,[SI]
         AND    DL,DL
         JZ     @@next
          DEC   BYTE PTR [SI]
          DEC   DL
@@DoWrite:PUSH  BX
          PUSH  CX
          PUSH  SI
          MOV   SI,[DI]
          CALL  MyWriteBar
          POP   SI
          POP   CX
          POP   BX
@@next:  INC    SI
         INC    DI
         INC    DI
         INC    BX
         LOOP   @@loop
  END;




PROCEDURE ParseBarInit(VAR nt: TModNote; i: WORD);
  BEGIN

    IF      nt.comm   = mcSetVolume THEN InitBar(i, nt.param SHR 2)
    ELSE IF nt.sample <> 0          THEN InitBar(i, Instruments[nt.sample].vol SHR 2)
    ELSE IF nt.freq   <> 0          THEN InitBar(i, RealVolumes[i] SHR 2);

  END;




{----------------------------------------------------------------------------}
{ Implementacin de las ventanas de informacin de notas.                    }
{____________________________________________________________________________}

PROCEDURE UpdateNoteInfo(VAR nt: TModNote; i: WORD);
  CONST
    s        : STRING = '';
    sample   : BYTE     = 0;
    MySample : BYTE     = 0;
    vol      : WORD     = 0;
    j        : WORD     = 0;
    f        : BOOLEAN  = FALSE;
    p        : PModNote = NIL;
  BEGIN
    IF (NOT PlayMod.Permisos[i-1]) AND w2ndLine.vis AND w2ndLine.act THEN BEGIN

      IF w2ndLine.forz THEN BEGIN
        WITH wInfoNote  DO DirectWrite(ParseCoords(x+1, y+i), '                             ');
        WITH wRunSample DO DirectWrite(ParseCoords(x+1, y+i), '                        ');
      END;
{      EXIT;}
    END;

    p := @DispNotes[i];

    WITH RealNotes[i] DO BEGIN

      IF (nt.freq <> freq) AND (nt.freq <> 0) THEN
        freq := nt.freq
      ELSE
        freq := p^.freq;

      IF (nt.sample <> sample) AND (nt.sample <> 0) THEN
        sample := nt.sample
      ELSE
        sample := p^.sample;

      vol := $FFFF;

      IF (nt.freq <> 0) OR (nt.sample <> 0) THEN vol := Instruments[sample].vol;
      IF nt.comm = mcSetVolume THEN vol := nt.param;

      IF (vol <> $FFFF) AND (vol <> RealVolumes[i]) THEN
        RealVolumes[i] := vol
      ELSE
        vol := RealVolumes[i];

      IF w2ndLine.act AND w2ndLine.vis AND PlayMod.Permisos[i-1] THEN BEGIN
        IF w2ndLine.forz OR (p^.freq <> freq) THEN BEGIN
          IF freq <> 0 THEN
            BEGIN
              p^.freq := freq;
              NoteFreq(freq, s);
              WITH wInfoNote DO DirectWrite(ParseCoords(x+winX1, y+i), s);
            END;
        END;

        IF w2ndLine.forz OR (sample <> p^.sample) THEN BEGIN
          p^.sample := sample;
          IF sample <> 0 THEN
            WITH wInfoNote DO BEGIN
              STR(Instruments[sample].reps : 6, s); DirectWrite(ParseCoords(x+winX3, y+i), s);
              STR(Instruments[sample].repl : 6, s); DirectWrite(ParseCoords(x+winX4, y+i), s);
              STR(Instruments[sample].len  : 6, s); DirectWrite(ParseCoords(x+winX5, y+i), s);
            END;
        END;

        IF w2ndLine.forz OR (sample <> DispSplName[i]) THEN BEGIN
          DispSplName[i]   := sample;
          IF sample <> 0 THEN
            WITH wRunSample DO
              DirectWrite(ParseCoords(x+1, y+i), SampleStrings[sample]);
        END;

        IF w2ndLine.forz OR (DispVolumes[i] <> vol) THEN BEGIN
          DispVolumes[i]   := vol;
          WITH wInfoNote DO
            IF sample > 0 THEN
              DirectWrite(ParseCoords(x+winX2, y+i), VolumeStrings[vol])
            ELSE
              DirectWrite(ParseCoords(x+winX2, y+i), '  ');
        END;

      END;

    END;

  END;





PROCEDURE InitSampleWin;
  CONST
    s : STRING = '';
    i : WORD   = 0;
  BEGIN
    WITH wSamples1 DO
      FOR i := 1 TO 15 DO BEGIN
        STR(i : 2, s);
        DirectWriteAttr   (ParseCoords(x+1,    y+i), s,                   BYTE(col[3]));
        IF Instruments[i].Len = 0 THEN
          DirectWriteAttr (ParseCoords(x+wsX1, y+i), Instruments[i].Name, BYTE(col[2]))
        ELSE
          DirectWriteAttr (ParseCoords(x+wsX1, y+i), Instruments[i].Name, BYTE(col[3]));
      END;

    WITH wSamples2 DO
      FOR i := 16 TO 31 DO BEGIN
        STR(i : 2, s);
        DirectWriteAttr   (ParseCoords(x+1,    y+i-15), s,                   BYTE(col[3]));
        IF Instruments[i].Len = 0 THEN
          DirectWriteAttr (ParseCoords(x+wsX1, y+i-15), Instruments[i].Name, BYTE(col[2]))
        ELSE
          DirectWriteAttr (ParseCoords(x+wsX1, y+i-15), Instruments[i].Name, BYTE(col[3]));
      END;

  END;




PROCEDURE SampleAttr(s, a: BYTE);
  BEGIN
    IF s > 15 THEN
      WITH wSamples2 DO RectAttr(ParseCoords(x+wsX1, y+s-15), 22, 1, a)
    ELSE
      WITH wSamples1 DO RectAttr(ParseCoords(x+wsX1, y+s),    22, 1, a);
  END;




PROCEDURE UpdateSampleInfo(VAR nt: TModNote; i: WORD);
  CONST
    sample : BYTE = 0;
    j      : WORD = 0;
  LABEL
    Passa;
  BEGIN
    IF i = 1 THEN BEGIN
      FOR j := 1 TO 31 DO
        IF RealSamples[j] >= sfNowUsed THEN
          RealSamples[j] := sfUsed;

      FOR j := 1 TO 4 DO
        IF Permisos[j-1] AND (RealNotes[j].sample <> 0) THEN
          RealSamples[RealNotes[j].sample] := sfNowUsed;
    END;

    IF Permisos[i-1] THEN BEGIN
      IF (nt.sample <> 0) OR (nt.freq <> 0) OR ((nt.comm = mcSetVolume) AND (nt.param <> 0)) THEN BEGIN
        RealSamples[RealNotes[i].sample] := sfFlashing;
      END;
    END;

    IF i = 4 THEN BEGIN
      siFlag    := TRUE;
      siCounter := NoteSound^.Tempo-1;
      IF siCounter < 2 THEN siCounter := 2;
    END;

    WITH wSamples DO BEGIN
      siPermiso := act AND vis;

      IF siPermiso AND forz THEN BEGIN
        InitSampleWin;
        siTickForce := forz;
        TickSampleInfo;
      END;

      forz := FALSE;
    END;

  END;




PROCEDURE TickSampleInfo;
  CONST
    SizeNote = SIZEOF(TModNote);
    Attrs : ARRAY[0..4] OF BYTE = ($00, $07, $1E, $4F, $3F);
    vl    : BYTE = 0;
    i     : WORD = 0;
    j     : WORD = 0;
  LABEL
    SiendoUsada;
  BEGIN

    ASM
        MOV     AL,siFlag
        AND     AL,AL
        JZ      @@Fin

        XOR     AL,AL
        MOV     siFlag,AL
        DEC     siCounter

        MOV     AH,1
        MOV     CX,31
        MOV     SI,OFFSET RealSamples
        MOV     DI,OFFSET DispSamples
@@lp1:   PUSH   DX
         MOV    AL,[SI]
         AND    AL,AL
         JZ     @@5
         CMP    AL,sfNowUsed
         JC     @@1
{
          MOV   BX,DI
          SUB   BX,OFFSET DispSamples
          ADD   BX,OFFSET Permisos
          MOV   DL,[BX]
          AND   DL,DL
          JNZ   @@2
           MOV  AL,sfUsed
           MOV  [SI],DL
           JMP  @@4
}
@@2:      MOV   BX,OFFSET TModNote(RealNotes).sample
          MOV   DH,4
@@lp2:     CMP  [BX],AH
           JZ   @@4
           ADD  BX,SizeNote
           DEC  DH
           JNZ  @@lp2
          MOV   AL,sfUsed
          MOV   [SI],AL
          JMP   @@4
@@1:     {CMP    AL,sfFlashing
         JNZ    @@4
          MOV   [SI],DL
          MOV   AL,DL}
@@4:     MOV    DL,siPermiso
         AND    DL,DL
         JZ     @@5
         MOV    DL,siTickForce
         AND    DL,DL
         JNZ    @@6
         CMP    [DI],AL
         JZ     @@5
@@6:      XOR   DH,DH
          MOV   [DI],AL

          PUSH  DI
          PUSH  SI
          PUSH  CX
          PUSH  AX

          MOV   DL,AH
          PUSH  DX
          MOV   BX,OFFSET wSamples1.col+4
          XLAT
          MOV   DL,AL
          PUSH  DX
          CALL  SampleAttr

          POP   AX
          POP   CX
          POP   SI
          POP   DI

@@5:     INC    SI
         INC    DI
         INC    AH
         POP    DX
         LOOP   @@lp1

        MOV   siTickForce,CL


@@Fin:
    END;

(*
    DEC(siCounter);
    IF (NOT siFlag) {AND (siCounter <> 0)} THEN EXIT;

    FOR i := 1 TO 31 DO BEGIN
      vl := RealSamples[i];
      CASE vl OF
        sfNowUsed:  BEGIN
                      FOR j := 1 TO 4 DO
                        IF RealNotes[j].sample = i THEN GOTO SiendoUsada;
                      vl             := sfUsed;
                      RealSamples[i] := sfUsed;
          SiendoUsada:
                    END;
        sfFlashing: IF NOT siFlag THEN BEGIN
                      vl             := sfNowUsed;
                      RealSamples[i] := sfNowUsed;
                    END;
      END;

      IF siPermiso AND (siForceRedraw OR (vl = DispSamples[i])) THEN BEGIN
        DispSamples[i] := vl;
        SampleAttr(i, Attrs[vl]);
      END;
    END;

    siFlag := FALSE;
*)

  END;




PROCEDURE UpdateOnOff;
  CONST
    Strn : ARRAY[0..1] OF STRING[3] = ('OFF', ' ON');
    i    : WORD = 0;
  BEGIN
    IF w2ndLine.act AND w2ndLine.vis THEN
      FOR i := 1 TO 4 DO
        IF w2ndLine.forz OR (Permisos[i-1] <> DispPermisos[i]) THEN BEGIN
          DispPermisos[i] := Permisos[i-1];
          WITH wVoiceOnOff DO DirectWrite(ParseCoords(x+2, y+i), Strn[ORD(Permisos[i-1])]);
        END;
  END;




PROCEDURE Update2ndLine(NewNote: BOOLEAN);
  BEGIN

     UpdateOnOff;
     UpdateBars;

     IF NewNote THEN
       w2ndLine.forz := FALSE;

  END;




PROCEDURE PutStr(VAR Buf; VAR s: STRING; c: BYTE);
  CONST
    i : WORD = 0;
  VAR
    CBuf : ARRAY[1..32000, 1..2] OF BYTE ABSOLUTE Buf;
  BEGIN

    FOR i := 1 TO Length(s) DO BEGIN
      CBuf[i][1] := BYTE(s[i]);
      CBuf[i][2] := c;
    END;

  END;

PROCEDURE InitOscilloscInfo;
  CONST
    EmptyStr : STRING[51] = '                                                   ';
    OscView  : STRING[30] = '';
    i        : WORD       = 0;
    j        : WORD       = 0;
  BEGIN
    OscView  := GetString(StrOscilloscView);
    WITH wOscillosc DO BEGIN
      FOR i := 1 TO 16 DO PutStr(OscWinBuff[i], EmptyStr, BYTE(col[1]));
      PutStr(OscWinBuff[1][21*2-1], OscView, BYTE(col[1]));
      FOR i := 3 TO 14 DO BEGIN
        OscWinBuff[i][4] := col[1];
        OscWinBuff[i][6] := col[1];
        OscWinBuff[i][8] := col[1];
        OscWinBuff[i][3] := ' ';
        OscWinBuff[i][5] := ' ';
        OscWinBuff[i][7] := #131;
        FOR j := 5 TO 50 DO BEGIN
          OscWinBuff[i][j*2]   := col[2];
          OscWinBuff[i][j*2-1] := #0;
        END;
      END;
      OscWinBuff[15][8] := col[1];
      OscWinBuff[15][7] := #150;
      FOR j := 5 TO 50 DO BEGIN
        OscWinBuff[15][j*2]   := col[1];
        OscWinBuff[15][j*2-1] := #148;
      END;
    END;
  END;



PROCEDURE UpdateOscilloscInfo;
  CONST
    Count    : WORD = 0;
    Semaphor : BYTE = 0;
    i        : WORD = 0;
    j        : WORD = 0;
    ofs      : WORD = 0;
  LABEL
    Fin;
  BEGIN
    IF Semaphor > 0 THEN EXIT;

    INC(Semaphor);

    WITH wOscillosc DO BEGIN
      IF NOT (act AND vis) THEN GOTO Fin;
      IF forz THEN BEGIN
        InitOscilloscInfo;

        Ofs := ParseCoords(x+1, y+1);
        FOR i := 1 TO 16 DO BEGIN
          Move(OscWinBuff[i], Ptr(ScrSegment, Ofs)^, SIZEOF(OscWinBuff[1]));
          INC(Ofs, ScreenBytesX);
        END;
      END;

      INC(Count);
      IF Count < 1 THEN GOTO Fin;

      Count := 0;

      FillWithSamples(OscSamples, 46*4);

      ASM
        CLD
        MOV     CX,12
        MOV     DI,OFFSET OscWinBuff + 51*2*2 + 8
        PUSH    DS
        POP     ES
        MOV     DX,51*2 - 46*2
        MOV     AH,BYTE PTR [wOscillosc.col[2]]
        XOR     AL,AL
@@lp1:   PUSH   CX
         MOV    CX,46
         REP STOSW
         POP    CX
         ADD    DI,DX
         LOOP   @@lp1
      END;

      ASM

        CLD
        MOV     CH,46
        MOV     SI,OFFSET OscSamples
        MOV     BX,OFFSET OscWinBuff + 51*2*2 + 8
@@lp1:   MOV    CL,4
@@lp2:    LODSW
          XOR   AH,$80

          XOR   DX,DX
          MOV   DI,1821
          DIV   DI

          MOV   DL,3
          DIV   DL
          MOV   DL,AH

          MOV   DI,CX
          DEC   CL
          ADD   CL,CL
          INC   DL
          SHL   DL,CL
          MOV   CX,DI

          MOV   DH,51*2
          MUL   DH
          ADD   AX,BX
          XCHG  BX,AX
          ADD   [BX],DL
          XCHG  BX,AX

          DEC   CL
          JNZ   @@lp2
         INC    BX
         INC    BX
         DEC    CH
         JNZ    @@lp1

      END;

      Ofs := ParseCoords(x+5, y+3);
      FOR i := 3 TO 14 DO BEGIN
        Move(OscWinBuff[i][9], Ptr(ScrSegment, Ofs)^, 46*2);
        INC(Ofs, ScreenBytesX);
      END;

    END;

Fin:
    wOscillosc.forz := FALSE;

    DEC(Semaphor);

  END;




PROCEDURE InitPlayData;
  CONST
    i : WORD = 0;
    j : WORD = 0;
  BEGIN

    WITH wPlayBars DO BEGIN
      FOR i := 1 TO 4 DO BEGIN
        barlen[i] := 0;
        barofs[i] := ParseCoords(wPlayBars.x + 1, wPlayBars.y + i) + 1;
      END;
      forz := TRUE;
      act  := TRUE;
      vis  := TRUE;
    END;


    FOR i := 1 TO 31 DO BEGIN
      STR(i : 2, SampleStrings[i]);
      SampleStrings[i] := SampleStrings[i] + ' ' + Instruments[i].name;
    END;

    FOR i := 0 TO 64 DO
      STR(i : 2, VolumeStrings[i]);

    FillChar(DispVolumes, SIZEOF(DispVolumes), 0);
    FillChar(DispNotes,   SIZEOF(DispNotes),   0);
    FillChar(RealVolumes, SIZEOF(RealVolumes), 0);
    FillChar(RealNotes,   SIZEOF(RealNotes),   0);

    FillChar(DispSplName,   SIZEOF(DispSplName),   0);

    FillChar(DispSamples, SIZEOF(DispSamples), 0);
    FillChar(RealSamples, SIZEOF(RealSamples), 0);
    siTickForce    := FALSE;
    siPermiso      := TRUE;
    siFlag         := FALSE;
    siCounter      := 0;

    InitOscilloscInfo;

    FillChar(DispPermisos, SIZEOF(DispPermisos), 0);
  END;





BEGIN

END.
