UNIT VTWins;

INTERFACE

USES VTGlobal, VTStrConst, StrConst,
     SoundDevices, ModUnit, PlayMod,
     Output43, Vid43;


TYPE
  T4Window = ARRAY[1..4] OF TWindow;

CONST

{
  EmptyPalet        = #$07;

  ScreenPalet       = #$07#$85;
  RunInfoPalet      = #$47#$E0#$07#$F4;
  MiscInfoPalet     = #$47#$E7;
  CreditsPalet      = #$47#$C2;

  InfoNotePalet     = #$E7#$42;
  PlayBarsPalet     = #$80#$A0#$C0;

  OscilloscPalet    = #$47#$58;
  SamplesPalet      = #$07#$E0;
  Samples1Palet     = #$07#$E7#$E0#$00#$70#$E1#$54#$53;
  Samples2Palet     = #$07#$E7#$E0;
  MenusPalet        = #$07#$00#$50#$17#$E1#$01#$10;

  PartPalet         = #$A0#$00#$07;
}

  EmptyPalet        = #$01;

  ScreenPalet       = #$61#$62#$31;

  F8Palet           = #$10#$30#$10;

  RunInfoPalet      = #$51#$70#$01#$23;
  MiscInfoPalet     = #$51#$70;
  LabelPalet        = #$51#$37;

  InfoNotePalet     = #$71#$25#$70;
  PlayBarsPalet     = #$60#$40#$30;

  OscilloscPalet    = #$31#$2E;
  SamplesPalet      = #$01#$70;
  Samples1Palet     = #$01#$71#$70#$00#$20#$75#$23#$37;
  Samples2Palet     = #$01#$71#$70;
  MenusPalet        = #$01#$00#$20#$51#$75#$05#$50;

  PartPalet         = #$40#$00#$01#$25;

  CreditsPalet      = #$51#$21#$31;


  wF8Demo      : TWindow = (x: 0; y: 0; w:80; h:27; col: F8Palet;        vis:FALSE; forz:FALSE; act:FALSE);
  wF8DemoUp    : TWindow = (x: 0; y:-1; w:80; h: 2; col: ScreenPalet;    vis:FALSE; forz:FALSE; act:FALSE);
  wF8DemoDown  : TWindow = (x: 0; y:26; w:80; h: 7; col: ScreenPalet;    vis:FALSE; forz:FALSE; act:FALSE);

  wScreen      : TWindow = (x: 0; y: 0; w:80; h:43; col: ScreenPalet;    vis:FALSE; forz:FALSE; act:FALSE);

  wTopLine     : TWindow = (x: 0; y: 0; w:80; h: 6; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);
  wRunInfo     : TWindow = (x: 0; y: 0; w:20; h: 6; col: RunInfoPalet;   vis:FALSE; forz:FALSE; act:FALSE);
  wMiscInfo    : TWindow = (x:19; y: 0; w:46; h: 6; col: MiscInfoPalet;  vis:FALSE; forz:FALSE; act:FALSE);
  wLabel       : TWindow = (x:59; y: 0; w:21; h: 6; col: LabelPalet;     vis:FALSE; forz:FALSE; act:FALSE);

  w2ndLine     : TWindow = (x: 0; y: 5; w:80; h: 6; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);
  wRunSample   : TWindow = (x: 0; y: 5; w:27; h: 6; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);
  wInfoNote    : TWindow = (x:26; y: 5; w:31; h: 6; col: InfoNotePalet;  vis:FALSE; forz:FALSE; act:FALSE);
  wPlayBars    : TWindow = (x:56; y: 5; w:18; h: 6; col: PlayBarsPalet;  vis:FALSE; forz:FALSE; act:FALSE);
  wVoiceOnOff  : TWindow = (x:73; y: 5; w: 7; h: 6; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);


  wOscillosc   : TWindow = (x: 0; y:10; w:53; h:18; col: OscilloscPalet; vis:FALSE; forz:FALSE; act:FALSE);
  wSamples     : TWindow = (x: 0; y:10; w:53; h:18; col: SamplesPalet;   vis:FALSE; forz:FALSE; act:FALSE);
  wSamples1    : TWindow = (x: 0; y:10; w:27; h:17; col: Samples1Palet;  vis:FALSE; forz:FALSE; act:FALSE);
  wSamplesFill : TWindow = (x: 0; y:27; w:27; h: 1; col: Samples2Palet;  vis:FALSE; forz:FALSE; act:FALSE);
  wSamples2    : TWindow = (x:26; y:10; w:27; h:18; col: Samples2Palet;  vis:FALSE; forz:FALSE; act:FALSE);

  wMenus       : TWindow = (x:52; y:10; w:28; h:18; col: MenusPalet;     vis:FALSE; forz:FALSE; act:FALSE);

  wPartSmall   : TWindow = (x: 0; y:27; w:80; h:16; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);
  wPartPastIdx : TWindow = (x: 0; y:27; w: 4; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE);
  wPartPast    : T4Window = (
                           (x: 3; y:27; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:22; y:27; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:41; y:27; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:60; y:27; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE)
                 );
  wPartActIdx  : TWindow = (x: 0; y:33; w: 4; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);
  wPartAct     : T4Window = (
                           (x: 3; y:33; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE),
                           (x:22; y:33; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE),
                           (x:41; y:33; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE),
                           (x:60; y:33; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE)
                 );
  wPartFutIdx  : TWindow = (x: 0; y:36; w: 4; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE);
  wPartFut     : T4Window = (
                           (x: 3; y:36; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:22; y:36; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:41; y:36; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:60; y:36; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE)
                 );

  wPartBig     : TWindow = (x: 0; y: 5; w:80; h:38; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);
  wPartPastBIdx: TWindow = (x: 0; y: 5; w: 4; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE);
  wPartPastBig : T4Window = (
                           (x: 3; y: 5; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:22; y: 5; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:41; y: 5; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:60; y: 5; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE)
                 );
  wPartActBIdx : TWindow = (x: 0; y:22; w: 4; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);
  wPartActBig  : T4Window = (
                           (x: 3; y:22; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE),
                           (x:22; y:22; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE),
                           (x:41; y:22; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE),
                           (x:60; y:22; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE)
                 );
  wPartFutBIdx : TWindow = (x: 0; y:25; w: 4; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE);
  wPartFutBig  : T4Window = (
                           (x: 3; y:25; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:22; y:25; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:41; y:25; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:60; y:25; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE)
                 );
  wCredits     : TWindow = (x: 0; y: 5; w:80; h:38; col: CreditsPalet;   vis:FALSE; forz:FALSE; act:FALSE);

CONST
  BarVal = '';

VAR
  wriX1, wriX2,
  wmiX1,
  winX1, winX2, winX3, winX4, winX5,
  wsX1                               : WORD;



PROCEDURE InitWinF8Demo;
PROCEDURE InitWinScreen;
PROCEDURE InitWinTopLine;
PROCEDURE InitWin2ndLine;
PROCEDURE InitWinOscillosc;
PROCEDURE InitWinSamples;
PROCEDURE InitWinMenus;
PROCEDURE InitWinPart;
PROCEDURE InitWinBigPart;
PROCEDURE InitWinCredits;

PROCEDURE InitScreen;

PROCEDURE RefreshMiscInfo;

PROCEDURE RefreshModuleInfo;




IMPLEMENTATION

USES DOSMem;




PROCEDURE InitWinF8Demo;
  VAR
    i       : WORD;
    SaveOfs : WORD;
    Spaces  : STRING[80];
  BEGIN
    SaveOfs   := ScrOffset;
    ScrOffset := 0;

    ClearScreen;
    PutWindowBigFrame(wF8Demo);

    WITH wF8Demo DO
      BEGIN

        FillChar(Spaces, SIZEOF(Spaces), ' ');
        Spaces[0] := #80;

        FOR i := 0 TO 26 DO
          DirectWriteAttr(ParseCoords(0, i), Spaces, BYTE(Col[3]));

        PutWindowBigFrame(wF8DemoUp);
        PutWindowBigFrame(wF8DemoDown);

        DirectWriteAttr(ParseCoords(27, 4), 'Demo de ventanas  en el VT', BYTE(Col[3]));
        DirectWriteAttr(ParseCoords(35, 6), 'Te gusta?',                 BYTE(Col[3]));

        DirectWriteAttr(ParseCoords(7, 10),
          'En la prxima versin se supone que aqu podrs hacer el Shell.',                 BYTE(Col[2]));
      END;

    ScrOffset := SaveOfs;
  END;


PROCEDURE InitWinScreen;
  BEGIN
    ClearScreen;
    PutWindowBigFrame(wScreen);
  END;


PROCEDURE InitWinRunInfo;
  BEGIN
    PutWindow(wRunInfo);

    WITH wRunInfo DO BEGIN
      vis  := FALSE;
      forz := FALSE;
      act  := FALSE;

      wriX1 := 12;
      wriX2 := 16;
      DirectWrite     (ParseCoords(x+ 1, y+1), GetString(StrPosition));
      DirectWrite     (ParseCoords(x+ 1, y+2), GetString(StrPattern));
      DirectWrite     (ParseCoords(x+ 1, y+3), GetString(StrNote));
      DirectWrite     (ParseCoords(x+ 1, y+4), GetString(StrTempo));
      DirectWriteAttr (ParseCoords(x+wriX2-1, y+1), '/',   BYTE(col[3]));
      DirectWriteAttr (ParseCoords(x+wriX2-1, y+2), '/',   BYTE(col[3]));
      RectAttr        (ParseCoords(x+wriX2,   y+1), 3, 2,  BYTE(col[2]));
      RectAttr        (ParseCoords(x+wriX1,   y+1), 3, 4,  BYTE(col[2]));
      DirectWriteAttr (ParseCoords(x+wriX2,   y+4), 'F  ', BYTE(col[2]));
    END;
  END;


PROCEDURE InitWinMiscInfo;
  BEGIN
    PutWindow(wMiscInfo);

    WITH wMiscInfo DO BEGIN
      DirectWrite (ParseCoords(x+1, y+1), GetString(StrModule));
      DirectWrite (ParseCoords(x+1, y+2), GetString(StrFilename));
      DirectWrite (ParseCoords(x+1, y+3), GetString(StrMemoryLeft));
      DirectWrite (ParseCoords(x+1, y+4), GetString(StrSampleRate));
      wmiX1 := 14;
      RectAttr    (ParseCoords(x+wmiX1, y+1), 20,         1, BYTE(col[2]));
      RectAttr    (ParseCoords(x+wmiX1, y+2), 12,         1, BYTE(col[2]));
      RectAttr    (ParseCoords(x+wmiX1, y+3), 21,         1, BYTE(col[2]));
      RectAttr    (ParseCoords(x+wmiX1, y+4), 5,          1, BYTE(col[2]));
    END;
  END;


PROCEDURE InitWinLabel;
  BEGIN
    PutWindow(wLabel);

    WITH wLabel DO BEGIN
      RectAttr    (ParseCoords(x+2, y+2), 17, 2, BYTE(col[2]));
      DirectWrite (ParseCoords(x+3, y+2), 'Vangeliracker');
      DirectWrite (ParseCoords(x+4, y+3), NoBetaPadding+Version+BetaPadStr);
    END;
  END;


PROCEDURE InitWinTopLine;
  BEGIN
    InitWinRunInfo;
    InitWinMiscInfo;
    InitWinLabel;
  END;


PROCEDURE InitWinRunSample;
  BEGIN
    PutWindow(wRunSample);
  END;


PROCEDURE InitWinInfoNote;
  BEGIN
    PutWindow(wInfoNote);

    WITH wInfoNote DO BEGIN
      winX1 :=  2;
      winX2 :=  6;
      winX3 :=  9;
      winX4 := 16;
      winX5 := 23;
      PutRotulo (ParseCoords(x+ 1, y), 'freq', BYTE(col[2]));
      PutRotulo (ParseCoords(x+ 6, y), 'vl',   BYTE(col[2]));
      PutRotulo (ParseCoords(x+11, y), 'reps', BYTE(col[2]));
      PutRotulo (ParseCoords(x+18, y), 'repl', BYTE(col[2]));
      PutRotulo (ParseCoords(x+26, y), 'len',  BYTE(col[2]));
      RectAttr  (ParseCoords(x+ 2, y+1), 3, 4, BYTE(col[3]));
      RectAttr  (ParseCoords(x+ 6, y+1), 2, 4, BYTE(col[3]));
      RectAttr  (ParseCoords(x+ 9, y+1), 6, 4, BYTE(col[3]));
      RectAttr  (ParseCoords(x+16, y+1), 6, 4, BYTE(col[3]));
      RectAttr  (ParseCoords(x+23, y+1), 6, 4, BYTE(col[3]));
    END;
  END;


PROCEDURE InitWinPlayBars;
  VAR
    i, j : WORD;
  BEGIN
    PutWindow(wPlayBars);

    WITH wPlayBars DO BEGIN
      vis  := FALSE;
      forz := FALSE;
      act  := FALSE;

      FOR i := 1 TO 4 DO
        FOR j := 1 TO 16 DO
          DirectWriteAttr(ParseCoords(x+j, y+i), Barval, BYTE(col[1]));
    END;
  END;


PROCEDURE InitWinVoiceOnOff;
  BEGIN
    PutWindow(wVoiceOnOff);
  END;


PROCEDURE InitWin2ndLine;
  BEGIN
    InitWinRunSample;
    InitWinInfoNote;
    InitWinPlayBars;
    InitWinVoiceOnOff;
  END;


PROCEDURE InitWinOscillosc;
  VAR
    i : WORD;
  BEGIN
    PutWindow(wOscillosc);

    WITH wOscillosc DO BEGIN
      DirectWrite(ParseCoords(x+21, y+1), GetString(StrOscilloscView));
      FOR i := 3 TO 14 DO
        DirectWrite(ParseCoords(x+7, y+i),  #131);
      DirectWrite  (ParseCoords(x+7, y+15), #150);
      FOR i := 8 TO 50 DO
        DirectWrite(ParseCoords(x+i, y+15), #148);
    END;
  END;


PROCEDURE InitWinSamples;
  VAR
    i : WORD;
  BEGIN
    PutWindow(wSamples);
    PutWindow(wSamples1);
    FOR i := 1 TO 4 DO
      WITH wPartPast[i] DO BEGIN
        PutRotulo(ParseCoords(x+5,                               y), GetString(StrChannel), BYTE(col[4]));
        PutRotulo(ParseCoords(x+5+Length(GetString(StrChannel)), y), CHAR(i+ORD('0')),      BYTE(col[4]));
      END;
  END;


PROCEDURE InitWinMenus;
  BEGIN
    PutWindow(wMenus);

    wsX1 := 4;

    WITH wMenus DO BEGIN
      RectAttr    (ParseCoords(x+2, y+2), 24, 3,  $00);
      DirectWrite (ParseCoords(x+2, y+1), '');
      DirectWrite (ParseCoords(x+2, y+3), '');
      DirectWrite (ParseCoords(x+2, y+5), '');
    END;


    WITH wMenus DO BEGIN
      DirectWriteAttr(ParseCoords(x+ 2, y+2), ' FILE  EDIT  PLAY  MISC ', BYTE(col[3]));
      RectAttr       (ParseCoords(x+14, y+1), 6,  1, BYTE(col[4]));
      RectAttr       (ParseCoords(x+14, y+2), 6,  1, BYTE(col[5]));
      RectAttr       (ParseCoords(x+14, y+3), 6,  1, BYTE(col[6]));

      DirectWriteAttr(ParseCoords(x+ 2, y+4), ' SAMPLES  PATTERN  SONG ', BYTE(col[3]));
      RectAttrMask   (ParseCoords(x+20, y+3), 6,  1, BYTE(col[7]), $0F);
      RectAttr       (ParseCoords(x+20, y+4), 6,  1, BYTE(col[5]));
      RectAttr       (ParseCoords(x+20, y+5), 6,  1, BYTE(col[4]));

{
      DirectWriteAttr(x+2, y+4, '   MODULE      SAMPLE   ', BYTE(col[3]));
      RectAttrMask   (x+2, y+3, 12,  1, $01, $F0);
      RectAttr       (x+2, y+4, 12,  1, $1E);
      RectAttr       (x+2, y+5, 12,  1, $71);

      DirectWriteAttr(x+2, y+4, ' SAMPLES  PATTERN  LINK ', BYTE(col[3]));
      DirectWriteAttr(x+2, y+4, ' SAMPLES  PATTERN  SONG ', BYTE(col[3]));
      DirectWriteAttr(x+2, y+4, ' NAME ',                   BYTE(col[3]));
}

      DirectWrite(ParseCoords(x+3, y+ 6), GetString(StrMenuPgUpDn));
      DirectWrite(ParseCoords(x+3, y+ 7), GetString(StrMenuHmEnd));
      DirectWrite(ParseCoords(x+3, y+ 8), GetString(StrMenu1234));
      DirectWrite(ParseCoords(x+3, y+ 9), GetString(StrMenuWins));
      DirectWrite(ParseCoords(x+3, y+10), GetString(StrMenuFG));
      DirectWrite(ParseCoords(x+3, y+11), GetString(StrMenuRT));
      DirectWrite(ParseCoords(x+3, y+12), GetString(StrMenuVol));
      DirectWrite(ParseCoords(x+3, y+13), GetString(StrMenuD));
      DirectWrite(ParseCoords(x+3, y+14), GetString(StrMenuN));
      DirectWrite(ParseCoords(x+3, y+15), GetString(StrMenuESC));
    END;
  END;


PROCEDURE InitWinPart;
  VAR
    i : WORD;
  BEGIN
    PutWindow(wPartSmall);
    PutWindow(wPartPastIdx);
    PutWindow(wPartActIdx);
    PutWindow(wPartFutIdx);
    FOR i := 1 TO 4 DO BEGIN
      PutWindow(wPartPast[i]);
      PutWindow(wPartAct[i]);
      PutWindow(wPartFut[i]);
      WITH wPartPast[i] DO BEGIN
        PutRotulo(ParseCoords(x+5,                               y), GetString(StrChannel), BYTE(col[4]));
        PutRotulo(ParseCoords(x+5+Length(GetString(StrChannel)), y), CHAR(i+ORD('0')),      BYTE(col[4]));
      END;
    END;
  END;


PROCEDURE InitWinBigPart;
  VAR
    i : WORD;
  BEGIN
    PutWindow(wPartBig);
    PutWindow(wPartPastBIdx);
    PutWindow(wPartActBIdx);
    PutWindow(wPartFutBIdx);
    FOR i := 1 TO 4 DO BEGIN
      PutWindow(wPartPastBig[i]);
      PutWindow(wPartActBig[i]);
      PutWindow(wPartFutBig[i]);
      WITH wPartPastBig[i] DO BEGIN
        PutRotulo(ParseCoords(x+5,                               y), GetString(StrChannel), BYTE(col[4]));
        PutRotulo(ParseCoords(x+5+Length(GetString(StrChannel)), y), CHAR(i+ORD('0')),      BYTE(col[4]));
      END;
    END;
  END;


PROCEDURE InitWinCredits;
  VAR
    i : WORD;
  BEGIN
    PutWindow(wCredits);

    WITH wCredits DO BEGIN
      DirectWriteAttr(ParseCoords  (x+10, y+   2), GetString(StrCreditsTitle), BYTE(col[3]));

      FOR i := 0 TO LastCreditsLine DO
        DirectWriteAttr(ParseCoords(x+10, y+i+ 4), GetString(StrCredits0 + i), BYTE(col[1]));

      FOR i := 0 TO LastDedicatLine DO
        DirectWriteAttr(ParseCoords(x+10, y+i+34), GetString(StrDedicat0 + i), BYTE(col[2]));
    END;

  END;




PROCEDURE InitScreen;
  VAR
    i, j : WORD;
    s    : STRING;
  BEGIN

    InitWinScreen;
    InitWinTopLine;
    InitWin2ndLine;
    InitWinSamples;
    InitWinMenus;
    InitWinPart;

  END;



PROCEDURE RefreshMiscInfo;
  VAR
    s : STRING;
    t : STRING;
    u : STRING;
  BEGIN
    WITH wMiscInfo DO BEGIN
      DirectWriteAttr(ParseCoords(x+wmiX1, y+1), SongName,     BYTE(col[2]));
      DirectWriteAttr(ParseCoords(x+wmiX1, y+2), SongFileName, BYTE(col[2]));
      STR(MaxAvail,    s);
      STR(MemAvail,    t);
      STR(DOSMemAvail, u);
                                                 {xxxxx (xxxxx) | xxxxxx}
      DirectWriteAttr(ParseCoords(x+wmiX1, y+3), '                      ', BYTE(col[2]));
      DirectWriteAttr(ParseCoords(x+wmiX1, y+3), t+' ('+s+') | '+u,        BYTE(col[2]));
      IF SoundHz >= 500 THEN
        STR(SoundHz + 50 - ((SoundHz + 50) MOD 100), s)
      ELSE
        s := 'FallB';
      DirectWriteAttr(ParseCoords(x+wmiX1, y+4), '     ',                  BYTE(col[2]));
      DirectWriteAttr(ParseCoords(x+wmiX1, y+4), s,                        BYTE(col[2]));
    END;
  END;





PROCEDURE RefreshModuleInfo;
  VAR
    i : WORD;
    s : STRING;
    t : STRING;
  BEGIN

    WITH wRunInfo DO BEGIN
      STR(SequenceLength : 3, s); DirectWrite(ParseCoords(x+wriX2, y+1), s);
      STR(NumPatterns    : 3, s); DirectWrite(ParseCoords(x+wriX2, y+2), s);
      s := '   ';
      DirectWrite(ParseCoords(x+wriX1, y+1), s);
      DirectWrite(ParseCoords(x+wriX1, y+2), s);
      DirectWrite(ParseCoords(x+wriX1, y+3), s);
      DirectWrite(ParseCoords(x+wriX1, y+4), s);
    END;

    RefreshMiscInfo;

    WITH wSamples1 DO
      FOR i := 1 TO 15 DO BEGIN
        STR(i : 2, s);
        DirectWriteAttr   (ParseCoords(x+1,    y+i), s,                   BYTE(col[3]));
        IF Instruments[i].Len = 0 THEN
          DirectWriteAttr (ParseCoords(x+wsX1, y+i), Instruments[i].Name, BYTE(col[2]))
        ELSE
          DirectWriteAttr (ParseCoords(x+wsX1, y+i), Instruments[i].Name, BYTE(col[3]));
      END;

    WITH wSamples2 DO
      FOR i := 16 TO 31 DO BEGIN
        STR(i : 2, s);
        DirectWriteAttr   (ParseCoords(x+1,    y+i-15), s,                   BYTE(col[3]));
        IF Instruments[i].Len = 0 THEN
          DirectWriteAttr (ParseCoords(x+wsX1, y+i-15), Instruments[i].Name, BYTE(col[2]))
        ELSE
          DirectWriteAttr (ParseCoords(x+wsX1, y+i-15), Instruments[i].Name, BYTE(col[3]));
      END;

  END;



{
VAR
  BIOSScrOffset : WORD ABSOLUTE 0:$44E;
}
BEGIN

  pwAttr    := BYTE(wScreen.col[2]);
{  ScrOffset := BIOSScrOffset;}

END.
