/*
 * Decompiled with CFR 0.152.
 */
package oscP5;

import java.net.DatagramPacket;
import java.net.InetAddress;
import netP5.Bytes;
import netP5.Logger;
import netP5.TcpClient;
import netP5.TcpPacket;
import oscP5.OscArgument;
import oscP5.OscPacket;

public class OscMessage
extends OscPacket {
    protected final OscArgument _myOscArgument = new OscArgument();
    protected boolean isPlugged = false;

    protected OscMessage(DatagramPacket datagramPacket) {
        this.inetAddress = datagramPacket.getAddress();
        this.port = datagramPacket.getPort();
        this.hostAddress = this.inetAddress.toString();
        this.parseMessage(datagramPacket.getData());
        this._myType = 0;
    }

    protected OscMessage(TcpPacket tcpPacket) {
        this._myTcpClient = tcpPacket.getTcpConnection();
        this.inetAddress = this._myTcpClient.netAddress().inetaddress();
        this.port = this._myTcpClient.netAddress().port();
        this.hostAddress = this.inetAddress.toString();
        this.parseMessage(tcpPacket.getData());
        this._myType = 0;
    }

    public OscMessage(OscMessage oscMessage) {
        this.inetAddress = oscMessage.inetAddress;
        this.port = oscMessage.port;
        this.hostAddress = oscMessage.hostAddress;
        this._myTcpClient = oscMessage.tcpConnection();
        this._myAddrPattern = oscMessage._myAddrPattern;
        this._myTypetag = oscMessage._myTypetag;
        this._myData = oscMessage._myData;
        this._myArguments = oscMessage._myArguments;
        this.isValid = true;
    }

    public OscMessage(String string) {
        this(string, new Object[0]);
    }

    public OscMessage(int n) {
        this(n, new Object[0]);
    }

    public OscMessage(String string, Object[] objectArray) {
        this.init();
        this.setAddrPattern(string);
        this.setArguments(objectArray);
    }

    public OscMessage(int n, Object[] objectArray) {
        this.init();
        this.setAddrPattern(n);
        this.setArguments(objectArray);
    }

    protected OscMessage(byte[] byArray, InetAddress inetAddress, int n, TcpClient tcpClient) {
        this._myTcpClient = tcpClient;
        this.inetAddress = inetAddress;
        this.port = n;
        this.hostAddress = this.inetAddress.toString();
        this.parseMessage(byArray);
    }

    protected OscMessage(byte[] byArray, InetAddress inetAddress, int n, long l, TcpClient tcpClient) {
        this(byArray, inetAddress, n, tcpClient);
        this.timetag = l;
    }

    protected void init() {
        this._myTypetag = new byte[0];
        this._myData = new byte[0];
    }

    public void clear() {
        this.init();
        this.setAddrPattern("");
        this.setArguments(new Object[0]);
    }

    void set(int n, Object object) {
    }

    public boolean checkTypetag(String string) {
        return string.equals(this.typetag());
    }

    public boolean checkAddrPattern(String string) {
        return string.equals(this.addrPattern());
    }

    public void setAddrPattern(String string) {
        this._myAddrPattern = string.getBytes();
    }

    public void setAddrPattern(int n) {
        this._myAddrPattern = Bytes.toBytes(n);
    }

    public void setArguments(Object[] objectArray) {
        this._myArguments = objectArray;
        this.add(this._myArguments);
    }

    public String addrPattern() {
        return Bytes.getAsString(this._myAddrPattern);
    }

    public int addrInt() {
        return this._myAddrInt;
    }

    public String typetag() {
        return Bytes.getAsString(this._myTypetag);
    }

    public long timetag() {
        return this.timetag;
    }

    public Object[] arguments() {
        return this._myArguments;
    }

    protected Object[] argsAsArray() {
        switch (this._myTypetag[0]) {
            case 102: {
                float[] fArray = new float[this._myArguments.length];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = ((Float)this._myArguments[i]).floatValue();
                }
                return new Object[]{fArray};
            }
            case 105: {
                int[] nArray = new int[this._myArguments.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (Integer)this._myArguments[i];
                }
                return new Object[]{nArray};
            }
            case 83: 
            case 115: {
                String[] stringArray = new String[this._myArguments.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)this._myArguments[i];
                }
                return new Object[]{stringArray};
            }
        }
        return new Object[0];
    }

    public byte[] getAddrPatternAsBytes() {
        return Bytes.append(this._myAddrPattern, new byte[OscMessage.align(this._myAddrPattern.length)]);
    }

    public byte[] getTypetagAsBytes() {
        return this._myTypetag;
    }

    public Object[] getData() {
        return this._myArguments;
    }

    public String getTypetag() {
        return this.typetag();
    }

    public String getAddrPattern() {
        return this.addrPattern();
    }

    public int getAddrInt() {
        return this.addrInt();
    }

    public String addrpattern() {
        return this.addrPattern();
    }

    public Object[] getArguments() {
        return this.arguments();
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[]{};
        byte[] byArray2 = Bytes.copy(this._myTypetag, 0);
        byArray = Bytes.append(byArray, this._myAddrPattern, new byte[OscMessage.align(this._myAddrPattern.length)]);
        if (byArray2.length == 0) {
            byArray2 = new byte[]{44};
        } else if (byArray2[0] != 44) {
            byArray2 = Bytes.append(new byte[]{44}, byArray2);
        }
        byArray = Bytes.append(byArray, byArray2, new byte[OscMessage.align(byArray2.length)]);
        byArray = Bytes.append(byArray, this._myData, new byte[OscMessage.align(this._myData.length) % 4]);
        return byArray;
    }

    public void add() {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{78});
    }

    public void add(int n) {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{105});
        this._myData = Bytes.append(this._myData, Bytes.toBytes(n));
    }

    public void add(String string) {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{115});
        byte[] byArray = string.getBytes();
        this._myData = Bytes.append(this._myData, byArray, new byte[OscMessage.align(byArray.length)]);
    }

    public void add(float f) {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{102});
        this._myData = Bytes.append(this._myData, Bytes.toBytes(Float.floatToIntBits(f)));
    }

    public void add(double d) {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{100});
        this._myData = Bytes.append(this._myData, Bytes.toBytes(Double.doubleToLongBits(d)));
    }

    public void add(boolean bl) {
        this._myTypetag = bl ? Bytes.append(this._myTypetag, new byte[]{84}) : Bytes.append(this._myTypetag, new byte[]{70});
    }

    public void add(Boolean bl) {
        this.add((boolean)bl);
    }

    public void add(Integer n) {
        this.add((int)n);
    }

    public void add(Float f) {
        this.add(f.floatValue());
    }

    public void add(Double d) {
        this.add((double)d);
    }

    public void add(Character c) {
        this.add(c.charValue());
    }

    public void add(char c) {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{99});
        this._myData = Bytes.append(this._myData, Bytes.toBytes(c));
    }

    public void add(int n, int n2, int n3, int n4) {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{109});
        byte[] byArray = new byte[]{(byte)n, (byte)n2, (byte)n3, (byte)n4};
        this._myData = Bytes.append(this._myData, byArray);
    }

    public void add(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.add(nArray[i]);
        }
    }

    public void add(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            this.add(cArray[i]);
        }
    }

    public void add(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            this.add(fArray[i]);
        }
    }

    public void add(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.add(stringArray[i]);
        }
    }

    public void add(byte[] byArray) {
        this._myTypetag = Bytes.append(this._myTypetag, new byte[]{98});
        this._myData = Bytes.append(this._myData, OscMessage.makeBlob(byArray));
    }

    public void add(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.add(objectArray[i])) continue;
            System.out.println("type of Argument not defined in osc specs.");
        }
    }

    private boolean add(Object object) {
        if (object instanceof Number) {
            if (object instanceof Integer) {
                this.add((Integer)object);
            } else if (object instanceof Float) {
                this.add((Float)object);
            } else if (object instanceof Double) {
                this.add((Double)object);
            } else if (object instanceof Long) {
                this.add((Long)object);
            }
        } else if (object instanceof String) {
            this.add((String)object);
        } else if (object instanceof Boolean) {
            this.add((Boolean)object);
        } else if (object instanceof Character) {
            this.add((Character)object);
        } else {
            if (object instanceof int[]) {
                this.add((int[])object);
                return true;
            }
            if (object instanceof float[]) {
                this.add((float[])object);
                return true;
            }
            if (object instanceof byte[]) {
                this.add((byte[])object);
                return true;
            }
            if (object instanceof String[]) {
                this.add((String[])object);
                return true;
            }
            if (object instanceof char[]) {
                this.add((char[])object);
                return true;
            }
            if (object instanceof double[]) {
                this.add((float[])object);
                return true;
            }
            return false;
        }
        return true;
    }

    public static byte[] makeBlob(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = Bytes.toBytes(n);
        byArray2 = Bytes.append(byArray2, byArray);
        int n2 = n % 4;
        if (n2 != 0) {
            byArray2 = Bytes.append(byArray2, new byte[4 - n2]);
        }
        return byArray2;
    }

    public OscArgument get(int n) {
        if (n < this.arguments().length) {
            this._myOscArgument.value = this.arguments()[n];
            return this._myOscArgument;
        }
        return null;
    }

    public final String toString() {
        return this.hostAddress + ":" + this.port + " | " + this.addrPattern() + " " + this.typetag();
    }

    public boolean isPlugged() {
        return this.isPlugged;
    }

    public void print() {
        Logger.println("-OscMessage----------");
        Logger.println("received from\t" + this.hostAddress + ":" + this.port);
        Logger.println("addrpattern\t" + Bytes.getAsString(this._myAddrPattern));
        Logger.println("typetag\t" + Bytes.getAsString(this._myTypetag));
        Logger.println(Bytes.getAsString(this._myArguments));
        Logger.println("---------------------");
    }
}

