/*
 * WhereIs Version 1.00
 * Copyright (C) 1995 Hiroyuki Sekiya
 */

#include <lxapi.h>
#include <string.h>
#include "whereis.h"

#define ENTERKEY		0x0D
#define ESCKEY			0x1B
#define SPACEKEY		0x20
#define CUTKEY			0xD400
#define COPYKEY			0xD500
#define PASTEKEY		0xD600
#define MARKCHAR		0x04		/* }[N */
#define MAXPATH			80			/* pX̍ő咷 */

#define ShiftPressed()	((m_sh_status() & 0x0003) != 0)


/***************************************************************************
* Far Strings
***************************************************************************/

char far *msgAppName	= "WhereIs";
char far *msgOk			= "OK";
char far *msgCancel		= "Cancel";
char far *msgFileMask	= "File Mask";
char far *msgMask		= "Mask";
char far *msgOpen		= "Open";
char far *msgOpenFile	= "Open File";
char far *msgOption		= "Options";
char far *msg_Option	= "&Options";
char far *msg_Search	= "&Search";
char far *msg_Launch	= "&Launch";
char far *msgQuit		= "Quit";
char far *msg_Quit		= "&Quit";
char far *msg_Help		= "&Help";
char far *msgAbout		= "About WhereIs";
char far *msg_About		= "&About WhereIs";
char far *msgError		= "Error";
char far *msg_FSearch	= "&File to search";
char far *msgSrchOpt	= "Search Options";
char far *msg_Drives	= "Target &Drives";
char far *msg_SrchHidn	= "Search &Hidden Files Too";
char far *msgLnchOpt	= "Launch Options";
char far *msg_DefCmd	= "&Default Command";
char far *msg_CmdLine	= "&Command Line";
char far *msg_Pause		= "Exec then &Pause";
char far *msg_NoChDir	= "Don't Change &Dir";
char far *msgAboutText	= "WhereIs 1.00\n\n"
						  "Copyright (C) 1995 Hiroyuki Sekiya\n\n"
						  "All Rights Reserved";
char far **msgAboutPtr	= &msgAboutText;

char far **StringTable[] = {
	&msgAppName, &msgOk, &msgCancel, &msgFileMask, &msgMask, &msgOpen,
	&msgOpenFile, &msgOption, &msg_Option, &msg_Search, &msg_Launch,
	&msgQuit, &msg_Quit, &msg_Help, &msgAbout, &msg_About, &msgError,
	&msg_FSearch, &msgSrchOpt, &msg_Drives, &msg_SrchHidn, &msgLnchOpt,
	&msg_DefCmd, &msg_CmdLine, &msg_Pause, &msg_NoChDir, &msgAboutText
};


#if defined(TURBOC)
#define GetDataSeg()	_DS
#endif
#if defined(LSIC)
int _asm_(char *);
#define GetDataSeg()	_asm_(" mov ax,ds\n")
#endif

void FixupFarPtrs(void)
{
int i,dataseg;
#if defined(MSC)
	_asm {
		mov	ax,ds;
		mov	dataseg,ax;
	}
#else
	dataseg=GetDataSeg();
#endif
	for(i=0; i<countof(StringTable); i++)
		*(((int *)(StringTable[i]))+1) = dataseg;
}


/***************************************************************************
* Global Variables
***************************************************************************/

LHAPIBLOCK LHAPIData;
EVENT Event;
BOOL Done				= FALSE;

char MyEnvPath[]		= "a:\\_dat\\whereis.env";

/* tO */
#define GF_PAUSE		0x0001		/* R}hsPAUSE */
#define GF_NOCHDIR		0x0002		/* R}hs̃fBNgύX */
#define GF_SEARCHHIDDEN	0x0004		/* Bt@Č */
UINT GlobalFlags		= 0;
UINT TempFlags;

/* ΏۃhCu */
char TargetDrives[26+1] = "ABCDE";
char TempDrives[sizeof(TargetDrives)];

/* DOSR}h */
char DefCommand[80]		= "lap %";
char DosCommand[sizeof(DefCommand)];
char TempCommand[sizeof(DefCommand)];

/* Ώۃt@C */
char FileMask[14]		= "";

/* t@CXg̃|C^ */
char *(NameList[512]);

int errno = 0;		/* for findfirst,findnext */


/***************************************************************************
* prototypes
***************************************************************************/

void far DoQuit(void) { Done = TRUE; }
extern LHWINDOW SrchOptDialog;
extern LHWINDOW LnchOptDialog;
extern LHWINDOW AboutDialog;
extern LHWINDOW MainView;
extern LHWINDOW NameDialog;


/***************************************************************************
* Function Keys
***************************************************************************/

LHFKEY CanOkFKeys[] = {
	{ (PLHRES)&msgCancel, (PLHFUNC)CMD_ESC, 9, FKEY_SENDMSG },
	{ (PLHRES)&msgOk, (PLHFUNC)CMD_DONE, 10|FKEY_LAST, FKEY_SENDMSG }
};

LHFKEY OkFKeys[] = {
	{ (PLHRES)&msgOk, (PLHFUNC)CMD_DONE, 10|FKEY_LAST, FKEY_SENDMSG }
};

#define NameOkFKey	(NameFKeys[2])

LHFKEY NameFKeys[] = {
	{ (PLHRES)&msgOption, (PLHFUNC)&SrchOptDialog, 2, FKEY_CREATEWND },
	{ (PLHRES)&msgCancel, (PLHFUNC)CMD_ESC, 9|FKEY_LAST, FKEY_SENDMSG },
	{ (PLHRES)&msgOk, (PLHFUNC)CMD_DONE, 10|FKEY_LAST, FKEY_SENDMSG }
};

LHFKEY OpenFKeys[] = {
	{ (PLHRES)&msgOption, (PLHFUNC)&LnchOptDialog, 2, FKEY_CREATEWND },
	{ (PLHRES)&msgCancel, (PLHFUNC)CMD_ESC, 9, FKEY_SENDMSG },
	{ (PLHRES)&msgOk, (PLHFUNC)CMD_DONE, 10|FKEY_LAST, FKEY_SENDMSG }
};

LHFKEY MainFKeys[] = {
	{ (PLHRES)&msgOption, (PLHFUNC)&LnchOptDialog, 2, FKEY_CREATEWND },
	{ (PLHRES)&msgMask, (PLHFUNC)&NameDialog, 3, FKEY_CREATEWND },
	{ (PLHRES)&msgQuit, (PLHFUNC)CMD_ESC, 9, FKEY_SENDMSG },
	{ (PLHRES)&msgOpen, (PLHFUNC)CMD_DONE, 10|FKEY_LAST, FKEY_SENDMSG }
};


/***************************************************************************
* Menu
***************************************************************************/

LHMENU OptionMenu[] = {
	{ (PLHRES)&msg_Search, (PLHFUNC)&SrchOptDialog, 0, MENU_CREATEWND|MENU_ELLIPSIS },
	{ (PLHRES)&msg_Launch, (PLHFUNC)&LnchOptDialog, 0, MENU_CREATEWND|MENU_ELLIPSIS },
	{ 0, 0, 0, 0 }
};

LHMENU HelpMenu[] = {
	{ (PLHRES)&msg_About, (PLHFUNC)&AboutDialog, 0, MENU_CREATEWND|MENU_ELLIPSIS },
	{ 0, 0, 0, 0 }
};

LHMENU MainMenu[] = {
	{ (PLHRES)&msg_Option, (PLHFUNC)OptionMenu, 0, MENU_PULLDOWN },
	{ (PLHRES)&msg_Quit, (PLHFUNC)DoQuit, 0, 0 },
	{ (PLHRES)&msg_Help, (PLHFUNC)HelpMenu, 0, MENU_PULLDOWN },
	{ 0, 0, 0, 0 }
};


/***************************************************************************
* Misc
***************************************************************************/

#if defined(TURBOC)
void __int__(int interruptnum);
#endif

void PushKey(UINT KeyCode)
{
#if defined(TURBOC)
	_CX = KeyCode;
	_AH = 0x05;
	__int__(0x16);
#elif defined(MSC)
	_asm {
		mov		cx, [KeyCode];
		mov		ah, 0x05;
		int		0x16;
	}
#endif
}

void CopyToClipboard(const char *Data)
{
	m_lock();
	if (m_open_cb() == 0) {
		m_reset_cb("MemUtil");
		m_new_rep("TEXT");
		m_cb_write(Data, strlen(Data));
		m_fini_rep();
		m_close_cb();
	}
	m_unlock();
}

/*
 * ݒt@CȌԂ𕜌
 */
BOOL LoadMyEnvFile(const char *EnvFile)
{
	NBFILE fp;
	int Len;

	if (m_openro(&fp, EnvFile, strlen(EnvFile), 0, 1) != 0)
		return FALSE;
	m_read(&fp, &GlobalFlags, sizeof(GlobalFlags), &Len);
	m_read(&fp, &TargetDrives, sizeof(TargetDrives), &Len);
	m_read(&fp, &DefCommand, sizeof(DefCommand), &Len);
	strcpy(DosCommand, DefCommand);
	m_close(&fp);
	return TRUE;
}

/*
 * ݒt@CɊeݒZ[u
 */
BOOL SaveMyEnvFile(const char *EnvFile)
{
	NBFILE fp;

	if (m_fcreat(&fp, EnvFile, strlen(EnvFile), 0, 1) != 0)
		return FALSE;
	m_write(&fp, &GlobalFlags, sizeof(GlobalFlags));
	m_write(&fp, &TargetDrives, sizeof(TargetDrives));
	m_write(&fp, &DefCommand, sizeof(DefCommand));
	m_close(&fp);
	return TRUE;
}


/***************************************************************************
* Main Title and Clock
***************************************************************************/

LHWINDOW TDateTime = {
	DateTime, 0, 0, 0, 0,
	NULL, NULL, 0, STYLE_DATETIME | STYLE_NOFOCUS,
	NULL, NO_FKEYS, NO_MENU, NO_HELP
};

LHWINDOW MainTitle = {
	TitleBar, 0, 0, 0, 0,
	(PLHRES)&msgAppName, NULL, 0, STYLE_NOFOCUS,
	NULL, NO_FKEYS, (PLHMENU)&TDateTime, NO_HELP
};


/***************************************************************************
* G[o͗p1sbZ[W
***************************************************************************/

/* CMD_ESC,CMD_DONEłI邾̃_CAOnh */
int far DialogHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	if (Msg == COMMAND && Data == CMD_DONE)
		Data = CMD_ESC;
	return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

LHWINDOW MsgDlgArray[] = {
	{ StaticText, 20, 24, 40, 1,
	  NULL, NULL, 40,
	  STYLE_XYRELATIVE | STYLE_WHCHAR | STYLE_NOBORDER | TEXT_CENTER,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	{ PushButton, 180, 50, 70, 14,
	  (PLHRES)&msgOk, (PLHDATA)CMD_DONE, ENTERKEY,
	  STYLE_XYRELATIVE | STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP, STATUS_DEF_PUSHB },
};

LHWINDOW MessageDialog = {
	(PLHCLASS)DialogHandler, 100, 55, 440, 90,
	(PLHRES)&msgError, (PLHDATA)&MsgDlgArray, countof(MsgDlgArray),
	0,
/*	STYLE_SAVEUNDER, */
	NULL, OkFKeys, NO_MENU, NO_HELP
};

void ShowErrMsg(const char *Msg)
{
	m_beep();
	MsgDlgArray[0].Data = (PLHDATA)Msg;
	SendMsg(&MessageDialog, CREATE, CREATE_FOCUS, 0);
}


/***************************************************************************
* About Dialog
***************************************************************************/

LHWINDOW AboutDlgArray[] = {
	{ MessageBox, 130, 55, 380, 80,
	  NULL, (PLHDATA)&msgAboutPtr, 1,
	  MSG_CENTER_LINES | STYLE_NOFOCUS | STYLE_NOBORDER | STYLE_NOSHADOW,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	{ PushButton, 285, 125, 70, 14,
	  (PLHRES)&msgOk, (PLHDATA)CMD_DONE, ENTERKEY,
	  STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP }
};

LHWINDOW AboutDialog = {
	(PLHCLASS)DialogHandler, 120, 25, 400, 150,
	(PLHRES)&msgAbout, (PLHDATA)&AboutDlgArray, countof(AboutDlgArray),
	STYLE_SAVEUNDER,
	NULL, OkFKeys, NO_MENU, NO_HELP
};


/***************************************************************************
* Search Option Dialog
***************************************************************************/

int far SetupDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	switch (Msg) {
	case CREATE:
		TempFlags = GlobalFlags;
		strcpy(TempDrives, TargetDrives);
		strcpy(TempCommand, DefCommand);
		break;
	case COMMAND:
		if (Data == CMD_DONE) {
			GlobalFlags = TempFlags;
			strcpy(TargetDrives, TempDrives);
			strcpy(DefCommand, TempCommand);
			strcpy(DosCommand, DefCommand);
			Data = CMD_ESC;
		}
		break;
	}
	return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

LHWINDOW SrchOptDlgArray[] = {
	/* Target Drives */
	{ Edit, 14, 20, 27, 1,
	  (PLHRES)&msg_Drives, (PLHDATA)TempDrives, sizeof(TempDrives),
	  STYLE_XYRELATIVE | STYLE_WHCHAR | EDIT_INSERT,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* Search Hidden Files */
	{ CheckBox, 14, 42, 30, 1,
	  (PLHRES)&msg_SrchHidn, (PLHDATA)&TempFlags, GF_SEARCHHIDDEN,
	  STYLE_XYRELATIVE | STYLE_WHCHAR,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* OK */
	{ PushButton, 270, 60, 0, 0,
	  (PLHRES)&msgOk, (PLHDATA)CMD_DONE, ENTERKEY,
	  STYLE_XYRELATIVE | STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP, STATUS_DEF_PUSHB },

	/* Cancel */
	{ PushButton, 355, 60, 0, 0,
	  (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, ESCKEY,
	  STYLE_XYRELATIVE | STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP }
};

LHWINDOW SrchOptDialog = {
	(PLHCLASS)SetupDlgHandler, 95, 50, 450, 100,
	(PLHRES)&msgSrchOpt,
	(PLHDATA)&SrchOptDlgArray, countof(SrchOptDlgArray),
	STYLE_SAVEUNDER | STYLE_PUSHB_WIDTH,
	NULL, CanOkFKeys, NO_MENU, NO_HELP
};


/***************************************************************************
* Launch Option Dialog
***************************************************************************/

LHWINDOW LnchOptDlgArray[] = {
	/* DOS Command */
	{ Edit, 14, 20, 25, 1,
	  (PLHRES)&msg_DefCmd, (PLHDATA)&TempCommand, sizeof(TempCommand),
	  STYLE_XYRELATIVE | STYLE_WHCHAR | EDIT_INSERT,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* Exec then Pause */
	{ CheckBox, 14, 42, 30, 1,
	  (PLHRES)&msg_Pause, (PLHDATA)&TempFlags, GF_PAUSE,
	  STYLE_XYRELATIVE | STYLE_WHCHAR,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* Don't ChDir */
	{ CheckBox, 14, 62, 30, 1,
	  (PLHRES)&msg_NoChDir, (PLHDATA)&TempFlags, GF_NOCHDIR,
	  STYLE_XYRELATIVE | STYLE_WHCHAR,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* OK */
	{ PushButton, 270, 52, 0, 0,
	  (PLHRES)&msgOk, (PLHDATA)CMD_DONE, ENTERKEY,
	  STYLE_XYRELATIVE | STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP, STATUS_DEF_PUSHB },

	/* Cancel */
	{ PushButton, 355, 52, 0, 0,
	  (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, ESCKEY,
	  STYLE_XYRELATIVE | STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP }
};

LHWINDOW LnchOptDialog = {
	(PLHCLASS)SetupDlgHandler, 95, 55, 450, 90,
	(PLHRES)&msgLnchOpt,
	(PLHDATA)&LnchOptDlgArray, countof(LnchOptDlgArray),
	STYLE_SAVEUNDER | STYLE_PUSHB_WIDTH,
	NULL, CanOkFKeys, NO_MENU, NO_HELP
};


/***************************************************************************
* File Name Input Dialog
***************************************************************************/

int far EditHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);
int far NameDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);

#define NameOkButton	(NameDlgArray[1])

LHWINDOW NameDlgArray[] = {
	/* File to search */
	{ (PLHCLASS)EditHandler, 14, 24, 13, 1,
	  (PLHRES)&msg_FSearch, (PLHDATA)FileMask, sizeof(FileMask),
	  STYLE_XYRELATIVE | STYLE_WHCHAR | EDIT_INSERT,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* OK */
	{ PushButton, 135, 50, 0, 0,
	  (PLHRES)&msgOk, (PLHDATA)CMD_DONE, ENTERKEY,
	  STYLE_XYRELATIVE|STYLE_PUSHBUTTON|PUSHB_SENDMSG|STYLE_GRAY|STYLE_NOFOCUS,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP, STATUS_DEF_PUSHB },

	/* Cancel */
	{ PushButton, 225, 50, 0, 0,
	  (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, ESCKEY,
	  STYLE_XYRELATIVE | STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP }
};

LHWINDOW NameDialog = {
	(PLHCLASS)NameDlgHandler, 160, 55, 320, 90,
	(PLHRES)&msgFileMask, (PLHDATA)NameDlgArray, countof(NameDlgArray),
	STYLE_SAVEUNDER | STYLE_PUSHB_WIDTH,
	NULL, NameFKeys, MainMenu, NO_HELP
};

int far EditHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	BOOL Last, IsNull;
	int Result;

	Last = (*(Wnd->Data) == '\0');
	Result = SubclassMsg(Edit, Wnd, Msg, Data, Extra);
	IsNull = (*(Wnd->Data) == '\0');
	if (Msg == KEYSTROKE && Last != IsNull) {
		if (IsNull)	{
			(&NameOkFKey)[-1].KeyNum |= FKEY_LAST;
			NameOkButton.Style |= (STYLE_NOFOCUS | STYLE_GRAY);
		} else {
			(&NameOkFKey)[-1].KeyNum &= ~FKEY_LAST;
			NameOkButton.Style &= ~(STYLE_NOFOCUS | STYLE_GRAY);
		}
		SendMsg(&NameOkButton, DRAW, DRAW_ALL, 0);
		DrawFKeys(&NameDialog, FKEY_ALONE);
	}
	return Result;
}

BOOL AnyFileMarked(void)
{
	int i;

	for (i=0; i<MainView.LogicalSize; ++i)
		if (((char **)MainView.Data)[i][0] == MARKCHAR)
			return TRUE;
	return FALSE;
}

/*
 * v\
 */
void ShowSandGlass(void)
{
	static BYTE SandGlass[] = {
		1,0, 1,0, 24,0, 26,0,
		0x00, 0x00, 0x00,	/* 00000000 00000000 00000000 */
		0x3F, 0xFF, 0xFE,	/* 00111111 11111111 11111110 */
		0x3F, 0xFF, 0xFE,	/* 00111111 11111111 11111110 */
		0x10, 0x00, 0x04,	/* 00010000 00000000 00000100 */
		0x10, 0x00, 0x04,	/* 00010000 00000000 00000100 */
		0x10, 0x00, 0x04,	/* 00010000 00000000 00000100 */
		0x08, 0x00, 0x08,	/* 00001000 00000000 00001000 */
		0x08, 0x00, 0x08,	/* 00001000 00000000 00001000 */
		0x05, 0xFF, 0xD0,	/* 00000101 11111111 11010000 */
		0x02, 0x7F, 0x20,	/* 00000010 01111111 00100000 */
		0x01, 0x9C, 0xC0,	/* 00000001 10011100 11000000 */
		0x00, 0x6B, 0x00,	/* 00000000 01101011 00000000 */
		0x00, 0x14, 0x00,	/* 00000000 00010100 00000000 */
		0x00, 0x14, 0x00,	/* 00000000 00010100 00000000 */
		0x00, 0x63, 0x00,	/* 00000000 01100011 00000000 */
		0x01, 0x88, 0xC0,	/* 00000001 10001000 11000000 */
		0x02, 0x08, 0x20,	/* 00000010 00001000 00100000 */
		0x04, 0x08, 0x10,	/* 00000100 00001000 00010000 */
		0x08, 0x1C, 0x08,	/* 00001000 00011100 00001000 */
		0x08, 0x7F, 0x08,	/* 00001000 01111111 00001000 */
		0x11, 0xFF, 0xC4,	/* 00010001 11111111 11000100 */
		0x13, 0xFF, 0xE4,	/* 00010011 11111111 11100100 */
		0x10, 0x00, 0x04,	/* 00010000 00000000 00000100 */
		0x3F, 0xFF, 0xFE,	/* 00111111 11111111 11111110 */
		0x3F, 0xFF, 0xFE,	/* 00111111 11111111 11111110 */
		0x00, 0x00, 0x00,	/* 00000000 00000000 00000000 */
	};

	G_ImagePut((640-24)/2, (200-26)/2, SandGlass, 0);
}

int SearchFiles(const char *Dir)
{
	FFBLK ff;
	char FindPath[MAXPATH];
	int Attr;

	/* ̃fBNg̊Yt@CT */
	strcat(strcat(strcpy(FindPath, Dir), "\\"), FileMask);
	Attr = FA_RDONLY | FA_SYSTEM | FA_ARCH;
	if (GlobalFlags & GF_SEARCHHIDDEN) Attr |= FA_HIDDEN;
	if (findfirst(FindPath, &ff, Attr) == 0) {
		do {
			if (MainView.LogicalSize >= countof(NameList)) return FALSE;
			if ((NameList[MainView.LogicalSize] = m_alloc(1+strlen(Dir)+1+strlen(ff.ff_name)+1)) == NULL)
				return FALSE;
			NameList[MainView.LogicalSize][0] = ' ';
			strcat(strcat(strcpy(NameList[MainView.LogicalSize]+1, Dir), "\\"), ff.ff_name);
			strlwr(NameList[MainView.LogicalSize++]+1);
		} while (findnext(&ff) == 0);
	}

	/* TufBNgT */
	strcat(strcpy(FindPath, Dir), "\\*.*");
	Attr |= FA_DIREC;
	if (findfirst(FindPath, &ff, Attr) == 0) {
		do {
			if ((ff.ff_attrib & FA_DIREC) == 0 || ff.ff_name[0] == '.')
				continue;
			strcat(strcat(strcpy(FindPath, Dir), "\\"), ff.ff_name);
			if (!SearchFiles(FindPath)) return FALSE;
		} while (findnext(&ff) == 0);
	}
	return TRUE;
}

int far NameDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	int i;
	char Drive[3];

	switch (Msg) {
	case COMMAND:
		switch (Data) {
		case CMD_ESC:
			if (MainView.LogicalSize == 0) Done = TRUE;
			break;
		case CMD_DONE:
			/* NameDialog */
			SendMsg(Wnd, DESTROY, DESTROY_NORMAL, 0);
			/* v\ */
			ShowSandGlass();
			/* XggĂJ */
			while (MainView.LogicalSize)
				m_free(NameList[--MainView.LogicalSize]);
			/* ΏۃhCũt@C */
			MainView.Selection = 0;
			for (i=0; i<strlen(TargetDrives); i++) {
				Drive[0] = TargetDrives[i];
				Drive[1] = ':';
				Drive[2] = '\0';
				if (!SearchFiles(Drive)) {
					SendMsg(&MainView, DRAW, DRAW_CLIENT, 0);
					ShowErrMsg("Too many files.");
					return TRUE;
				}
			}
			/* 1Ȃ̓G[bZ[Wo */
			if (MainView.LogicalSize == 0) {
				SendMsg(&MainView, DRAW, DRAW_CLIENT, 0);
				SendMsg(Wnd, CREATE, CREATE_FOCUS, 0);
				ShowErrMsg("No such file.");
				return TRUE;
			}
			SendMsg(&MainView, DRAW, DRAW_CLIENT, 0);
			return TRUE;
		}
		break;
	}
	return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}


/***************************************************************************
* Open Dialog
***************************************************************************/

int far OpenDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);

LHWINDOW OpenDlgArray[] = {
	/* Command Line */
	{ Edit, 14, 20, 28, 1,
	  (PLHRES)&msg_CmdLine, (PLHDATA)&DosCommand, sizeof(DosCommand),
	  STYLE_XYRELATIVE | STYLE_WHCHAR | EDIT_INSERT,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* OK */
	{ PushButton, 270, 45, 0, 0,
	  (PLHRES)&msgOk, (PLHDATA)CMD_DONE, ENTERKEY,
	  STYLE_XYRELATIVE | STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP, STATUS_DEF_PUSHB },

	/* Cancel */
	{ PushButton, 355, 45, 0, 0,
	  (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, ESCKEY,
	  STYLE_XYRELATIVE | STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP }
};

LHWINDOW OpenDialog = {
	(PLHCLASS)OpenDlgHandler, 95, 60, 450, 80,
	(PLHRES)&msgOpenFile, (PLHDATA)OpenDlgArray, countof(OpenDlgArray),
	STYLE_SAVEUNDER | STYLE_PUSHB_WIDTH,
	NULL, OpenFKeys, MainMenu, NO_HELP
};


void OpenFile(const char *filename)
{
	static EXEC_STRUCT Exec = { "d:\\dos\\command.com", 0, 0xFFFF, FALSE, 0 };
	char s[MAXPATH];
	int i;

	/* JgfBNgύX */
	if ((GlobalFlags & GF_NOCHDIR) == 0) {
		strcpy(s, filename);
		for (i=strlen(s); s[i]!='\\'; --i)
			;
		if (s[i-1] == ':') ++i;
		s[i] = '\0';
		m_setdrv(s[0]);
		m_setdir(s, strlen(s));
	}

	/* R}hC쐬 */
	strcpy(s, "/C");
	for (i=0; DosCommand[i]!='\0' && DosCommand[i]!='%'; ++i)
		s[2+i] = DosCommand[i];
	s[2+i] = '\0';
	if (DosCommand[i] == '%')
		strcat(strcat(s, filename), &DosCommand[i+1]);
	else
		strcat(strcat(s, " "), filename);

	/* s */
	Exec.ex_command_line = s;
	Exec.ex_pause = ((GlobalFlags & GF_PAUSE) != 0);
	Event.execf.exec_struc_ptr = &Exec;
	Event.norm.do_event = DO_EXEC_FULL;
	m_action(&Event);
	FixupFarPtrs();
}

int far OpenDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	int i;

	if (Msg == COMMAND && Data == CMD_DONE) {
		SendMsg(Wnd, DESTROY, DESTROY_NORMAL, 0);
		DeactivateLHAPI();
		if (AnyFileMarked()) {
			for (i=0; i<MainView.LogicalSize; ++i) {
				if (((char **)MainView.Data)[i][0] == MARKCHAR)
					OpenFile(&((char **)MainView.Data)[i][1]);
			}
		} else
			OpenFile(((char **)MainView.Data)[MainView.Selection]+1);
		ReactivateLHAPI(&LHAPIData);
		return TRUE;
	}
	return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}


/***************************************************************************
* Main Dialog
***************************************************************************/

int far MainViewHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);

LHWINDOW MainView = {
	(PLHCLASS)MainViewHandler, 0, 8, 640, 182,
	NULL, (PLHDATA)&NameList, 0, 0,
	NULL, MainFKeys, MainMenu, NO_HELP
};

int far MainViewHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	char Mask;
	int i;

	switch (Msg) {
	case KEYSTROKE:
		switch (Data) {
		case ENTERKEY:
			return SendMsg(Wnd, COMMAND, CMD_DONE, 0);
		case ESCKEY:
			return SendMsg(Wnd, COMMAND, CMD_ESC, 0);
		case SPACEKEY:
			if (ShiftPressed()) {
				if (AnyFileMarked())	Mask = ' ';
				else					Mask = MARKCHAR;
				for (i=0; i<Wnd->LogicalSize; ++i)
					((char **)Wnd->Data)[i][0] = Mask;
			} else {
				if (((char **)Wnd->Data)[Wnd->Selection][0] == ' ')
					((char **)Wnd->Data)[Wnd->Selection][0] = MARKCHAR;
				else
					((char **)Wnd->Data)[Wnd->Selection][0] = ' ';
				SendMsg(Wnd, KEYSTROKE, DOWNKEY, 0);
			}
			return SendMsg(Wnd, DRAW, DRAW_CLIENT, 0);
		case COPYKEY:
			CopyToClipboard(NameList[MainView.Selection] + 1);
			return TRUE;
		case CUTKEY:
			CopyToClipboard(NameList[MainView.Selection] + 1);
			PushKey(PASTEKEY);
			Done = TRUE;
			return TRUE;
		case '*':
			return SendMsg(&NameDialog, CREATE, CREATE_FOCUS, 0);
		case RIGHTKEY:
			Data = PAGEDOWNKEY;
			break;
		case LEFTKEY:
			Data = PAGEUPKEY;
			break;
		}
		break;
	case COMMAND:
		switch (Data) {
		case CMD_ESC:
			Done = TRUE;
			return TRUE;
		case CMD_DONE:
			return SendMsg(&OpenDialog, CREATE, CREATE_FOCUS, 0);
		}
		break;
	}
	return SubclassMsg(ListBox, Wnd, Msg, Data, Extra);
}


/***************************************************************************
* Main
***************************************************************************/

void main(void)
{
	m_init_app(SYSTEM_MANAGER_VERSION);
	m_reg_app_name(msgAppName);
	InitializeLHAPI(&LHAPIData);
	SetDefaultFont(FONT_NORMAL);

	/* ̊ݒt@Cǂ */
	if (!LoadMyEnvFile(MyEnvPath)) {
		MyEnvPath[0] = 'c';
		LoadMyEnvFile(MyEnvPath);
	}

	/* Cʂ\ */
	SendMsg(&MainView, CREATE, CREATE_FOCUS, 0);
	SendMsg(&MainTitle, CREATE, CREATE_NORMAL, 0);
	SendMsg(&NameDialog, CREATE, CREATE_FOCUS, 0);

	do {
		Event.norm.do_event = DO_EVENT;
		m_action(&Event);
		switch(Event.norm.kind) {
		case E_ACTIV:
		case E_REFRESH:
			FixupFarPtrs();
			ReactivateLHAPI(&LHAPIData);
			break;
		case E_DEACT:
			DeactivateLHAPI();
			break;
		case E_TERM:
			FixupFarPtrs();
			Done = TRUE;
			break;
		case E_KEY:
			SendFocusMsg(KEYSTROKE, Event.norm.data, Event.norm.scan);
			break;
		case E_NONE:
			SendMsg(&TDateTime, DRAW, DRAW_ALL, 0);
			break;
		}
	} while (!Done);

	SaveMyEnvFile(MyEnvPath);

	Event.norm.do_event = DO_FINI;
	m_action(&Event);
}
