'/* BUBLSORT.BAS  rev. 11.11.97 */

' ------------------------------------------------------------
' Performance times for bubble sort, Shell sort, and Quicksort
'
' Computer: Generic PC; 90 mhz Pentium
'
' List of 1400 single-precision numbers:
'
'         Unsorted (random) list   Reverse-sorted list
'         ----------------------   -------------------
'
' BS:              25.00 seconds         25.00 seconds
'
' SS:               0.55 seconds          0.44 seconds
'
' QS:               0.40 seconds         22.00 seconds
'
' List of 2800 single-precision numbers:
'
'         Unsorted (random) list   Reverse-sorted list
'         ----------------------   -------------------
'
' BS:                 Not tested            Not tested
'
' SS:               1.34 seconds          1.00 seconds
'
' QS:               1.15 seconds        103.00 seconds
'
' Time-increase factor from 1400 items to 2800 items:
'
' SS:               2.44 times            2.27 times
'
' QS:               2.88 times            4.68 times
'
' Observation: Shell sort was 37.5% slower on the first-run
'              test, but only 16.5% slower on the second test.
'              Quicksort is like a bubble sort for lists that
'              are already sorted in reverse order.
' ------------------------------------------------------------

'$include: 'basdef.h'
'$include: 'gettime.h'
'$include: 'messages.h'
'$include: 'midchar.h'

declare function sortdata(fval(), itot)
declare function sortdata2(fval(), itot)
declare function printdata(fval(), itot, icmp, indx)

'$include: 'basdef.bas'
'$include: 'gettime.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'

dim fval(1399)
itot = 1399
for i = 1 to itot
   fval(i) = rnd * 10
next

open "bublsort.log" for output as 1

i = ifn.msgs("Sorting original list", 5, 25, 80, 0, 0)
i = ifn.tbeg(cbeg, cend, cexp, ltic)
i = sortdata(fval(), itot)
i = ifn.tend(cbeg, cend, cexp, ltic)
i = ifn.msgs(cbeg + " " + cend + " " + cexp, 5, 25, 80, 0, 0)
icmpascend = not 0                              'check list for ascending order
i = printdata(fval(), itot, icmpascend, 1)

i = ifn.msgs("Reversing sorted list", 5, 25, 80, 0, 0)
for i = 1 to itot \ 2                      'use 0 to itot \ 2 - 1 for sortdata2
   swap fval(i), fval(itot - i + 1)       'use fval(itot - i - 1) for sortdata2
next
icmpascend = 0                                 'check list for descending order
i = printdata(fval(), itot, icmpascend, 1)

i = ifn.msgs("Sorting reversed list", 5, 25, 80, 0, 0)
i = ifn.tbeg(cbeg, cend, cexp, ltic)
i = sortdata(fval(), itot)
i = ifn.tend(cbeg, cend, cexp, ltic)
i = ifn.msgs(cbeg + " " + cend + " " + cexp, 5, 25, 80, 0, 0)
icmpascend = not 0                              'check list for ascending order
i = printdata(fval(), itot, icmpascend, 1)

i = ifn.msgs("Sorting zero-based index list", 5, 25, 80, 0, 0)
for i = 0 to itot - 1
   fval(i) = fval(i + 1)
next
i = ifn.tbeg(cbeg, cend, cexp, ltic)
i = sortdata2(fval(), itot)
i = ifn.tend(cbeg, cend, cexp, ltic)
i = ifn.msgs(cbeg + " " + cend + " " + cexp, 5, 25, 80, 0, 0)
icmpascend = not 0                              'check list for ascending order
i = printdata(fval(), itot, icmpascend, 0)

close
system

'*******************************************************
'Note: The following is the complete bubble sort routine
'*******************************************************
function sortdata(fval(), itot)
   for ilap = 1 to itot - 1
      for itap = ilap + 1 to itot
         if fval(ilap) > fval(itap) then
            swap fval(ilap), fval(itap)
         end if
      next
   next
end function

'**********************************************************************
'Note: sortdata2 is same as sortdata, but sorts zero-based-index arrays
'      itot is the total of elements, not the upper bound of the array
'**********************************************************************
function sortdata2(fval(), itot)
   for ilap = 0 to itot - 2
      for itap = ilap + 1 to itot - 1
         if fval(ilap) > fval(itap) then
            swap fval(ilap), fval(itap)
         end if
      next
   next
end function

'***********************************************************
'Note: This is the output section of the bubble sort routine
'***********************************************************
function printdata(fval(), itot, icmp, indx)
   locate 7, 5, 0
   print "Press any key to list each element,"
   locate 8, 5, 0
   print "or press ESC to skip this listing."
   do
      ckey = inkey$
   loop while ckey = ""
   if ckey = char(27) then
      idsp = 0
   else
      idsp = not 0
      print
   end if
   for i = indx to itot - abs(indx = 0)
      if i < itot - abs(indx = 0) then         '...so that (i + 1) is in bounds
         if icmp then                           'check list for ascending order
            if fval(i) > fval(i + 1) then
               beep
            end if
         else                                  'check list for descending order
            if fval(i) < fval(i + 1) then
               beep
            end if
         end if
      end if
      if idsp then
         print using "##.####"; fval(i)
         do
            ckey = inkey$
         loop while ckey = ""
         if ckey = char(27) then
            idsp = 0
         end if
      end if
      print #1, using "##.####"; fval(i)
   next
   print #1, "--------"
end function
