'/* CALLIST1.BAS Create procedure list from BASIC source files */
'/*              By: Dale Thorn                                */
'/*              Rev. 10.07.2002                               */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'getline.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'string.h'

declare function io.ktst(inop)

'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'getline.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'string.bas'

dim clinbuf(24)                           'initialize a code lines parser array

iremdup = (ucase$(rtrim$(command$)) = "/R") 'user said OK to remove dupl.files?

imaxcmdlen = 24                           'set the maximum BASIC command length
for i = 1 to imaxcmdlen                   'loop thru the code line parser array
   clinbuf(i) = space$(i)                 'set each element to its no.of spaces
next
cbyteposn = space$(8)                        'initialize proc.byte-posn. buffer
cfilename = space$(60)                       'initialize sourcefile name buffer
cprocname = space$(60)                        'initialize procedure name buffer

i = ifn.msgs("Building Sub/Function procedure list - Please standby", _
             5, 24, 79, 0, 0)     'display user message and continue processing

i = ifn.kill(1, "x1.tx2")                       'kill temp. source file list #2
i = ifn.kill(1, "x1.tx3")                       'kill temp. source file list #3
i = ifn.kill(1, "x1.tx4")                       'kill temp. source file list #4
shell "dir *.bas /s  > x1.tx1"                 'add ".bas" files to source list
shell "dir *.cls /s >> x1.tx1"                 'add ".cls" files to source list
shell "dir *.dh? /s >> x1.tx1"                 'add ".dh?" files to source list
shell "dir *.frm /s >> x1.tx1"                 'add ".frm" files to source list
shell "dir *.sub /s >> x1.tx1"                 'add ".sub" files to source list
shell "dir2name x1.tx1 /N"                    'build tree from source file list
name "x1.out" as "x1.tx2"                     'rename "x1.out" file to "x1.tx2"
open "x1.tx2" for input as 1                   'open tree from source file list
line input #1, clin                           'read a line from the source list
ilinlen = len(clin)                             'get actual length of text line
ircdlen = ilinlen + 2                         'binary file access record length
imaxlen = ilinlen - 27                         'set maximum length of text line
close 1                                       'close tree from source file list
shell "srtf x1.tx2 " + ltrim$(str$(imaxlen - 12)) + " 12 " + _
                       ltrim$(str$(imaxlen + 11)) + " 16 /R/NO" 'sort file list
name "x1.out" as "x1.tx3"                     'rename "x1.out" file to "x1.tx3"
if iremdup then                              'user said OK to remove dupl.files
   shell "rdup x1.tx3 " + ltrim$(str$(imaxlen - 12)) + " 12 /N"'kill duplicates
   name "x1.out" as "x1.tx4"                  'rename "x1.out" file to "x1.tx4"
else                                        'user said do NOT remove dupl.files
   shell "copy x1.tx3 x1.tx4 > nul"        'just copy "x1.tx3" file to "x1.tx4"
end if
open "x1.tx4" for binary as 1                 'open the user's master file list
open "callist1.txt" for output as 2            'open procedure list output file
lrcdtot = lof(1) \ ircdlen                     'number of files to be processed
crcdtot = ltrim$(str$(lrcdtot))                'number of files (string format)
itotlen = len(crcdtot)                          'length of above counter string
ctotmsg = "Processing file " + space$(itotlen) + " of " + crcdtot + " files"

i = ifn.msgs(ctotmsg, 5, 24, 79, 0, 0) 'display user msg. & continue processing

cbuf1 = space$(ircdlen)                     'initialize master file list buffer
cbuf3 = space$(600)                          'initialize the source code buffer
for lfilcnt = 1 to lrcdtot                    'loop thru source file list lines
   lpos1 = clng(lfilcnt - 1) * ircdlen + 1   'set pointer to next read position
   i = ifn.getline(cbuf1, cfil, lpos1, 1, 0, 0)'get the current source filespec
   cfil = left$(cfil, imaxlen)               'remove size/date/time info f/line
   mid$(cfil, imaxlen - 3) = "."               'add extension separator to line
   do                                        'begin loop to remove blank spaces
      ipos1 = instr(cfil, " ")                'is blank space in filename line?
      if ipos1 then                         'blank space found in filename line
         cfil = left$(cfil, ipos1 - 1) + mid$(cfil, ipos1 + 1)'remv.blank space
      else                              'blank space NOT found in filename line
         exit do                          'blank space NOT found; exit loop now
      end if
   loop
   rset crcdtot = ltrim$(str$(lfilcnt))        'format the current file counter
   locate 5, 21, 0                              'locate cursor for file counter
   print crcdtot;                             'display the current file counter
   open cfil for binary as 3                   'open file from source file list
   ieof3 = 0                                   'initialize loop value for below
   lpos3 = 1                                 'initialize current file byte posn.
   while not ieof3                           'loop thru user's source-code file
      i = ifn.getline(cbuf3, clin, lpos3, 3, 0, ieof3) 'get current source line
      i = ifn.rtab(clin, 1)                   'remove any "hard" tabs from line
      lset cbuf3 = ltrim$(clin)               'left-justify text line in buffer
      i = istr.rcmt(cbuf3)                     'remove BASIC comments from line
      lset clinbuf(imaxcmdlen) = ucase$(cbuf3)'put text line->top parse element
      for i = imaxcmdlen to 5 step -1         'loop thru code line parser array
         lset clinbuf(i - 1) = clinbuf(i)     'text line -> curr.parser element
      next
      for i = imaxcmdlen to 4 step -1         'loop thru code line parser array
         select case clinbuf(i)               'select on potential BASIC syntax
            case "PRIVATE STATIC FUNCTION ", _'current line begins FUNCTION proc.
                 "PUBLIC STATIC FUNCTION ", _'current line begins FUNCTION proc.
                 "PRIVATE STATIC SUB ", _    'current line begins SUB procedure
                 "PUBLIC STATIC SUB ", _     'current line begins SUB procedure
                 "PRIVATE FUNCTION ", _      'current line begins FUNCTION proc.
                 "PUBLIC FUNCTION ", _       'current line begins FUNCTION proc.
                 "STATIC FUNCTION ", _       'current line begins FUNCTION proc.
                 "PRIVATE SUB ", _           'current line begins SUB procedure
                 "STATIC SUB ", _            'current line begins SUB procedure
                 "PUBLIC SUB ", _            'current line begins SUB procedure
                 "FUNCTION ", _              'current line begins FUNCTION proc.
                 "SUB "                      'current line begins SUB procedure
               ipos1 = istr.lcsp(i, cbuf3, " ")   'begin posn.of procedure name
               ipos2 = instr(ipos1, cbuf3, "(")'paren posn.after procedure name
               if ipos2 then                  'paren.found after procedure name
                  ipos3 = istr.rcsp(ipos2 - 1, cbuf3, " ")'end of procedure name
                  if instr("!#$%&", char(midchar(cbuf3, ipos3))) then'BASIC type
                     ipos3 = ipos3 - 1    'eliminate BASIC type char.f/procname
                  end if
                  lset cprocname = mid$(cbuf3, ipos1, ipos3 - ipos1 + 1)
                  lset cfilename = cfil  'set procname/filename to fixed length
                  rset cbyteposn = ltrim$(str$(lpos3)) 'begin posn.of next line
                  if left$(clinbuf(i), 7) = "PRIVATE" then 'procedure="PRIVATE"
                     print #2, cprocname; cfilename; "Priv"; cbyteposn
                  else                                      'procedure="PUBLIC"
                     print #2, cprocname; cfilename; "Publ"; cbyteposn
                  end if
               end if
               exit for                      'code line matches case; exit loop
            case else                            'not valid for this loop index
         end select
      next
      if io.ktst(0) = 27 then                         'user pressed the ESC key
         i = ifn.msgs("ESC key selected - program aborted", 5, 24, 79, 0, 1)
      end if                  'user pressed ESC; abort and exit program [above]
   wend
   close 3                                    'close file from source file list
next
close                                         'close all open files before sort

i = ifn.msgs("Sorting output text file - Please standby", _
             5, 24, 79, 0, 0)     'display user message and continue processing

shell "srtf Callist1.txt 0 124 /NO"            'sort procedure list output file
i = ifn.kill(1, "Callist1.txt")              'kill unsorted procedure list file
name "Callist1.out" as "Callist1.txt"      'rename sorted file to original name

i = ifn.msgs("Output file: Callist1.txt", 5, 24, 79, 0, 1) 'disp.message & exit
close                                 'close all files in case not closed above
system                                  'return control to the operating system

function io.ktst(inop)                              ' return last key (no wait)
   ckey = inkey$                                      ' get key from key buffer
   if ckey <> "" then                               ' key buffer contains a key
      if asc(ckey) then                               ' key value in first byte
         inop = asc(ckey)                                 ' key value to return
      else                                        ' zero value ("extended" key)
         inop = asc(mid$(ckey, 2)) + 128           ' add 128 to 2nd byte of key
      end if
   else                                     ' key buffer does NOT contain a key
      inop = 0                                   ' set return key value to zero
   end if
   io.ktst = inop                         ' return key value to calling program
end function
