Unit HPLX;
{Pavel Zampach, 2002, zampach@volny.cz}

interface

CONST
  Alka =0;
  NiCd =1;

{Returns TRUE if program runs on HPxxLX}
Function Hpx :boolean;

{Functions return voltage (in Volts) of main or backup battery}
Function Main_batt :real;
Function Back_batt :real;

{Procedures for charging control}
Procedure Enable_charging;
Procedure Disable_charging;

{Sets battery type ("Alka" or "NiCd"), "Alka" also disables charging}
Procedure Set_batt (Batt_type :byte);

{Sets contrast of display (0..15)}
Procedure Set_Contrast (Contr :byte);

{Sets volume of beeper (0..3)}
Procedure Set_Volume (Vol :byte);

{Procedures for setting display resolution}
Procedure Mode80x25;
Procedure Mode64x18;
Procedure Mode40x25;
Procedure Mode40x16;

{Procedures for setting serial port}
Procedure Port_Infrared;
Procedure Port_Wire;
Procedure Port_Off;

{Sets timeout in sec. (max. 3600)}
Procedure Set_Timer (secs :word);

{-----------------------------------------------------------------------------------}
implementation

USES  dos;

VAR     r:registers;

Function Hpx :boolean;
begin
  r.AX:=$4DD4;
  Intr($15,r);
  Hpx:=r.BX=$4850;
end;

Function Main_batt :real;
begin
  r.AX:=$6000;
  intr ($15,r);
  Main_batt:=r.AX*0.02746+1.57
end;

Function Back_batt :real;
begin
  r.AX:=$6001;
  intr ($15,r);
  Back_batt:=r.AX*0.02746+1.57
end;

Procedure Enable_charging;
begin
  r.BX:=1;
  r.AX:=$6004;
  intr ($15,r);
end;

Procedure Disable_charging;
begin
  r.BX:=0;
  r.AX:=$6004;
  intr ($15,r);
end;

Procedure Set_batt (Batt_type :byte);
begin
  IF Batt_type=Alka THEN Disable_charging;
  r.BL:=Batt_type;
  r.AX:=$6003;
  intr ($15,r);
end;

Procedure Set_Contrast (Contr :byte);
begin
  r.BL:=Contr;
  r.AX:=$4700;
  intr ($15,r);
end;

Procedure Set_Volume (Vol :byte);
begin
  r.AL:=Vol;
  r.AH:=$48;
  intr ($15,r);
end;

Procedure Mode80x25;
begin
  r.AX:=$D003;
  intr ($10,r);
end;

Procedure Mode64x18;
begin
  r.AX:=$D081;
  intr ($10,r);
end;

Procedure Mode40x25;
begin
  r.AX:=$D083;
  intr ($10,r);
end;

Procedure Mode40x16;
begin
  r.AX:=$D085;
  intr ($10,r);
end;

Procedure Port_Infrared;
begin
  r.AX:=$4A01;
  intr ($15,r);
  r.AX:=$4901;
  intr ($15,r);
end;

Procedure Port_Wire;
begin
  r.AX:=$4A01;
  intr ($15,r);
  r.AX:=$4900;
  intr ($15,r);
end;

Procedure Port_Off;
begin
  r.AX:=$4A00;
  intr ($15,r);
end;

Procedure Set_Timer (secs :word);

VAR a :longint;
begin
  a:=(secs*182) div 10;
  r.BX:=word (a);
  r.AH:=$46;
  intr ($15,r);
end;

end.