/*
 * PWCBSD - Philips USB webcam driver for FreeBSD 5.4 and higher
 *
 *  Copyright (C) 2006 Raaf 
 *
 * Based on the Linux pwc driver.
 *  
 *  Copyright (C) 1999-2003 Nemosoft Unv.
 *  Copyright (C) 2004-2006 Luc Saillard
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301  USA
 */

#include "pwc.h"
#include "pwc-uncompress.h"
#include "pwc-dec1.h"
#include "pwc-dec23.h"

int pwc_decompress(struct pwc_softc *pdev, unsigned char *yuv, unsigned char *image, int srclen)
{
	int n, line, col, stride;

	if (pdev->vbandlength == 0) {
		u_int16_t *src;
		u_int16_t *dsty, *dstu, *dstv;
		/* Uncompressed mode. We copy the data into the output buffer,
		   using the viewport size (which may be larger than the image
		   size). Unfortunately we have to do a bit of byte stuffing
		   to get the desired output format/size.
		 */
			/*
			 * We do some byte shuffling here to go from the
			 * native format to YUV420P.
			 */
			src = (u_int16_t *)yuv;
			n = pdev->view.x * pdev->view.y;

			/* offset in Y plane */
			stride = pdev->view.x * pdev->offset.y + pdev->offset.x;
			dsty = (u_int16_t *)(image + stride);

			/* offsets in U/V planes */
			stride = pdev->view.x * pdev->offset.y / 4 + pdev->offset.x / 2;
			dstu = (u_int16_t *)(image + n +         stride);
			dstv = (u_int16_t *)(image + n + n / 4 + stride);

			/* increment after each line */
			stride = (pdev->view.x - pdev->image.x) / 2; /* u16 is 2 bytes */

			for (line = 0; line < pdev->image.y; line++) {
				for (col = 0; col < pdev->image.x; col += 4) {
					*dsty++ = *src++;
					*dsty++ = *src++;
					if (line & 1)
						*dstv++ = *src++;
					else
						*dstu++ = *src++;
				}
				dsty += stride;
				if (line & 1)
					dstv += (stride >> 1);
				else
					dstu += (stride >> 1);
			}
	}
	else {
		/* Compressed; the decompressor routines will write the data
		   in planar format immediately.
		 */
		int flags;
                
                flags = PWCX_FLAG_PLANAR;
                if (pdev->vsize == PSZ_VGA && pdev->vframes == 5 && pdev->vsnapshot) {
		   printf("pwc: Mode Bayer is not supported for now\n");
		   flags |= PWCX_FLAG_BAYER;
		   return -ENXIO; /* No such device or address: missing decompressor */
		 }

		switch (pdev->pwc_info.type) {
		  case 675:
		  case 680:
		  case 690:
		  case 720:
		  case 730:
		  case 740:
		  case 750:
		    pwc_dec23_decompress(&pdev->image, &pdev->view, &pdev->offset,
				yuv, image,
				flags,
				pdev->decompress_data, pdev->vbandlength);
		    break;
		  case 645:
		  case 646:
		    /* TODO & FIXME */
		    printf("pwc: This chipset is not supported for now\n");
		    return -ENXIO; /* No such device or address: missing decompressor */
		    break;
		 }
	}
	return 0;
}


