#ifndef THREAD_H
#define THREAD_H

#include <stdlib.h>
#include <string.h>

#define RUNNING     0
#define READY       1
#define BLOCKED     2
#define CREATED     3
#define NULL        0

struct thread
{
    unsigned int regs[9];
    int *stack;
    int threadstatus;
    unsigned int TID;
    struct sigaction (*signals)[10];
};

unsigned int bigtid;  /* a cheezy way to keep up with the highest tid
                         but faster than searching the list */
unsigned int MAXINT;

struct thread * CreateThread(void (*torun) (void *), void *par);

void KillThread(void);
void yield(void);
unsigned int gettid(struct thread *tidfor);

void kill_(void);
#endif
