/* FROMUNIX.C - miscellaneous Unix functions for MS-DOS (many rather useless)
 ******************************************************************************
 *
 * int		  getgid()
 * int		  getegid()
 * int		  getuid()
 * int		  geteuid()
 * int		  chown(char *file, int user, int group)
 * struct group * getgrgid(int gid)
 * struct group * getgrnam(char *name)
 * void		  endgrent()
 * struct passwd *getpwuid(int uid)
 * struct passwd *getpwnam(char *name)
 * void		  endpwent()
 * int		  statfs(const char *path, struct statfs *buf)
 * FILE *	  setmntent(char *filename, char *type)
 * struct mntent *getmntent(FILE *filep)
 * int		  endmntent(FILE *filep)
 * void		  sync()
 *
 ******************************************************************************
 * edit history is at the end of the file
 ******************************************************************************
 * Copyright 1995 by the Summer Institute of Linguistics, Inc.
 *
 * This file is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; see the file COPYING.LIB.  If
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 * Cambridge, MA 02139, USA.
 */
#include <stdlib.h>		/* For getenv() */
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>		/* For errno */
#include <dos.h>		/* For _dos_getdiskfree(), ... */
#include <direct.h>
#include <time.h>

#include "grp.h"
#include "pwd.h"
#include "statfs.h"
#include "ndir.h"		/* Microsoft C has an unrelated <direct.h> */
#include "mntent.h"

#define NUL '\0'
/*
 *  BDOS function codes
 */
#define SEARCHFIRST	 0x1100		/* search for first entry */
#define	SETDTA		 0x1A00		/* set disk transfer address */
#define DRIVEDATA	 0x1C00		/* get drive data */
#define GETDTA		 0x2F00		/* get disk transfer address */
#define DOSVERSION	 0x30		/* get MS-DOS version number */
#define IOCTL_CHANGEABLE 0x4408		/* IOCTL - is changeable */
#define	FINDFIRST	 0x4E00		/* find first file */
#define	FINDNEXT	 0x4F00		/* find next file */
#define GETLISTS	 0x5200		/* (internal) get list of lists */

#define ALL_FILES_DIRS	0x16	/* directory + system + hidden */

static char groupname[20] = "other\0\0\0\0\0\0\0\0\0\0\0\0\0\0";
static char username[20]  = "dosuser\0\0\0\0\0\0\0\0\0\0\0\0\0";
static struct group gr = { groupname, 1 };
static struct passwd pw = { username, 1, 1 };

/*
 *  the following magic is based on the INTERRUPT list maintained by
 *  Ralf Brown and distributed by the Simtel MS-DOS archives
 */
#pragma pack(1)
struct dos3_cds		/* MS-DOS version 3.x Current Directory Structure */
    {
    char path[67];
    unsigned attribute;
    void far *dpb_ptr;
    union { struct { unsigned dir_cluster; int unused[2]; } local;
	    struct { void far *redir_ptr; unsigned user_data; } network;
	  } x;
    unsigned root_length;
    };
struct dos_cds		/* MS-DOS version 4+ Current Directory Structure */
    {
    char path[67];
    unsigned attribute;
    void far *dpb_ptr;
    union { struct { unsigned dir_cluster; int unused[2]; } local;
	    struct { void far *redir_ptr; unsigned user_data; } network;
	  } x;
    unsigned root_length;
    unsigned char device_type;
    void far *ifs_redir_ptr;
    unsigned ifs_data;
    };
#pragma pack()
/*
 *   bit assignments for the attribute word from the CDS structures
 */
#define CDS_NETREDIR	0x8000
#define CDS_PHYSICAL	0x4000
#define CDS_JOIN	0x2000
#define CDS_SUBST	0x1000
#define CDS_CDROM	0x0080

static unsigned dos_version;
static unsigned number_of_floppies;
static char drive_number = 0;
static struct dos3_cds far *dos3_cds = NULL;
static struct dos_cds far  *dos_cds  = NULL;

/*****************************************************************************
 * NAME
 *    my_msdos_error_handler
 * ARGUMENTS
 *    deverror - ?
 *    errcode  - ?
 *    devhdr   - ?
 * DESCRIPTION
 *    MS-DOS error interrupt handler that essentially does nothing but set a
 *    flag.  see the Microsoft C manual for details.
 * RETURN VALUE
 *    ?
 */
static int my_msdos_error_flag = 0;
static int far my_msdos_error_handler(unsigned deverror, unsigned errcode,
							unsigned __far *devhdr)
{
my_msdos_error_flag = 1;
_hardretn(2);
_hardresume(_HARDERR_FAIL);	/* never reached */
return(-1);			/* never reached */
}

/*****************************************************************************
 * NAME
 *    getgid, getegid, getuid, geteuid
 * ARGUMENTS
 *    none
 * DESCRIPTION
 *    get the real or effective user or group ID number for the current user
 * RETURN VALUE
 *    for MS-DOS, a constant value (1)
 */
int getgid()  { return( 1 ); }
int getegid() { return( 1 ); }
int getuid()  { return( 1 ); }
int geteuid() { return( 1 ); }

/*****************************************************************************
 * NAME
 *    chown
 * ARGUMENTS
 *    file  - file pathname string
 *    user  - desired user number
 *    group - desired group number
 * DESCRIPTION
 *    change the owner/group of a file (no-op for MS-DOS)
 * RETURN VALUE
 *    0 if successful (and always succesful on MS-DOS)
 */
int chown(char *file, int user, int group)
{
return 0;
}

/*****************************************************************************
 * NAME
 *    getgrgid
 * ARGUMENTS
 *    gid - numeric group ID
 * DESCRIPTION
 *    obtain full information for a group
 * RETURN VALUE
 *    pointer to a static structure containing the group information
 */
struct group *getgrgid(int gid)
{
char *group;

group = getenv("GROUP");
if (group == (char *)NULL)
    group = "group";
strncpy(gr.gr_name, group, 19);
gr.gr_name[19] = NUL;
gr.gr_gid = gid;
return( &gr );
}

/*****************************************************************************
 * NAME
 *    getgrnam
 * ARGUMENTS
 *    name - name of a group
 * DESCRIPTION
 *    obtain full information for a group
 * RETURN VALUE
 *    pointer to a static structure containing the group information
 */
struct group *getgrnam(char *name)
{
strncpy(gr.gr_name, name, 19);
gr.gr_name[19] = NUL;
gr.gr_gid = 1;
return( &gr );
}

/*****************************************************************************
 * NAME
 *    getpwuid
 * ARGUMENTS
 *    uid - numeric user ID
 * DESCRIPTION
 *    obtain full information for a user
 * RETURN VALUE
 *    pointer to a static structure containing the user information
 */
struct passwd *getpwuid(int uid)
{
char *user;

user = getenv("USER");
if (user == (char *)NULL)
    user = getenv("LOGNAME");
if (user == (char *)NULL)
    user = "user";
strncpy(pw.pw_name, user, 19);
pw.pw_name[19] = NUL;
pw.pw_uid = uid;
return( &pw );
}

/*****************************************************************************
 * NAME
 *    getpwnam
 * ARGUMENTS
 *    name - name of a user
 * DESCRIPTION
 *    obtain full information for a user
 * RETURN VALUE
 *    pointer to a static structure containing the user information
 */
struct passwd *getpwnam(char *name)
{
strncpy(pw.pw_name, name, 19);
pw.pw_name[19] = NUL;
pw.pw_uid = 1;
return( &pw );
}

/*****************************************************************************
 * NAME
 *    endgrent, endpwent
 * ARGUMENTS
 *    none
 * DESCRIPTION
 *    no-ops on MS-DOS
 * RETURN VALUE
 *    none
 */
void endgrent() {}
void endpwent() {}

/*****************************************************************************
 * NAME
 *    statfs
 * ARGUMENTS
 *    path - pathname giving the filesystem (disk)
 *    buf  - pointer to a structure for receiving the disk information
 * DESCRIPTION
 *    fill the the usage and size information for a filesystem (disk)
 * RETURN VALUE
 *    0 if successful, -1 if an error occurs
 */
int statfs(const char *path, struct statfs *buf)
{
unsigned drive;
struct _diskfree_t diskspace;
/*
 *  Get the drive number
 */
if (path[1] == ':')
    drive = path[0] & 0x1F;
else
    _dos_getdrive(&drive);
/*
 *  Get free space info
 */
if (_dos_getdiskfree(drive, &diskspace) != 0)
    return -1;
/*
 *  Fill in the structure
 */
buf->f_bavail = diskspace.avail_clusters;
buf->f_bfree = diskspace.avail_clusters;
buf->f_blocks = diskspace.total_clusters;
buf->f_bsize = diskspace.sectors_per_cluster * diskspace.bytes_per_sector;
buf->f_ffree = -1L;
buf->f_files = -1L;
buf->f_type = 0;
return( 0 );
}

/*****************************************************************************
 * NAME
 *    setmntent
 * ARGUMENTS
 *    filename - name of a file supposedly describing the mounted filesystems
 *    type     - always "r" (assumed)
 * DESCRIPTION
 *    prepare to read the mounted filesystems as though from a file
 * RETURN VALUE
 *    fake input FILE pointer for "reading" the mounted filesystems
 */
FILE *setmntent(char *filename, char *type)
{
unsigned equipment;
unsigned x;
union _REGS inregs, outregs;
struct _SREGS segregs;
unsigned long longtemp;
char far *tableptr;

drive_number = 1;
equipment = _bios_equiplist();
if (equipment & 0x1)
    number_of_floppies = ((equipment & 0x00C0) >> 6) + 1;
else
    {
    number_of_floppies = 0;
    drive_number = 3;		/* no floppies */
    }
x = _bdos(DOSVERSION, 0, 0);
dos_version = (x << 8) + (x >> 8);	/* major in top byte for compares */
dos3_cds = (struct dos3_cds far *)NULL;
dos_cds  = (struct dos_cds far *)NULL;
if (dos_version >= 0x0300)
    {
    memset(&inregs, 0, sizeof(inregs));
    inregs.x.ax = GETLISTS;
    _intdosx(&inregs, &outregs, &segregs);
    if (outregs.x.cflag == 0)
	{
	longtemp = segregs.es;
	longtemp <<= 16;
	longtemp += outregs.x.bx;
	if (dos_version == 0x0300)
	    tableptr = (char far *)(longtemp + 0x17);
	else
	    tableptr = (char far *)(longtemp + 0x16);
	longtemp = *((unsigned long far *)tableptr);
	if ((dos_version & 0xFF00) == 0x0300)
	    dos3_cds = (struct dos3_cds far *)longtemp;
	else
	    dos_cds  = (struct dos_cds far *)longtemp;
	}
    }
return (FILE *)1;
}

/*****************************************************************************
 * NAME
 *    getmntent
 * ARGUMENTS
 *    filep - phony input FILE pointer for supposed filesystem mount file
 * DESCRIPTION
 *    read the information for the next filesystem
 * RETURN VALUE
 *    pointer to a "mntent" struct containing filesystem information, or NULL
 *    if there are no more filesystems left to describe
 */
struct mntent *getmntent(FILE *filep)
{
int i, j;
char *p;
void far *intvect;
unsigned old_drive, num_drives, drive;
char *old_cwd;
struct _find_t fileinfo;
static char mount_string[70];
static char filesystem_string[70];
static struct mntent mntent;
struct mntent *ret_value = NULL;
union _REGS inregs, outregs;
struct _SREGS segregs;
char far *tableptr;
char far *numptr;
unsigned long longtemp;
unsigned tablesize;

if ((filep == (FILE *)NULL) || (drive_number == 0))
    return( ret_value );
intvect = _dos_getvect(0x24);
_harderr(my_msdos_error_handler);
_dos_getdrive( &old_drive );
_dos_setdrive( old_drive, &num_drives );
for ( ; drive_number <= num_drives ; ++drive_number )
    {
    if ((drive_number == 2) && (number_of_floppies < 2))
	drive_number = 3;			/* don't have 2 floppies */
    /*
     *  try a simple BDOS call to determine whether this is a valid drive
     */
    memset(&inregs, 0, sizeof(inregs));
    inregs.x.ax = DRIVEDATA;
    inregs.h.dl = drive_number;
    _intdosx(&inregs, &outregs, &segregs);
    if (outregs.h.al == 0xFF)
	continue;				/* invalid drive */
    my_msdos_error_flag = 0;
    /*
     *  load the full root directory path for this drive into mount_string[]
     */
    i = drive_number - 1;
    memset(&fileinfo, 0, sizeof(fileinfo));
    memset(mount_string, 0, 70);
    memset(filesystem_string, 0, 70);
    if (    ((dos_version & 0xFF00) == 0x0300) &&
	    (dos3_cds != (struct dos3_cds far *)NULL) )
	{
	for ( j = 0 ; j < 70 ; ++j )
	    {
	    mount_string[j] = dos3_cds[i].path[j];
	    if (mount_string[j] == NUL)
		break;
	    }
	if (!(dos3_cds[i].attribute & CDS_JOIN))
	    mount_string[dos3_cds[i].root_length] = NUL;
	if (dos3_cds[i].attribute & CDS_SUBST)
	    {
	    strcpy(filesystem_string, mount_string);
	    mount_string[0] = 'A' + i;
	    mount_string[1] = ':';
	    mount_string[2] = NUL;
	    }
	}
    else if ( (dos_version >= 0x0400) &&
	      (dos_cds != (struct dos_cds far *)NULL) )
	{
	for ( j = 0 ; j < 70 ; ++j )
	    {
	    mount_string[j] = dos_cds[i].path[j];
	    if (mount_string[j] == NUL)
		break;
	    }
	if (!(dos_cds[i].attribute & CDS_JOIN))
	    mount_string[dos_cds[i].root_length] = NUL;
	if (dos_cds[i].attribute & CDS_SUBST)
	    {
	    strcpy(filesystem_string, mount_string);
	    mount_string[0] = 'A' + i;
	    mount_string[1] = ':';
	    mount_string[2] = NUL;
	    }
	}
    if (!isalpha(mount_string[0]) || (mount_string[1] != ':'))
	{				/* version 2.x or remote drive */
	mount_string[0] = 'A' + i;
	mount_string[1] = ':';
	mount_string[2] = NUL;
	}
    if ((strlen(mount_string) == 2) && (mount_string[1] == ':'))
	strcat(mount_string, "\\");
    _strlwr(mount_string);
    /*
     *  try to read the volume ID into fileinfo.name
     */
    i = mount_string[0] - 'a' + 1;
    _dos_setdrive( i, &num_drives );
    _dos_getdrive( &drive );
    if ((drive != i) || my_msdos_error_flag)
	continue;
    old_cwd = _getcwd((char *)NULL, 128);
    if (old_cwd != (char *)NULL)
	{
	if ((chdir(mount_string+2) == 0) && (my_msdos_error_flag == 0))
	    {
	    for ( p = strchr(mount_string,'\\') ; p ; p = strchr(p,'\\') )
		*p++ = '/';
	    _dos_findfirst("*.*", _A_VOLID, &fileinfo);
	    chdir(old_cwd);
	    free(old_cwd);
	    if (my_msdos_error_flag == 0)
		{
		if (fileinfo.name[0] == NUL)
		    strcpy(fileinfo.name, "(no label)");
		else
		    {
		    /* overwrite any spurious '.' in the volume name */
		    for ( p = strchr(fileinfo.name,'.') ; p && *p ; ++p )
			*p = *(p+1);
		    }
		}
	    }
	else
	    free(old_cwd);
	}
    if (filesystem_string[0] == NUL)
	strcpy(filesystem_string, fileinfo.name);
    if ((mount_string[0] & 0x1F) != drive_number)
	{
	memmove(filesystem_string+3, filesystem_string,
						  strlen(filesystem_string)+1);
	filesystem_string[0] = 'A' + drive_number - 1;
	filesystem_string[1] = ':';
	filesystem_string[2] = ' ';
	}
    mntent.mnt_fsname = filesystem_string;
    mntent.mnt_dir = mount_string;
    mntent.mnt_type = "msdos";
    if (dos_version >= 0x0300)
	{
	memset(&inregs, 0, sizeof(inregs));
	inregs.x.ax = IOCTL_CHANGEABLE;
	inregs.h.bl = drive_number;
	_intdos(&inregs, &outregs);
	if (outregs.x.cflag == 0)
	    mntent.mnt_type = (outregs.x.ax) ? "fixed" : "floppy";
	else
	    mntent.mnt_type = "other";
	}
    i = drive_number - 1;
    if (    ((dos_version & 0xFF00) == 0x0300) &&
	      (dos3_cds != (struct dos3_cds far *)NULL) )
	{
	if (	(dos3_cds[i].attribute & CDS_NETREDIR) &&
		(dos3_cds[i].attribute & CDS_PHYSICAL) &&
		(dos3_cds[i].attribute & CDS_CDROM) )
	    mntent.mnt_type = "cd-rom";
	else if (dos3_cds[i].attribute & CDS_NETREDIR)
	    mntent.mnt_type = "remote";
	else if (dos3_cds[i].attribute & CDS_SUBST)
	    mntent.mnt_type = "subst";
	}
    else if ( (dos_version >= 0x0400) &&
	      (dos_cds != (struct dos_cds far *)NULL) )
	{
	if (	(dos_cds[i].attribute & CDS_NETREDIR) &&
		(dos_cds[i].attribute & CDS_PHYSICAL) &&
		(dos_cds[i].attribute & CDS_CDROM) )
	    mntent.mnt_type = "cd-rom";
	else if (dos_cds[i].attribute & CDS_NETREDIR)
	    mntent.mnt_type = "remote";
	else if (dos_cds[i].attribute & CDS_SUBST)
	    mntent.mnt_type = "subst";
	}
    mntent.mnt_opts = "rw";		/* not really used ... */
    mntent.mnt_drive = drive_number;
    ret_value = &mntent;
    /*
     *  increment the drive number for the next call
     */
    drive_number++;
    break;
    }
_dos_setdrive( old_drive, &num_drives );
_dos_setvect(0x24, intvect);
return( ret_value );
}

/*****************************************************************************
 * NAME
 *    endmntent
 * ARGUMENTS
 *    filep - phony input FILE pointer for supposed filesystem mount file
 * DESCRIPTION
 *    clean up from "reading" the filesystem mount information
 * RETURN VALUE
 *    1 to indicate success (always successful)
 */
int endmntent(FILE *filep)
{
drive_number = 0;
return( 1 );
}

/*****************************************************************************
 * NAME
 *    sync
 * ARGUMENTS
 *    none
 * DESCRIPTION
 *    flush the disk buffers to disk -- but not really on MS-DOS...
 * RETURN VALUE
 *    none
 */
void sync() {}		/* what could be simpler? */

/******************************************************************************
 * EDIT HISTORY
 ******************************************************************************
 * 10-Feb-95	SRMc - start writing functions needed for the GNU file
 *			utilities
 * 16-Feb-95	SRMc - finish writing getmntent() and write sync()
 */
