/* Dos-specific stuff more Gnu Make under MSDOS.
Copyright (C) 1993, 1994 Morten Welinder.
This file is not part of GNU Make, but part of the MSDOS port of GNU Make.
This file may be copied under the same conditions as GNU Make:

GNU Make is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Make is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Make; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>
#include <stdlib.h>
#include "pwd.h"
#include "dosstuff.h"

struct passwd *
getpwnam (user)
     char *user;
{
  static struct passwd res;

  res.pw_dir = "/";
  return &res;
}

char *
getlogin ()
{
  return "root";
}

int
getegid ()
{
  return 0;
}

int
geteuid ()
{
  return 0;
}

int
dos_wait (status)
     int *status;
{
  int res = child_last_process;
  child_last_process = 0;
  *status = child_status >=0 ? child_status << 8 : 0x7f;
  return res;
}

char *
dosfilename (dst, src)
     char *dst, *src;
{
  char ch, *res = dst;
  int state = 0;

  if (src)
    {
      while (1)
	switch (ch = *src++)
	  {
	  case '\0':
	    *dst = 0;
	    return res;
	  case '\\':
	  case '/':
	    if (state != 0 || res == dst)
	      *dst++ = '/';
	    state = 0;
	    break;
	  case '.':
	    if (state <= 8)
	      {
		*dst++ = ch;
		state = 10;
		break;
	      }
	    else
	      {
		ch = '-';
		/* Fall through.  */
	      }
	  default:
	    switch (state)
	      {
	      case 0:
	      case 1:
	      case 2:
	      case 3:
	      case 4:
	      case 5:
	      case 6:
	      case 7:
	      case 10:
	      case 11:
	      case 12:
		*dst++ = tolower (ch);
		state++;
		break;
	      case 8:
	      case 13:
		*dst++ = ch;
		break;
	      }
	  }
    }
  else
    return src;
}

#ifdef __TURBOC__
void
getlongargs (argcp, argvp)
     int *argcp;
     char ***argvp;
{
  char *argcs = getenv ("_argc");
  char **av, **ep1, **ep2, tmp[10];
  int i, ac;

  if (*argcp <= 1 && argcs != NULL) 
    {
      ac = atoi (argcs);
      av = (char **) malloc ((ac + 1) * sizeof (char *));
      for (i = 1; i < ac; i++)
	{
	  sprintf (tmp, "_argv%d", i);
	  av[i] = getenv (tmp);
	}
      av[0] = (*argvp)[0];
      av[i] = 0;
      *argcp = ac;
      *argvp = av;
    }
  ep1 = ep2 = environ;
  while (*ep2)
    if (strncmp (*ep2, "_arg", 4))
      *ep1++ = *ep2++;
    else
      ep2++;
  *ep1 = NULL;
}
#endif

int child_process_counter = 1;
int child_last_process;
int child_status;

/* The current directory when we started.  */
char *initial_directory = 0;

#ifndef __GNUC__
/* If the last process executed was by way of a shell then this holds the
   real exit code.  */
unsigned char error_if_shell;
#endif
