Unit ShowView;

interface

uses App,Drivers,Objects,Views;

type pShow       = ^tShow;
     tShow       = record
                    Text : string;
                    Level : word;
                   end;
     pShowViewer = ^tShowViewer;
     tShowViewer = object(tView)
                    pShowCol   : pCollection;
                    Level      : word;
                    HScrollBar : pScrollBar;
                    VScrollBar : pScrollBar;
                    Palette : integer;
                    Constructor Init(var Bounds:tRect;AHScrollBar,AVScrollBar:pScrollBar);
                    Procedure Draw; virtual;
                    Procedure HandleEvent(var Event:tEvent); virtual;
                    Procedure SetLevel(ALevel:word); virtual;
                    Procedure SetText(ALevel:word;AText:String); virtual;
{                    Procedure ReDraw; virtual;}
                    Destructor Done; virtual;
                   end;

const spBlueView = 30;
      spCyanView = 48;

implementation

Constructor tShowViewer.Init(var Bounds:tRect;AHScrollBar,AVScrollBar:pScrollBar);

begin
 inherited Init(Bounds);
 Palette := spCyanView;
 HScrollBar := AHScrollBar;
 VScrollBar := AVscrollBar;
 pShowCol := New(pCollection,init(1,1));
 Level := 1;
 if HScrollBar <> nil then
  HScrollBar^.SetStep(10,1);
 if VScrollBar <> nil then
  VScrollBar^.SetStep(10,1);
 Options := Options or ofSelectable;
end;

Procedure tShowViewer.Draw;

var tBuf : tDrawBuffer;
    Regel,Item,NrNow : integer;
    MaxBreed,MaxAant : word;
    XOffset,YOffSet : integer;
    txt   : string;
    R     : tRect;

begin
 GetClipRect(R);
 MaxBreed := 0;MaxAant := 0;
 {Update ScrollBars}
 for Regel := 0 to pShowCol^.Count-1 do
 begin
  if tShow(pShowCol^.At(Regel)^).Level = Level then
  begin
   if length(tShow(pShowCol^.At(Regel)^).Text) > MaxBreed then
    MaxBreed := length(tShow(pShowCol^.At(Regel)^).Text);
   if tShow(pShowCol^.At(Regel)^).Level = Level then
    MaxAant := MaxAant+1;
  end;
 end;

 if HScrollbar = nil then
  XOffSet := 1
 else
 begin
  if MaxBreed+1 > (R.B.X-R.A.X) then
   HScrollBar^.SetRange(1,MaxBreed-(R.B.X-R.A.X)+2)
  else
   HScrollBar^.SetRange(1,0);
  XOffSet := HScrollBar^.Value+1;
 end;

 if VScrollbar = nil then
  YOffSet := 0
 else
 begin
  if MaxAant > (R.B.Y-R.A.Y) then
   VScrollBar^.SetRange(1,MaxAant-(R.B.Y-R.A.Y)+1)
  else
   VScrollBar^.SetRange(1,0);
  YOffSet := VScrollBar^.Value;
 end;

 for Regel := YOffset to YOffset+(R.B.Y-R.A.Y) do
 begin
  Item := 0;NrNow := -1;
  txt := '';
  repeat
   NrNow := NrNow+1;
   if NrNow < pShowCol^.Count then
    if tShow(pShowCol^.At(NrNow)^).Level = Level then
     Item := Item +1;
  until (Item = Regel)  or (NrNow >= pShowCol^.Count);
  if NrNow < pShowCol^.Count then
   txt := ' '+copy(tShow(pShowCol^.At(NrNow)^).Text,XOffSet-1,265);
  while length(txt) < (R.B.X-R.A.X) do
   txt := txt+' ';
  MoveStr(tBuf,txt,Palette);
  WriteBuf(0,(Regel-YOffSet),length(txt),1,tBuf);
 end;
end;

Procedure tShowViewer.HandleEvent(var Event:tEvent);

begin
 inherited HandleEvent(Event);
 if (Event.What = evBroadCast) then
 begin
  case Event.Command of
   cmScrollBarChanged : DrawView;
  else
   exit;
  end;
  ClearEvent(Event);
 end;
 if (Event.What = evKeyDown) and GetState(sfSelected) then
 begin
  case Event.KeyCode of
   kbLeft     : HSCrollBar^.SetValue(HScrollBar^.Value-1);
   kbRight    : HSCrollBar^.SetValue(HScrollBar^.Value+1);
   kbUp       : VSCrollBar^.SetValue(VScrollBar^.Value-1);
   kbDown     : VSCrollBar^.SetValue(VScrollBar^.Value+1);
   kbCtrlLeft : HSCrollBar^.SetValue(HScrollBar^.Value-HScrollBar^.PgStep);
   kbCtrlRight: HSCrollBar^.SetValue(HScrollBar^.Value+HScrollBar^.PgStep);
   kbPgUp     : VSCrollBar^.SetValue(VScrollBar^.Value-VScrollBar^.PgStep);
   kbPgDn     : VSCrollBar^.SetValue(VScrollBar^.Value+VScrollBar^.PgStep);
   kbHome     : VSCrollBar^.SetValue(VScrollBar^.Min);
   kbEnd      : VSCrollBar^.SetValue(VScrollBar^.Max);
  else
   exit;
  end;
  ClearEvent(Event);
 end;
end;

Procedure tShowViewer.SetLevel(ALevel:word);

begin
 if ALevel <> Level then
 begin
  Level := ALevel;
  DrawView;
 end;
end;

Procedure tShowViewer.SetText(ALevel:word;AText:string);

var pNew : pShow;

begin
 GetMem(pNew,SizeOf(tShow));
 pNew^.Level := ALevel;
 pNew^.Text := AText;
 pShowCol^.Insert(pNew);
 {Redraw;} DrawView;
end;

{Procedure tShowViewer.Redraw;

begin
 DrawView;
end;}

Destructor tShowViewer.Done;

var tel : integer;

begin
 if pShowCol^.Count > 0 then
  for tel := 0 to pShowCol^.Count-1 do
   FreeMem(pShowCol^.At(tel),SizeOf(tShow));
 pShowCol^.DeleteAll;
 inherited Done;
end;

end.