 ' Getvol is v1.0 of a findfile function for QB v4.5 which
 ' emulates a VOL$ function similar to the VOL$ function of BC7.

 DECLARE FUNCTION VOL$ (v$)

 ' get include files.
 REM $INCLUDE: 'dta.bi'
 REM $INCLUDE: 'qb.bi'

 ' common error trap variable
 COMMON SHARED Disk.Ready AS INTEGER

 ' get drive letter
 COLOR 15
 PRINT "Drive letter: ";
 c$ = ""
 DO
    c$ = INKEY$
    IF LEN(c$) = 1 THEN
       c$ = UCASE$(c$)
       IF c$ >= "A" AND c$ <= "Z" THEN
          EXIT DO
       END IF
    END IF
 LOOP
 PRINT c$

 ' get volume label
 x$ = VOL$(c$)

 ' compare result.
 IF x$ <> "" THEN
    COLOR 14
    PRINT x$
 END IF
 COLOR 7
 END

' simple error routine
ModuleError:
 ' device I/O error
 IF ERR = 57 THEN
    Disk.Ready = 57
    RESUME NEXT
 END IF
 ' disk not ready
 IF ERR = 71 THEN
    Disk.Ready = 71
    RESUME NEXT
 END IF
 ' path not found
 IF ERR = 76 THEN
    Disk.Ready = 76
    RESUME NEXT
 END IF
 END

FUNCTION VOL$(v$)
 ' define simple error routine
 ON ERROR GOTO ModuleError

 ' returns volume label for a drive letter. also checks validity of
 ' drive letter. also checks if disk not ready.

 DIM InregsX AS RegTypeX
 DIM OutregsX AS RegTypeX
 DIM DTAfile AS DTAtype
 DIM ASCIIZ AS STRING * 64
 DIM ASCIIZ2 AS STRING * 64
 DIM Current.DTA.SEG AS INTEGER
 DIM Current.DTA.OFF AS INTEGER

 ' check drive letter
 GOSUB CheckDrive

 ' store current dta
 InregsX.AX = &H2F00
 CALL InterruptX(&H21, InregsX, OutregsX)
 Current.DTA.SEG = OutregsX.ES
 Current.DTA.OFF = OutregsX.BX

 ' store function dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(DTAfile)
 InregsX.DX = VARPTR(DTAfile)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' findfirst
 ASCIIZ = V$ + ":\*.*" + CHR$(0)
 InregsX.AX = &H4E00
 InregsX.CX = &H8
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.DX = VARPTR(ASCIIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' check carry flag error
 Filename$ = ""
 IF (OutregsX.flags AND &H1) = &H0 THEN
    ' strip filename from ASCIIZ
    Filename$ = DTAfile.ASCIIZfilename
    Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)
 END IF

 ' restore current dta
 InregsX.AX = &H1A00
 InregsX.DS = Current.DTA.SEG
 InregsX.DX = Current.DTA.OFF
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' return volume label
 VOL$ = Filename$
 EXIT FUNCTION

' check drive.
CheckDrive:
 Disk.Ready = 0
 GOSUB StoreDrive
 Z$ = V$ + ":\"
 CHDIR Z$
 IF Disk.Ready THEN
    VOL$ = ""
    EXIT FUNCTION
 END IF
 CHDIR DefaultDir$
 RETURN

' store current drive/directory.
StoreDrive:
 InregsX.AX = &H1900
 CALL InterruptX(&H21, InregsX, OutregsX)
 Drive.Number = OutregsX.AX AND &HFF
 InregsX.AX = &H4700
 InregsX.DX = Drive.Number + 1
 InregsX.DS = VARSEG(ASCIIZ2)
 InregsX.SI = VARPTR(ASCIIZ2)
 CALL InterruptX(&H21, InregsX, OutregsX)
 DefaultDir$ = LEFT$(ASCIIZ2, INSTR(ASCIIZ2, CHR$(0)) - 1)
 IF LEFT$(DefaultDir$, 1) <> "\" THEN
    DefaultDir$ = "\" + DefaultDir$
 END IF
 RETURN
END FUNCTION
