DECLARE FUNCTION Hypotenuse! (a!, b!)
DECLARE FUNCTION PI! ()
DECLARE FUNCTION E! ()
DECLARE FUNCTION Sec! (X!)
DECLARE FUNCTION Cosec! (X!)
DECLARE FUNCTION Cotan! (X!)
DECLARE FUNCTION Arcsin! (X!)
DECLARE FUNCTION Arccos! (X!)
DECLARE FUNCTION Arcsec! (X!)
DECLARE FUNCTION Arccosec! (X!)
DECLARE FUNCTION Arccotan! (X!)
DECLARE FUNCTION HSin! (X!)
DECLARE FUNCTION HCos! (X!)
DECLARE FUNCTION HTan! (X!)
DECLARE FUNCTION HSec! (X!)
DECLARE FUNCTION HCosec! (X!)
DECLARE FUNCTION HCotan! (X!)
DECLARE FUNCTION HArcsin! (X!)
DECLARE FUNCTION HArccos! (X!)
DECLARE FUNCTION HArctan! (X!)
DECLARE FUNCTION HArcsec! (X!)
DECLARE FUNCTION HArccosec! (X!)
DECLARE FUNCTION HArccotan! (X!)
DECLARE FUNCTION RadToDeg! (X!)
DECLARE FUNCTION DegToRad! (X!)
REM nonintrinsic math functions
PRINT "PI="; PI
PRINT "Arccos of PI / 4="; Arccos(PI / 4)
PRINT "DegOf(Rad) of 90="; DegToRad(RadToDeg(90))
PRINT "Hypotenuse of 3, 4="; Hypotenuse(3, 4)

'Inverse Cosine
FUNCTION Arccos (X)
 Arccos = ATN(-X / SQR(-X * X + 1)) + PI / 2
 ' ATN(-X / SQR(-X * X + 1)) + 2 * ATN(1)
END FUNCTION

'Inverse Cosecant
FUNCTION Arccosec (X)
 Arccosec = ATN(X / SQR(X * X - 1)) + (SGN(X) - 1) * (PI / 2)
 ' ATN(X / SQR(X * X - 1)) + (SGN(X) - 1) * (2 * ATN(1))
END FUNCTION

'Inverse Cotangent
FUNCTION Arccotan (X)
 Arccotan = ATN(X) + PI / 2
 ' ATN(X) + 2 * ATN(1)
END FUNCTION

'Inverse Secant
FUNCTION Arcsec (X)
 Arcsec = ATN(X / SQR(X * X - 1)) + SGN((X) - 1) * (PI / 2)
 ' ATN(X / SQR(X * X - 1)) + SGN((X) - 1) * (2 * ATN(1))
END FUNCTION

'Inverse Sine
FUNCTION Arcsin (X)
 Arcsin = ATN(X / SQR(-X * X + 1))
END FUNCTION

'Cosecant
FUNCTION Cosec (X)
 Cosec = 1 / SIN(X)
END FUNCTION

'Cotangent
FUNCTION Cotan (X)
 Cotan = 1 / TAN(X)
END FUNCTION

'Convert Degrees to Radians
FUNCTION DegToRad (X)
 DegToRad = (PI / 180) * X
END FUNCTION

' E
FUNCTION E
 E = EXP(1)
END FUNCTION

'Inverse Hyperbolic Cosine
FUNCTION HArccos (X)
 HArccos = LOG(X + SQR(X * X - 1))
END FUNCTION

'Inverse Hyperbolic Cosecant
FUNCTION HArccosec (X)
 HArccosec = LOG((SGN(X) * SQR(X * X + 1) + 1) / X)
END FUNCTION

'Inverse Hyperbolic Cotangent
FUNCTION HArccotan (X)
 HArccotan = LOG((X + 1) / (X - 1)) / 2
END FUNCTION

'Inverse Hyperbolic Secant
FUNCTION HArcsec (X)
 HArcsec = LOG((SQR(-X * X + 1) + 1) / X)
END FUNCTION

'Inverse Hyperbolic Sine
FUNCTION HArcsin (X)
 HArcsin = LOG(X + SQR(X * X + 1))
END FUNCTION

'Inverse Hyperbolic Tangent
FUNCTION HArctan (X)
 HArctan = LOG((1 + X) / (1 - X)) / 2
END FUNCTION

'Hyperbolic Cosine
FUNCTION HCos (X)
 HCos = (EXP(X) + EXP(-X)) / 2
END FUNCTION

'Hyperbolic Cosecant
FUNCTION HCosec (X)
 HCosec = 2 / (EXP(X) - EXP(-X))
END FUNCTION

'Hyperbolic Cotangent
FUNCTION HCotan (X)
 HCotan = (EXP(X) + EXP(-X)) / (EXP(X) - EXP(-X))
END FUNCTION

'Hyperbolic Secant
FUNCTION HSec (X)
 HSec = 2 / (EXP(X) + EXP(-X))
END FUNCTION

'Hyperbolic Sine
FUNCTION HSin (X)
 HSin = (EXP(X) - EXP(-X)) / 2
END FUNCTION

'Hyperbolic Tangent
FUNCTION HTan (X)
 HTan = (EXP(X) - EXP(-X)) / (EXP(X) + EXP(-X))
END FUNCTION

FUNCTION Hypotenuse (a, b)
 Hypotenuse = SQR(a * a + b * b)
END FUNCTION

' PI
FUNCTION PI
 PI = ATN(1) * 4
END FUNCTION

'Convert Radians to Degrees
FUNCTION RadToDeg (X)
 RadToDeg = (180 / PI) * X
END FUNCTION

'Secant
FUNCTION Sec (X)
 Sec = 1 / COS(X)
END FUNCTION

