 REM Lights.bas v1.0 -- makes the keyboard shift state lights blink in patterns.

 PRINT "Blink! Press <esc> to quit:"
 Keyboard.Timer! = TIMER ' start timer
 Keyboard.Count = 10 ' reset shift type flag
 DO ' start shift state loop
    IF INKEY$ = CHR$(27) THEN ' check input
       Key.State = False
       GOSUB ShiftKey
       END
    END IF
    Elapsed.Time! = TIMER - Keyboard.Timer! ' get time elapsed
    IF Elapsed.Time! < 0! THEN
       Elapsed.Time! = Elapsed.Time! + 86400! ' check past midnight
    END IF
    IF Elapsed.Time! > 1! THEN ' compare to one second past
       Keyboard.Timer! = TIMER ' reset timer
       IF Keyboard.Count = False THEN ' check type of pattern
          IF Keyboard.Flag < 22 THEN ' check number of blinks
             Keyboard.Flag = Keyboard.Flag + 1 ' increment blink counter
             IF INT(Keyboard.Flag / 2) = Keyboard.Flag / 2 THEN ' alternate
                Key.State = False ' turn off lights
             ELSE
                Key.State = 112 ' turn on all lights
             END IF
             GOSUB ShiftKey ' change the lights
          ELSE
             IF Keyboard.Flag = 22 THEN ' reset counter to max.
                Keyboard.Flag = 23
             END IF
          END IF
       END IF
       IF Keyboard.Count > False THEN ' check type of pattern
          ' blink in binary
          SELECT CASE Shift.State
          CASE 0
             Key.State = 0
          CASE 1
             Key.State = 32 ' 100 = 1
          CASE 2
             Key.State = 64 ' 010 = 2
          CASE 3
             Key.State = 96 ' 110 = 3
          CASE 4
             Key.State = 16 ' 001 = 4
          CASE 5
             Key.State = 48 ' 101 = 5
          CASE 6
             Key.State = 80 ' 011 = 6
          CASE 7
             Key.State = 112 ' 111 = 7
          END SELECT
          GOSUB ShiftKey ' change the lights
          Shift.State = Shift.State + 1 ' increment state counter
          IF Shift.State = 8 THEN ' counted binary sequences
             Shift.State = False ' reset shift state
             Keyboard.Count = Keyboard.Count - 1 ' decrement counting times
             IF Keyboard.Count = False THEN ' check type of pattern
                Keyboard.Flag = False ' reset type
             END IF
          END IF
       END IF
    END IF
 LOOP ' end shift state loop
 END

 ' change the shift state lights
ShiftKey:
 DEF SEG = 0 ' point to segment
 POKE &H417, Key.State ' poke into the keyboard
 DEF SEG ' reset to point to basic
 RETURN

