

pnmtotiff(1)               Unix Programmer's Manual               pnmtotiff(1)


NAME
     pnmtotiff - convert a a portable anymap into a TIFF file

SYNOPSIS
     pnmtotiff [-none|-packbits| -lzw|-g3|-g4] [-2d] [-fill] [-predictor n] [-
                                                                         -
     msb2lsb|-lsb2msb] [-rowsperstrip n] [pnmfile]
                                      -   -------

DESCRIPTION
     Reads a portable anymap as input.  Produces a TIFF file as output.

OPTIONS

     By default, pnmtotiff creates a TIFF file with LZW compression.  This  is
                 ---------
     your  best  bet  most of the time.  However, some TIFF readers can't deal
     with it.  If you want to try another compression scheme or tweak some  of
     the  other  even more obscure output options, there are a number of flags
     to play with.

     The -none, -packbits, -lzw, -g3, and -g4 options are used to override the
     default  and set the compression scheme used in creating the output file.
     The CCITT Group 3 and Group 4 compression algorithms  can  only  be  used
     with  bilevel  data.   The -2d and -fill options are meaningful only with
     Group 3 compression:  -2d requests 2-dimensional  encoding,  while  -fill
     requests  that  each  encoded  scanline be zero-filled to a byte boundry.
     The  -predictor  option  is  only  meaningful  with  LZW  compression:  a
     predictor  value of 2 causes each scanline of the output image to undergo
     horizontal differencing before it is encoded; a value of  1  forces  each
     scanline to be encoded without differencing.

     By default, pnmtotiff creates a TIFF file  with  msb-to-lsb  fill  order.
                 ---------
     The  -msb2lsb  and  -lsb2msb options are used to override the default and
     set the fill order used in creating the file.

     The  -rowsperstrip  option  can  be  used  to  set  the  number  of  rows
     (scanlines)  in  each  strip of data in the output file.  By default, the
     output file has the number of rows per strip set to  a  value  that  will
     ensure each strip is no more than 8 kilobytes long.

BUGS
     This program is not self-contained.  To use it you must  fetch  the  TIFF
     Software  package  listed in the OTHER.SYSTEMS file and configure PBMPLUS
     to  use  libtiff.   See  PBMPLUS's   Makefile   for   details   on   this
     configuration.

SEE ALSO
     tifftopnm(1), pnm(5)

AUTHOR
     Derived by Jef Poskanzer from ras2tiff.c, which is Copyright (c) 1990  by
     Sun     Microsystems,     Inc.      Author:     Patrick    J.    Naughton
     (naughton@wind.sun.com).







                               13 January 1991                               1

