/*===========================================================================
SOLAR :: ..\common\compress.c

Original Author: Kevin Houle <kjhoule@iowegia.des-moines.ia.us>
This software module has been placed into the public domain.
===========================================================================*/

/* Header Files */
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <process.h>
#include <stdlib.h>
#include "..\common\compress.h"

/*
 * Function: long compress_packet()
 * Purpose : Calls selected compression program to compress packet files.
 * Return  : Byte count on success, zero if nothing is compressed.
*/

long compress_packet()
{
	struct ffblk ffblk;

  char compress_path[420];
	char packet_name[MAXPATH];

  int done;

  /* Load the compression program info from the config file */

  if (load_compress_parms() != 0) goto ErrorExit;

  /* Set the current directory to the temporary directory. */

  if (set_directory(temp_path) != 0) goto ErrorExit;

  /* Determine where to build packet. In LOCAL mode,
     create in user's directory. Otherwise, create
     in Solar temporary directory. */

  if (strnicmp(speed,"LOCAL",5) == 0)
    strcpy(packet_name,user_path);
  else
    strcpy(packet_name,temp_path);

  /* Build the packet name based on the host
     site's uucp name and the compression type */

  strcat(packet_name,"\\");
  strcat(packet_name,uucpname);
	strcat(packet_name,".");
	strcat(packet_name,compress);

  /* Test to see if a packet file exists.
     If so, unlink it. */

  if (findfirst(packet_name,&ffblk,0) == 0)
    unlink(packet_name);

  /* Check to make sure there are still files to compress */

  if (findfirst("*.*",&ffblk,0) != 0)
    goto NoWorkExit;

  /* Add AREAS, *.MSG, and *.IDX files to
     compress path. */

  strcpy(compress_path,AREAS_NAME);
	strcat(compress_path," ");
  strcat(compress_path,"*.");
	strcat(compress_path,BATCH_EXT);
  strcat(compress_path," ");
  strcat(compress_path,"*.");
	strcat(compress_path,INDEX_EXT);

  /* Check to see if there was a LIST file
     built and present in temp directory. */

  if (findfirst(LIST_NAME,&ffblk,0) == 0)
  {
    /* Add LIST file to compress path */

    strcat(compress_path," ");
    strcat(compress_path,LIST_NAME);
  }

  /* Check to see if there was a INFO file
     built and present in temp directory. */

  if (findfirst(INFO_NAME,&ffblk,0) == 0)
  {
    /* Add INFO file to compress path */

    strcat(compress_path," ");
    strcat(compress_path,INFO_NAME);
  }

  /* Check to see if there was a ERRORS file
     built and present in temp directory. */

  if (findfirst(ERRORS_NAME,&ffblk,0) == 0)
  {
    /* Add ERRORS file to compress path */

    strcat(compress_path," ");
    strcat(compress_path,ERRORS_NAME);
  }

  /* Initialize SPAWNO to swap to disk. */

  if (diskswap == YES)
  {
    if (verbose == YES)
      RPrintf("Initializing swap to %s\n",swap_path);
    init_SPAWNO(swap_path,SWAP_DISK);
  }

  /* Announce what we are doing, and spawn the
     compression program */

  RPrintf("\nCompressing packet in %s format...\n",compress);
  if (spawnlp(P_WAIT,program,program,options,packet_name,compress_path,NULL) != 0)
	{
    sprintf(_slrerr,"error spawning %s",program);
		goto ErrorExit;
	}

  /* Unlink all of the files we just compressed
     into the packet file */

  strcpy(compress_path,AREAS_NAME);
  unlink(compress_path);
  strcpy(compress_path,INFO_NAME);
  unlink(compress_path);
  strcpy(compress_path,LIST_NAME);
  unlink(compress_path);
  strcpy(compress_path,ERRORS_NAME);
  unlink(compress_path);

  strcpy(compress_path,"*.");
	strcat(compress_path,BATCH_EXT);
  done = findfirst(compress_path,&ffblk,0);
	while (!done)
	{
    unlink(ffblk.ff_name);
		done = findnext(&ffblk);
	}

  strcpy(compress_path,"*.");
  strcat(compress_path,INDEX_EXT);
  done = findfirst(compress_path,&ffblk,0);
	while (!done)
	{
    unlink(ffblk.ff_name);
		done = findnext(&ffblk);
	}

  /* Check to make sure there is a packet */

  if (findfirst(packet_name,&ffblk,0) != 0)
	{
		strcpy(_slrerr,"No packet generated!");
		goto ErrorExit;
	}

GoodExit:
  return ffblk.ff_fsize;
NoWorkExit:
  strcpy(_slrerr,"Nothing to compress.");
  return 0L;
ErrorExit:
  return 0L;
}

/*
Function: load_compress_parms()
Purpose : Load the appropriate compress parameters from the Solar
          configuration file.
Return  : 0 on success, non-zero on error and set _slrerr.
*/

int load_compress_parms()
{
	FILE *config_file = fopen(config_path,"rt");

	int idx  = 0;

	char buf[128];
	char search_string[20];
	char *p = NULL;

	if (!config_file)
	{
    sprintf(_slrerr,"error opening config file %s", config_path);
    goto ErrorExit;
  }

  strcpy(program,"NONE");
  options[0] = '\0';
  strcpy(search_string,"compress-");
  strcat(search_string,compress);

  while (fgets(buf,128,config_file) != NULL)
	{
		if (strnicmp(buf,"compress",8) == 0)
		{
			if ((p = strtok(buf,"=")) == NULL)
			{
        strcpy(_slrerr,"invalid \"compress\" line in config file");
        goto ErrorExit;
			}
			idx = 0;
      while ((p[idx] != '\n') && (p[idx] != '\0')) /* strip the LF and add a null character */
      {
				p[idx] = p[idx++];
      }
			p[idx] = '\0';
      if (stricmp(p,search_string) == 0)
			{
        if ((p = strtok(NULL,"=")) == NULL)
        {
          strcpy(_slrerr,"invalid \"compress\" line in config file");
          goto ErrorExit;
        }
				idx = 0;
        while ((p[idx] != '\n') && (p[idx] != '\0')) /* copy back into buf, drop LF */
        {
					buf[idx] = p[idx++];
        }
				buf[idx] = '\0';
        if ((p = strtok(buf," ")) != NULL)
				{
					idx = 0;
          while ((p[idx] != '\n') && (p[idx] != '\0')) /* strip the LF and add a null character */
          {
						program[idx] = p[idx++];
          }
					program[idx] = '\0';
          if ((p = strtok(NULL,"=")) != NULL)
          {
						idx = 0;
            while ((p[idx] != '\n') && (p[idx] != '\0')) /* strip the LF and add a null character */
            {
							options[idx] = p[idx++];
						}
						options[idx] = '\0';
          }
          else
          {
            options[0] = '\0';
          }
        }
        else
        {
          strcpy(_slrerr,"invalid \"compress\" line in config file");
          goto ErrorExit;
        }
				break;
      }
    }
  }
  fclose(config_file);

	if (strcmp(program,"NONE") == 0)
	{
    sprintf(_slrerr,"compress program not found for type %s",compress);
    goto ErrorExit;
	}

GoodExit:
  return 0;
ErrorExit:
  if (config_file) fclose(config_file);
  return 1;
}

