/*===========================================================================
SOLAR :: ..\common\endian.c

Contributed by Pat Cain and Rhys Weatherley.
This software module has been placed into the public domain.
===========================================================================*/

/*
 * Function: long binlen(char bigendian[4])
 * Purpose : Convert 4-byte array into 32-bit long value.
 * Return  : Length of message in bytes, or 0 on EOF or error.
*/

long binlen(char bigendian[4])
{
  return (((((long)(bigendian[0])) & 0xFF) << 24) |
      ((((long)(bigendian[1])) & 0xFF) << 16) |
      ((((long)(bigendian[2])) & 0xFF) <<  8) |
      ((((long)(bigendian[3])) & 0xFF)));
}

/*
 * Function: char *long_to_endian(long long_value)
 * Purpose : Convert 32-bit long into 4-byte array in big endian order.
 * Return  : 4-byte array in big endian order, ERR\0 on error.
*/

char *long_to_endian(long long_value)
{
  static char temp[4];

  temp[0] = long_value >> 24;
  temp[1] = (long_value >> 16) & 0xff;
  temp[2] = (long_value >> 8) & 0xff;
  temp[3] = long_value & 0xff;

  return(temp);
}
