/*===========================================================================
SOLAR v0.95.1 :: Common module rfctime.c

This source code has been placed into the public domain.

History:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
07-15-94 LL  Contributed by Lars Lindgren <lasse@argh.dude.pp.se>
08-31-94 KJH Moved tz lookup into config.c's load_static, and changed
             to accept whitespace (i.e. 'timezone  :  +0600')
===========================================================================*/

/*
 * Function: char *rfctime(char *timezone)
 * Purpose : Generates time string in RFC 822. Searches Waffle's STATIC
 *           file for 'timezone:' string.
 *           Format: Mon, 02 May 1994 00:26:18 +0200
 * Return  : Pointer to time string, NULL on error.
 * Non-ANSI functions used: strftime(), strncmpi()
*/

#define TRUE  (0==0)
#define FALSE (0==1)
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <dir.h>

extern char tz[15];

char *rfctime()
{
  char *get_tz();
  static char time_string[35];
  struct tm *time_now;
  time_t t;

  time(&t);
  time_now = localtime(&t);

  if ((strftime(time_string,30,"%a, %d %b %Y %H:%M:%S ",time_now)) == 0) {
    return NULL;
  }

  strcat(time_string, tz);

  return(time_string);
}

