/*===========================================================================
SOLAR v0.95.3 slrcmd :: Module - ..\slrcmd\config.h
Original author : Kevin Houle <kjhoule@iowegia.des-moines.ia.us>

This source code has been released into the public domain.
===========================================================================*/

/* Common Includes */

#include "..\common\soup.h"
#include "..\common\yesno.h"

/* Static Data Definitions */

#define OPTIONS_NAME    "OPTIONS.SLR"
#define ONCE                        2

/* Global Data Storage */

char   temp_path[MAXPATH];        /* Path to temporary directory      */
char   user_path[MAXPATH];        /* Path to user's directory         */
char   config_path[MAXPATH];      /* Full path to Solar config file   */
char   log_path[MAXPATH];         /* Full path to Solar log file      */
char   static_path[MAXPATH];      /* Full path to Waffle's static     */
char   waffle_path[MAXPATH];      /* Full path to Waffle root dir     */
char   system_path[MAXPATH];      /* Path to Waffle system directory  */
char   swap_path[MAXPATH];        /* Path to swap directory           */
char   newsgroups_path[MAXPATH];  /* Path to newsgroup descriptions   */
int    diskswap;                  /* Swap slrcmd to disk ?            */
int    use_fossil;                /* For FOSSIL use                   */
int    port;                      /* COM port for FOSSIL, 0 = COM1:   */
int    verbose;                   /* Verbose mode toggle              */
char   _slrerr[80];               /* Global error message buffer      */

int    mail_type;                 /* SOUP mail message format          */
int    delete_mail;               /* Delete mailbox?                   */
int    send_mail;                 /* Send mail?                        */
int    send_list;                 /* Send list file?                   */
int    news_type;                 /* SOUP message format               */
int    news_index;                /* SOUP index format                 */
int    use_wafjoin;               /* Use Waffle's JOIN file            */
long   news_area_bytes;           /* Max. number of bytes per msg area */
long   news_area_messages;        /* Max. number of msgs per msg area  */
long   news_total_bytes;          /* Max. number of bytes total        */
long   news_total_messages;       /* Max. number of messages total     */
char   default_keyword;           /* Default newsrc.slr keyword        */
char   protocol[10];              /* Transfer protocol type            */
char   compress[10];              /* File compression type             */
char   uucpname[15];              /* System UUCP name                  */

/* External Global Functions */

extern char *extract_parm(char string[128], char delimiter);
extern int  convert_to_number(char *argument);

/* Local Global Functions */

int get_compress_type(char buf[128]);

