/*===========================================================================
SOLAR slrreply :: Module ..\slrreply\lost.c
Original author : Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This source code has been placed into the public domain.
===========================================================================*/

#include <dir.h>
#include <string.h>
#include <stdlib.h>
#include "lost.h"

/*
 * Function: int lost_packet()
 * Purpose : A fatal error occurred and the entire packet could have
 *           been lost. Move the packet to the lost directory.
 * Return  : 0 on success, non-zero on error and set _slrerr.
*/

int lost_packet()
{
  struct ffblk ffblk;
  char newpath[MAXPATH];
  int done;

  done = findfirst("*.*",&ffblk,0);
  while (!done)
  {
    strcpy(newpath,lost_path);
    strcat(newpath,"\\");
    strcat(newpath,ffblk.ff_name);
    if (copyfile(ffblk.ff_name,newpath) != 0)
    {
      goto ErrorExit;
    }
    unlink(ffblk.ff_name);
    done = findnext(&ffblk);
  }

GoodExit:
  return 0;
ErrorExit:
  return -1;
}

/*
 * Function: int lost_message(char *msg_path)
 * Purpose : A fatal error occurred and all or part of a message file has
 *           been lost. Move the message to the lost directory.
 * Return  : 0 on success, non-zero on error and set _slrerr.
*/

int lost_message(char *msg_path)
{
  char newpath[MAXPATH];

  strcpy(newpath,lost_path);
  strcat(newpath,"\\");
  strcat(newpath,msg_path);
  if (copyfile(msg_path,newpath) != 0)
  {
    goto ErrorExit;
  }
GoodExit:
  return 0;
ErrorExit:
  return -1;
}

